/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.snpEffect;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.snpEffect.SnpEffectPredictor;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class Config
implements Serializable,
Iterable<String> {
    public static final String DEFAULT_CONFIG_FILE = "snpEff.config";
    public static final String DEFAULT_DATA_DIR = "./data";
    public static final String KEY_BUNDLE_SUFIX = ".bundle";
    public static final String KEY_CODON_PREFIX = "codon.";
    public static final String KEY_CODONTABLE_SUFIX = ".codonTable";
    public static final String KEY_COORDINATES = "coordinates";
    public static final String KEY_DATA_DIR = "data.dir";
    public static final String KEY_DATABASE_LOCAL = "database";
    public static final String KEY_DATABASE_REPOSITORY = "database.repository";
    public static final String KEY_DATABASE_REPOSITORY_KEY = "database.repositoryKey";
    public static final String KEY_DBNSFP_FIELDS = "dbnsfp.fields";
    public static final String KEY_GENOME_SUFIX = ".genome";
    public static final String KEY_LOF_IGNORE_PROTEIN_CODING_AFTER = "lof.ignoreProteinCodingAfter";
    public static final String KEY_LOF_IGNORE_PROTEIN_CODING_BEFORE = "lof.ignoreProteinCodingBefore";
    public static final String KEY_LOF_DELETE_PROTEIN_CODING_BASES = "lof.deleteProteinCodingBases";
    public static final String KEY_REFERENCE_SUFIX = ".reference";
    public static final String KEY_VERSIONS_URL = "versions.url";
    public static final String[] COMPATIBLE_WITH_5_4 = new String[]{"5.3", "5.2", "5.1", "5.0"};
    public static final String[] COMPATIBLE_WITH_5_3 = new String[]{"5.2", "5.1", "5.0"};
    public static final String[] COMPATIBLE_WITH_5_2 = new String[]{"5.1", "5.0"};
    public static final String[] COMPATIBLE_WITH_5_1 = new String[]{"5.0"};
    public static final Map<String, String[]> DATABASE_COMPATIBLE_VERSIONS = Map.of("5.1", COMPATIBLE_WITH_5_1, "5.2", COMPATIBLE_WITH_5_2, "5.3", COMPATIBLE_WITH_5_3, "5.4", COMPATIBLE_WITH_5_4);
    private static final long serialVersionUID = 877453207407217465L;
    public static String GENOMES_DIR = "genomes";
    public static String DEFAULT_COORDINATES = "GRCh37";
    private static Config configInstance = null;
    boolean debug = false;
    boolean verbose = false;
    boolean quiet = false;
    boolean treatAllAsProteinCoding;
    boolean onlyRegulation;
    boolean errorOnMissingChromo;
    boolean errorChromoHit;
    boolean expandIub = true;
    boolean hgvs = true;
    boolean hgvsShift = true;
    boolean hgvsOneLetterAa = false;
    boolean hgvsOld = false;
    boolean hgvsTrId = false;
    double lofIgnoreProteinCodingAfter;
    double lofIgnoreProteinCodingBefore;
    double lofDeleteProteinCodingBases;
    String configFileName = "";
    String configFileCanonicaPath;
    String configDirPath = "";
    String dataDir;
    String genomeVersion;
    Properties properties;
    Genome genome;
    HashMap<String, Genome> genomeById;
    HashMap<String, String> referenceById;
    HashMap<String, String> nameById;
    HashMap<String, String> bundleByGenomeId;
    SnpEffectPredictor snpEffectPredictor;
    String databaseRepository = "";
    String databaseRepositoryKey = "";
    String versionsUrl = "";

    public Config(Genome genome) {
        this.genomeVersion = genome.getVersion();
        this.genome = genome;
        configInstance = this;
    }

    public Config(String genomeVersion) {
        this.init(genomeVersion, DEFAULT_CONFIG_FILE, null, null);
    }

    public Config(String genomeVersion, String configFileName) {
        this.init(genomeVersion, configFileName, null, null);
    }

    public Config(String genomeVersion, String configFileName, String dataDir, Map<String, String> override) {
        this.init(genomeVersion, configFileName, dataDir, override);
    }

    public Config(String genomeVersion, String configFileName, String dataDir, Map<String, String> override, boolean verbose) {
        this.verbose = verbose;
        this.init(genomeVersion, configFileName, dataDir, override);
    }

    public static Config get() {
        return configInstance;
    }

    public static Config reset() {
        configInstance = null;
        return null;
    }

    String canonicalDir(String dirName) {
        if (((String)dirName).startsWith("~/")) {
            dirName = Gpr.HOME + "/" + ((String)dirName).substring(2);
        } else if (((String)dirName).startsWith("~")) {
            dirName = Gpr.HOME + "/" + ((String)dirName).substring(1);
        } else if (!((String)dirName).startsWith("/")) {
            dirName = this.configDirPath + "/" + (String)dirName;
        }
        while (((String)dirName).endsWith("/")) {
            dirName = ((String)dirName).substring(0, ((String)dirName).length() - 1);
        }
        return dirName;
    }

    void createCodonTables(String genomeId, Properties properties) {
        for (Object k : properties.keySet()) {
            String key = k.toString().trim();
            if (!key.startsWith(KEY_CODON_PREFIX)) continue;
            String name = key.substring(KEY_CODON_PREFIX.length());
            String table = properties.getProperty(key);
            if (this.debug) {
                Log.debug("Reading codon table '" + name + "'");
            }
            CodonTable codonTable = new CodonTable(name, table);
            CodonTables.getInstance().add(codonTable);
        }
        for (Object key : properties.keySet()) {
            String keyStr = key.toString();
            if (!keyStr.endsWith(KEY_CODONTABLE_SUFIX) || !keyStr.startsWith(genomeId + ".")) continue;
            int chrNameEnd = keyStr.length() - KEY_CODONTABLE_SUFIX.length();
            int chrNameStart = genomeId.length() + 1;
            int chrNameLen = chrNameEnd - chrNameStart;
            String chromo = null;
            if (chrNameLen > 0) {
                chromo = keyStr.substring(chrNameStart, chrNameEnd);
            }
            String codonTableName = properties.getProperty(key.toString());
            CodonTable codonTable = CodonTables.getInstance().getTable(codonTableName);
            if (codonTable == null) {
                throw new RuntimeException("Error parsing property '" + String.valueOf(key) + "'. No such codon table '" + codonTableName + "'");
            }
            Genome gen = this.getGenome(genomeId);
            if (gen == null) {
                throw new RuntimeException("Error parsing property '" + String.valueOf(key) + "'. No such genome '" + genomeId + "'");
            }
            if (chromo != null) {
                Chromosome chr = gen.getOrCreateChromosome(chromo);
                if (this.verbose) {
                    Log.info("Codon table '" + codonTableName + "' assigned to chromosome '" + chr.getChromosomeName() + "'");
                }
                CodonTables.getInstance().set(this.genomeById.get(genomeId), chr, codonTable);
                continue;
            }
            Log.info("Codon table '" + codonTableName + "' for genome '" + genomeId + "'");
            CodonTables.getInstance().set(this.genomeById.get(genomeId), codonTable);
        }
    }

    public List<URL> downloadUrl(String genomeVer) {
        List<String> versions = this.getDatabaseCompatibilityVersions();
        LinkedList<URL> urls = new LinkedList<URL>();
        for (String version : versions) {
            urls.add(this.downloadUrl(genomeVer, version));
        }
        return urls;
    }

    public URL downloadUrl(String genomeVer, String version) {
        try {
            String bundleName;
            version = version.replace('.', '_');
            String urlRoot = this.getDatabaseRepository();
            if (urlRoot == null || urlRoot.isEmpty()) {
                throw new RuntimeException("Cannot find database repository. Missing 'database.repository' property in config file?");
            }
            StringBuilder urlsb = new StringBuilder();
            urlsb.append(urlRoot);
            if (urlsb.charAt(urlRoot.length() - 1) != '/') {
                urlsb.append("/");
            }
            if ((bundleName = this.getBundleName(genomeVer)) != null) {
                urlsb.append("v" + version + "/snpEff_v" + version + "_" + bundleName + ".zip");
            } else {
                urlsb.append("v" + version + "/snpEff_v" + version + "_" + genomeVer + ".zip");
            }
            if (this.databaseRepositoryKey != null && !this.databaseRepositoryKey.isEmpty()) {
                urlsb.append(this.databaseRepositoryKey);
            }
            return new URL(urlsb.toString());
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    String findConfigFile(String configFile) {
        try {
            File confFile = new File(configFile);
            if (this.verbose) {
                Log.info("Looking for config file: '" + confFile.getCanonicalPath() + "'");
            }
            if (confFile.exists() && confFile.canRead()) {
                return confFile.getCanonicalPath();
            }
            if (confFile.isAbsolute()) {
                throw new RuntimeException("Cannot find config file '" + confFile.getCanonicalPath() + "'");
            }
            String confPath = this.getRelativeConfigPath() + "/" + configFile;
            confFile = new File(confPath);
            if (confFile.exists() && confFile.canRead()) {
                return confFile.getCanonicalPath();
            }
            throw new RuntimeException("Cannot find config file '" + configFile + "'\n");
        }
        catch (FileNotFoundException e) {
            throw new RuntimeException("Cannot find config file '" + configFile + "'");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String getBaseFileNameGenes() {
        return this.dataDir + "/" + this.genome.getVersion() + "/genes";
    }

    public String getBaseFileNameMotif() {
        return this.getDirDataGenomeVersion() + "/motif";
    }

    public String getBaseFileNameRegulation() {
        return this.getDirDataGenomeVersion() + "/regulation";
    }

    public String getBaseFileNameSequence() {
        return this.getDirData() + "/" + this.genome.getVersion() + "/sequence";
    }

    public String getBundleName(String genomeVer) {
        return this.bundleByGenomeId.get(genomeVer);
    }

    public String getConfigFileName() {
        return this.configFileName;
    }

    public String getConfigFileCanonicaPath() {
        return this.configFileCanonicaPath;
    }

    public String getCoordinates() {
        String coords = this.getString(this.genomeVersion + ".coordinates");
        if (coords != null) {
            return coords;
        }
        coords = this.genomeVersion.split("\\.")[0];
        return coords.isEmpty() ? DEFAULT_COORDINATES : coords;
    }

    public List<String> getDatabaseCompatibilityVersions() {
        LinkedList<String> dcv = new LinkedList<String>();
        dcv.add("5.4");
        String[] moreVersions = DATABASE_COMPATIBLE_VERSIONS.get("5.4");
        if (moreVersions != null) {
            for (String v : moreVersions) {
                dcv.add(v);
            }
        }
        return dcv;
    }

    public String getDatabaseLocal(String dbName) {
        String dbLocal = this.properties.getProperty(this.getDatabaseLocalKey(dbName), "");
        if (dbLocal.isEmpty()) {
            return "";
        }
        return this.canonicalDir(dbLocal);
    }

    public String getDatabaseLocalKey(String dbName) {
        String coordinates = this.getCoordinates();
        if (coordinates == null) {
            throw new RuntimeException("Cannot find coordinates config entry for genome '" + this.genomeVersion + "'");
        }
        return "database." + dbName + "." + coordinates;
    }

    public String getDatabaseRepository() {
        return this.databaseRepository;
    }

    public String getDatabaseRepository(String dbName) {
        String coordinates = this.getCoordinates();
        if (coordinates == null) {
            throw new RuntimeException("Cannot find coordinates config entry for genome '" + this.genomeVersion + "'");
        }
        return this.properties.getProperty("database.repository." + dbName + "." + coordinates, "");
    }

    public URL getDatabaseRepositoryUrl(String dbName) {
        String repo = this.getDatabaseRepository(dbName);
        if (repo == null || repo.isEmpty()) {
            return null;
        }
        try {
            return new URL(repo);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getDbNsfpFields() {
        String coordinates = this.getCoordinates();
        if (coordinates == null) {
            if (this.verbose) {
                Log.info("Cannot find coordinates config entry for genome '" + this.genomeVersion + "'");
            }
            return null;
        }
        return this.properties.getProperty("dbnsfp.fields." + coordinates, "");
    }

    public String getDirData() {
        return this.dataDir;
    }

    public String getDirDataGenomeVersion() {
        return this.dataDir + "/" + this.genome.getVersion();
    }

    public String getDirMain() {
        File dir = new File(this.dataDir);
        return dir.getParent();
    }

    public String getDirRegulationBed() {
        return this.getDirDataGenomeVersion() + "/regulation.bed/";
    }

    public double getDouble(String propertyName, double defaultValue) {
        String val = this.getString(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return Gpr.parseDoubleSafe(val);
    }

    public List<String> getFileListGenomeFasta() {
        ArrayList<String> files = new ArrayList<String>();
        files.add(this.getDirData() + "/genomes/" + this.genome.getVersion() + ".fa");
        files.add(this.getDirData() + "/" + this.genome.getVersion() + "/sequences.fa");
        return files;
    }

    public String getFileNameCds() {
        return this.getDirDataGenomeVersion() + "/cds.fa";
    }

    public String getFileNameGenomeFasta() {
        for (String f : this.getFileListGenomeFasta()) {
            if (new File(f).exists()) {
                return f;
            }
            if (!new File(f + ".gz").exists()) continue;
            return f;
        }
        return null;
    }

    public String getFileNameProteins() {
        return this.getDirDataGenomeVersion() + "/protein.fa";
    }

    public String getFileNameSequence() {
        return this.getBaseFileNameSequence() + ".bin";
    }

    public String getFileNameSequence(String chr) {
        String chrNameSafe = Gpr.sanityzeFileName(chr);
        return this.getBaseFileNameSequence() + "." + chrNameSafe + ".bin";
    }

    public String getFileSnpEffectPredictor() {
        return this.getDirData() + "/" + this.genome.getVersion() + "/snpEffectPredictor.bin";
    }

    public Genome getGenome() {
        return this.genome;
    }

    public Genome getGenome(String genomeId) {
        return this.genomeById.get(genomeId);
    }

    public String getGenomeVersion() {
        return this.genomeVersion;
    }

    public double getLofDeleteProteinCodingBases() {
        return this.lofDeleteProteinCodingBases;
    }

    public double getLofIgnoreProteinCodingAfter() {
        return this.lofIgnoreProteinCodingAfter;
    }

    public double getLofIgnoreProteinCodingBefore() {
        return this.lofIgnoreProteinCodingBefore;
    }

    public long getLong(String propertyName, long defaultValue) {
        String val = this.getString(propertyName);
        if (val == null) {
            return defaultValue;
        }
        return Gpr.parseLongSafe(val);
    }

    public String getName(String genomeVersion) {
        return this.nameById.get(genomeVersion);
    }

    public String getProperty(String property) {
        if (!this.properties.containsKey(property)) {
            if (this.isDebug()) {
                Log.warning("Property '" + property + "' not found in config file '" + this.getConfigFileCanonicaPath() + "'");
            }
            return null;
        }
        return this.properties.getProperty(property);
    }

    public String[] propertyToStringArray(String attr) {
        String value = this.properties.getProperty(attr);
        if (value == null) {
            return new String[0];
        }
        String[] values = value.split("[\\s+,]");
        LinkedList<String> list = new LinkedList<String>();
        for (String val : values) {
            if (val.length() <= 0) continue;
            list.add(val);
        }
        return list.toArray(new String[0]);
    }

    public String getReference(String genomeVersion) {
        return this.referenceById.get(genomeVersion);
    }

    String getRelativeConfigPath() {
        URL url = Config.class.getProtectionDomain().getCodeSource().getLocation();
        try {
            File path = new File(url.toURI());
            return path.getParent();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot get path '" + String.valueOf(url) + "'", e);
        }
    }

    public SnpEffectPredictor getSnpEffectPredictor() {
        return this.snpEffectPredictor;
    }

    public void setSnpEffectPredictor(SnpEffectPredictor snpEffectPredictor) {
        this.snpEffectPredictor = snpEffectPredictor;
    }

    public String getString(String propertyName) {
        return this.properties.getProperty(propertyName);
    }

    public String getString(String propertyName, String defaultValue) {
        return this.properties.getProperty(propertyName, defaultValue);
    }

    public String getVersionsUrl() {
        return this.versionsUrl;
    }

    void init(String genomeVersion, String configFileName, String dataDir, Map<String, String> override) {
        this.treatAllAsProteinCoding = false;
        this.onlyRegulation = false;
        this.errorOnMissingChromo = true;
        this.errorChromoHit = true;
        this.configFileName = configFileName;
        this.genomeVersion = genomeVersion;
        this.dataDir = dataDir;
        this.configFileCanonicaPath = this.findConfigFile(configFileName);
        this.readConfig(this.configFileCanonicaPath, override);
        this.genome = this.genomeById.get(genomeVersion);
        if (!genomeVersion.isEmpty() && this.genome == null) {
            throw new RuntimeException("No such genome '" + genomeVersion + "' in config file '" + this.configFileCanonicaPath + "'");
        }
        configInstance = this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isErrorChromoHit() {
        return this.errorChromoHit;
    }

    public void setErrorChromoHit(boolean errorChromoHit) {
        this.errorChromoHit = errorChromoHit;
    }

    public boolean isErrorOnMissingChromo() {
        return this.errorOnMissingChromo;
    }

    public void setErrorOnMissingChromo(boolean errorOnMissingChromo) {
        this.errorOnMissingChromo = errorOnMissingChromo;
    }

    public boolean isExpandIub() {
        return this.expandIub;
    }

    public void setExpandIub(boolean expandIub) {
        this.expandIub = expandIub;
    }

    public boolean isHgvs() {
        return this.hgvs;
    }

    public boolean isHgvs1LetterAA() {
        return this.hgvsOneLetterAa;
    }

    public boolean isHgvsOld() {
        return this.hgvsOld;
    }

    public void setHgvsOld(boolean hgvsDnaOld) {
        this.hgvsOld = hgvsDnaOld;
    }

    public boolean isHgvsShift() {
        return this.hgvsShift;
    }

    public void setHgvsShift(boolean hgvsShift) {
        this.hgvsShift = hgvsShift;
    }

    public boolean isHgvsTrId() {
        return this.hgvsTrId;
    }

    public void setHgvsTrId(boolean hgvsTrId) {
        this.hgvsTrId = hgvsTrId;
    }

    public boolean isOnlyRegulation() {
        return this.onlyRegulation;
    }

    public void setOnlyRegulation(boolean onlyRegulation) {
        this.onlyRegulation = onlyRegulation;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    public void setQuiet(boolean quiet) {
        this.quiet = quiet;
    }

    public boolean isTreatAllAsProteinCoding() {
        return this.treatAllAsProteinCoding;
    }

    public void setTreatAllAsProteinCoding(boolean treatAllAsProteinCoding) {
        this.treatAllAsProteinCoding = treatAllAsProteinCoding;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public Iterator<String> iterator() {
        return this.nameById.keySet().iterator();
    }

    public List<String> keys() {
        Set<Object> keyset = this.properties.keySet();
        ArrayList<String> l = new ArrayList<String>(keyset.size());
        for (Object o : keyset) {
            l.add(o.toString());
        }
        return l;
    }

    boolean loadProperties(String configPath) {
        try {
            File confFile = new File(configPath);
            if (this.verbose) {
                Log.info("Reading config file: " + confFile.getCanonicalPath());
            }
            if (Gpr.canRead(configPath)) {
                FileReader freader = new FileReader(confFile);
                this.properties.load(freader);
                this.configDirPath = confFile.getCanonicalFile().getParent();
                freader.close();
                return true;
            }
        }
        catch (Exception e) {
            this.properties = null;
            this.configDirPath = "";
            throw new RuntimeException(e);
        }
        return false;
    }

    public SnpEffectPredictor loadSnpEffectPredictor() {
        this.snpEffectPredictor = SnpEffectPredictor.load(this);
        this.genome = this.snpEffectPredictor.genome;
        this.snpEffectPredictor.setDebug(this.debug);
        return this.snpEffectPredictor;
    }

    private void readConfig(String configPath, Map<String, String> override) {
        this.readProperties(configPath, override);
        if (this.dataDir == null) {
            this.dataDir = this.properties.getProperty(KEY_DATA_DIR, DEFAULT_DATA_DIR);
        }
        this.dataDir = this.canonicalDir(this.dataDir);
        this.databaseRepository = this.unquote(this.properties.getProperty(KEY_DATABASE_REPOSITORY, ""));
        this.databaseRepositoryKey = this.unquote(this.properties.getProperty(KEY_DATABASE_REPOSITORY_KEY, ""));
        this.genomeById = new HashMap();
        this.referenceById = new HashMap();
        this.nameById = new HashMap();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object k : this.properties.keySet()) {
            keys.add(k.toString());
        }
        Collections.sort(keys);
        for (String key : keys) {
            if (!key.endsWith(KEY_GENOME_SUFIX)) continue;
            String genVer = key.substring(0, key.length() - KEY_GENOME_SUFIX.length());
            String name = this.properties.getProperty(genVer + KEY_GENOME_SUFIX);
            this.nameById.put(genVer, name);
            String ref = this.properties.getProperty(genVer + KEY_REFERENCE_SUFIX);
            this.referenceById.put(genVer, ref);
        }
        this.bundleByGenomeId = new HashMap();
        for (String key : keys) {
            if (!key.endsWith(KEY_BUNDLE_SUFIX)) continue;
            String bundleName = key.substring(0, key.length() - KEY_BUNDLE_SUFIX.length());
            String entries = this.properties.getProperty(key);
            for (String gen : entries.split("\\s+")) {
                gen = gen.trim();
                this.bundleByGenomeId.put(gen, bundleName);
            }
        }
        if (!this.genomeVersion.isEmpty()) {
            this.readGenomeConfig(this.genomeVersion, this.properties);
            this.genome = new Genome(this.genomeVersion, this);
            this.genomeById.put(this.genomeVersion, this.genome);
            this.createCodonTables(this.genomeVersion, this.properties);
        }
        this.setFromProperties();
    }

    void readGenomeConfig(String genVer, Properties properties) {
        block4: {
            String genomePropsFileName = this.dataDir + "/" + genVer + "/snpEff.config";
            try {
                Properties genomeProps = new Properties();
                genomeProps.load(new FileReader(new File(genomePropsFileName)));
                for (Object propKey : genomeProps.keySet()) {
                    String pk = propKey.toString();
                    String propVal = genomeProps.getProperty(pk);
                    if (properties.getProperty(pk) == null) {
                        properties.setProperty(pk, propVal);
                        continue;
                    }
                    System.err.println("Ignoring property '" + pk + "' in file '" + genomePropsFileName + "'");
                }
            }
            catch (Exception e) {
                if (!this.debug) break block4;
                System.err.println("File '" + genomePropsFileName + "' not found");
            }
        }
    }

    void readProperties(String configPath, Map<String, String> override) {
        this.properties = new Properties();
        if (!this.loadProperties(configPath)) {
            throw new RuntimeException("Cannot read config file '" + configPath + "'\n");
        }
        if (override != null) {
            for (String key : override.keySet()) {
                this.properties.setProperty(key, override.get(key));
            }
        }
    }

    void setFromProperties() {
        this.versionsUrl = this.getString(KEY_VERSIONS_URL);
        this.lofIgnoreProteinCodingAfter = this.getDouble(KEY_LOF_IGNORE_PROTEIN_CODING_AFTER, 0.95);
        this.lofIgnoreProteinCodingBefore = this.getDouble(KEY_LOF_IGNORE_PROTEIN_CODING_BEFORE, 0.05);
        this.lofDeleteProteinCodingBases = this.getDouble(KEY_LOF_DELETE_PROTEIN_CODING_BASES, 0.5);
    }

    public void setHgvsOneLetterAA(boolean hgvsOneLetterAa) {
        this.hgvsOneLetterAa = hgvsOneLetterAa;
    }

    public void setString(String propertyName, String value) {
        this.properties.setProperty(propertyName, value);
    }

    public void setUseHgvs(boolean useHgvs) {
        this.hgvs = useHgvs;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        for (Object object : this.properties.keySet()) {
            keys.add(object.toString());
        }
        Collections.sort(keys);
        for (String string : keys) {
            sb.append("\t" + string + " = '" + this.properties.getProperty(string) + "'\n");
        }
        for (String string : this) {
            String name = this.nameById.get(string).replace('_', ' ');
            String ref = this.referenceById.get(string);
            sb.append("\t" + string);
            sb.append("\t" + name);
            if (ref != null) {
                sb.append("\t" + ref);
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String unquote(String s) {
        if (s == null || s.length() < 2) {
            return s;
        }
        int l = s.length();
        if (s.charAt(0) == '\"' && s.charAt(l - 1) == '\"' || s.charAt(0) == '\'' && s.charAt(l - 1) == '\'') {
            return s.substring(1, l - 1);
        }
        return s;
    }
}

