/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.reactome.events;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.snpeff.reactome.Entity;
import org.snpeff.reactome.events.Event;
import org.snpeff.util.Gpr;

public class Reaction
extends Event {
    public static final double MAX_WEIGHT_SUM = 1.1;
    protected HashMap<Entity, Double> inputs = new HashMap();
    protected HashSet<Entity> outputs = new HashSet();
    protected HashSet<Entity> catalyst = new HashSet();
    protected HashMap<Entity, RegulationType> regulator = new HashMap();

    public Reaction(int id, String name) {
        super(id, name);
    }

    public void addCatalyst(Entity e) {
        this.catalyst.add(e);
    }

    public void addInput(Entity e) {
        if (e == null) {
            return;
        }
        if (!this.inputs.containsKey(e)) {
            this.inputs.put(e, 1.0);
        } else {
            this.inputs.put(e, this.inputs.get(e) + 1.0);
        }
    }

    public void addOutput(Entity e) {
        this.outputs.add(e);
        if (e.isReaction()) {
            ((Reaction)e).addInput(this);
        }
    }

    public void addRegulator(Entity e, RegulationType type) {
        this.regulator.put(e, type);
    }

    public void addRegulator(Entity e, String type) {
        this.regulator.put(e, RegulationType.valueOf(type));
    }

    @Override
    public double calc(HashSet<Entity> doneEntities) {
        if (!Double.isNaN(this.fixedOutput)) {
            this.output = this.fixedOutput;
        } else {
            if (doneEntities.contains(this)) {
                return this.output;
            }
            doneEntities.add(this);
            for (Entity ein : this.getInputs()) {
                ein.calc(doneEntities);
            }
            for (Entity ecat : this.catalyst) {
                ecat.calc(doneEntities);
            }
            for (Entity ereg : this.regulator.keySet()) {
                ereg.calc(doneEntities);
            }
            double in = 0.0;
            for (Entity ein : this.getInputs()) {
                if (!ein.hasOutput()) continue;
                in += ein.getOutput() * this.inputs.get(ein);
            }
            double inCat = 0.0;
            for (Entity ecat : this.catalyst) {
                if (!ecat.hasOutput()) continue;
                inCat += ecat.getOutput();
            }
            double inRegPos = 0.0;
            double inRegNeg = 0.0;
            double inRegReq = 0.0;
            int countPos = 0;
            int countNeg = 0;
            int countReq = 0;
            for (Entity ereg : this.regulator.keySet()) {
                if (!ereg.hasOutput()) continue;
                double inReg = ereg.getOutput();
                RegulationType regType = this.regulator.get(ereg);
                switch (regType.ordinal()) {
                    case 1: {
                        inRegPos += inReg;
                        ++countPos;
                        break;
                    }
                    case 0: {
                        inRegNeg += inReg;
                        ++countNeg;
                        break;
                    }
                    case 2: {
                        inRegReq += inReg;
                        ++countReq;
                    }
                }
            }
            if (Double.isInfinite(in) || Double.isNaN(in)) {
                this.output = Double.NaN;
            } else {
                double z = this.sigm(in);
                double cat = 2.0 * this.sigm(inCat);
                double regPos = 1.0;
                double regNeg = 1.0;
                double regReq = 1.0;
                if (countPos > 0) {
                    regPos = 1.0 + this.sigm(inRegPos);
                }
                if (countNeg > 0) {
                    regNeg = 1.0 - this.sigm(inRegNeg);
                }
                if (countReq > 0) {
                    regReq = this.sigm(inRegReq);
                }
                this.output = 2.0 * (z * cat * regPos * regNeg * regReq) - 1.0;
            }
        }
        if (debug) {
            System.out.println(this.output + "\tfixed:" + this.isFixed() + "\tid:" + this.id + "\ttype:" + this.getClass().getSimpleName() + "\tname:" + this.name);
        }
        return this.output;
    }

    public HashSet<Entity> getCatalyst() {
        return this.catalyst;
    }

    public Collection<Entity> getInputs() {
        return this.inputs.keySet();
    }

    public HashSet<Entity> getOutputs() {
        return this.outputs;
    }

    public HashMap<Entity, RegulationType> getRegulator() {
        return this.regulator;
    }

    @Override
    public boolean isReaction() {
        return true;
    }

    public void scaleWeights() {
        if (this.inputs.size() <= 1) {
            return;
        }
        double sum = 0.0;
        for (Double in : this.inputs.values()) {
            sum += Math.abs(in);
        }
        if (sum < 1.1) {
            return;
        }
        HashMap<Entity, Double> newInputs = new HashMap<Entity, Double>();
        for (Entity e : this.inputs.keySet()) {
            double weight = this.inputs.get(e) / sum;
            newInputs.put(e, weight);
        }
        this.inputs = newInputs;
    }

    double sigm(double x) {
        return 1.0 / (1.0 + Math.exp(-Entity.BETA * x));
    }

    @Override
    public String toString() {
        return this.toString(0, new HashSet<Entity>());
    }

    @Override
    public String toString(int tabs, HashSet<Entity> done) {
        done.add(this);
        StringBuilder sb = new StringBuilder();
        sb.append(Gpr.tabs(tabs) + this.getClass().getSimpleName() + "[" + this.id + "]: " + this.name + "\n");
        if (!this.inputs.isEmpty()) {
            sb.append(Gpr.tabs(tabs + 1) + "Inputs:\n");
            for (Entity e : this.getInputs()) {
                if (done.contains(e)) {
                    sb.append(Gpr.tabs(tabs + 2) + e.toStringSimple() + "\n");
                    continue;
                }
                done.add(e);
                sb.append(e.toString(tabs + 2, done) + "\n");
            }
        }
        if (!this.outputs.isEmpty()) {
            sb.append(Gpr.tabs(tabs + 1) + "Outputs:\n");
            for (Entity e : this.outputs) {
                if (done.contains(e)) {
                    sb.append(Gpr.tabs(tabs + 2) + e.toStringSimple() + "\n");
                    continue;
                }
                done.add(e);
                sb.append(e.toString(tabs + 2, done) + "\n");
            }
        }
        if (!this.catalyst.isEmpty()) {
            sb.append(Gpr.tabs(tabs + 1) + "Catalysts:\n");
            for (Entity e : this.catalyst) {
                if (done.contains(e)) {
                    sb.append(Gpr.tabs(tabs + 2) + e.toStringSimple() + "\n");
                    continue;
                }
                done.add(e);
                sb.append(e.toString(tabs + 2, done) + "\n");
            }
        }
        if (!this.regulator.isEmpty()) {
            sb.append(Gpr.tabs(tabs + 1) + "Regulator:\n");
            for (Entity e : this.regulator.keySet()) {
                if (done.contains(e)) {
                    sb.append(Gpr.tabs(tabs + 2) + e.toStringSimple() + "(" + String.valueOf((Object)this.regulator.get(e)) + ")\t\n");
                    continue;
                }
                done.add(e);
                sb.append(e.toString(tabs + 2, done) + "(" + String.valueOf((Object)this.regulator.get(e)) + ")\t\n");
            }
        }
        return sb.toString();
    }

    protected double transferFunction(double h, double inCat, double inRegPos, double inRegNeg, double inRegReq) {
        double z = 1.0 / (1.0 + Math.exp(-Entity.BETA * h));
        double cat = 2.0 / (1.0 + Math.exp(-Entity.BETA * inCat));
        double regPos = 1.0 + 1.0 / (1.0 + Math.exp(-Entity.BETA * inRegPos));
        double regNeg = 1.0 - 1.0 / (1.0 + Math.exp(-Entity.BETA * inRegNeg));
        double regReq = 1.0 / (1.0 + Math.exp(-Entity.BETA * inRegReq));
        return 2.0 * (z * cat * regPos * regNeg * regReq) - 1.0;
    }

    public static enum RegulationType {
        NegativeRegulation,
        PositiveRegulation,
        Requirement;

    }
}

