/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.reactome;

import java.util.Collection;
import java.util.HashSet;
import org.snpeff.reactome.Compartment;
import org.snpeff.util.Gpr;

public class Entity
implements Comparable<Entity> {
    public static boolean debug = false;
    public static TransferFunction TRANSFER_FUNCTION = TransferFunction.SIGM_PLUS_MINUS;
    public static double BETA = 3.0;
    protected int id;
    protected String name;
    protected Compartment compartment;
    protected double output;
    protected double weight;
    protected double fixedOutput;
    protected HashSet<String> geneIds;

    public Entity(int id, String name) {
        this.id = id;
        this.name = name;
        this.reset();
    }

    public void addGeneId(String geneId) {
        if (this.geneIds == null) {
            this.geneIds = new HashSet();
        }
        this.geneIds.add(geneId);
    }

    public double calc() {
        return this.calc(new HashSet<Entity>());
    }

    public double calc(HashSet<Entity> doneEntities) {
        if (doneEntities.contains(this)) {
            return this.output;
        }
        doneEntities.add(this);
        this.output = !Double.isNaN(this.fixedOutput) ? this.fixedOutput : this.getWeight();
        if (debug) {
            System.out.println(this.output + "\tfixed:" + this.isFixed() + "\tid:" + this.id + "\ttype:" + this.getClass().getSimpleName() + "\tname:" + this.name);
        }
        return this.output;
    }

    @Override
    public int compareTo(Entity e) {
        int cmp = this.getName().compareTo(e.getName());
        if (cmp != 0) {
            return cmp;
        }
        return this.getId() - e.getId();
    }

    public Compartment getCompartment() {
        return this.compartment;
    }

    public Collection<String> getGeneIds() {
        return this.geneIds;
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public double getOutput() {
        return this.output;
    }

    public double getWeight() {
        return this.weight;
    }

    public boolean hasOutput() {
        return !Double.isNaN(this.output);
    }

    public boolean isFixed() {
        return !Double.isNaN(this.fixedOutput);
    }

    public boolean isReaction() {
        return false;
    }

    public void reset() {
        this.output = 0.0;
        this.fixedOutput = Double.NaN;
        this.weight = Double.NaN;
    }

    public void setCompartment(Compartment compartment) {
        this.compartment = compartment;
    }

    public void setFixedOutput(double fixedOutput) {
        this.fixedOutput = fixedOutput;
    }

    public void setWeight(double weight) {
        this.weight = weight;
    }

    public String toString() {
        return this.toString(0, new HashSet<Entity>());
    }

    public String toString(int tabs, HashSet<Entity> done) {
        done.add(this);
        return Gpr.tabs(tabs) + this.getClass().getSimpleName() + "[" + this.id + "]: " + this.name;
    }

    public String toStringSimple() {
        return this.getClass().getSimpleName() + "[" + this.id + "]: " + this.name;
    }

    protected double transferFunction(double x) {
        switch (TRANSFER_FUNCTION.ordinal()) {
            case 3: {
                return 2.0 / (1.0 + Math.exp(-BETA * x)) - 1.0;
            }
            case 0: {
                return x;
            }
            case 2: {
                return 1.0 / (1.0 + Math.exp(-BETA * x));
            }
            case 1: {
                return Math.tanh(BETA * x);
            }
        }
        throw new RuntimeException("Unimplemented transfer function: " + String.valueOf((Object)TRANSFER_FUNCTION));
    }

    public static enum TransferFunction {
        LINEAR,
        TANH,
        SIGM,
        SIGM_PLUS_MINUS;

    }
}

