/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.probablility.bootstrap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import org.snpeff.probablility.bootstrap.ReSampleInt;

public class ReSampleMapRank
extends ReSampleInt {
    HashMap<String, Double> scoreByName;
    HashMap<String, Integer> rankByName;

    public ReSampleMapRank(HashMap<String, Double> scoresByName, int sampleSize) {
        super(null, sampleSize);
        this.scoreByName = scoresByName;
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(scoresByName.keySet());
        Collections.sort(names, new Comparator<String>(){

            @Override
            public int compare(String arg0, String arg1) {
                return ReSampleMapRank.this.scoreByName.get(arg0).compareTo(ReSampleMapRank.this.scoreByName.get(arg1));
            }
        });
        this.rankByName = new HashMap();
        this.scores = new int[names.size()];
        double latest = Double.NaN;
        int rank = 0;
        for (int i2 = 0; i2 < names.size(); ++i2) {
            String name = (String)names.get(i2);
            double score = scoresByName.get(name);
            if (latest != score) {
                ++rank;
            }
            latest = score;
            this.rankByName.put(name, rank);
            this.scores[i2] = rank;
        }
    }

    public int score(Collection<String> names) {
        int sum = 0;
        for (String name : names) {
            if (this.rankByName.get(name) == null) {
                throw new RuntimeException("Error: Entry '" + name + "' not found!");
            }
            sum += this.rankByName.get(name).intValue();
        }
        return sum;
    }
}

