/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.probablility;

import DistLib.normal;
import org.apfloat.Apcomplex;
import org.apfloat.Apfloat;
import org.snpeff.probablility.NormalDistribution;
import org.snpeff.util.Log;

public class RankSumPdf {
    public static final int CACHE_MAX_N = 40;
    public static final int CACHE_MAX_NT = 40;
    public static final Apfloat BAD = new Apfloat(-1L);
    static int cacheHit;
    static int cacheMiss;
    static Apfloat[][][] cachePdf;
    static Apfloat[][][] cacheCdf;
    public static double SMALL;

    private static Apfloat cacheGetCdf(int n, int nt, int r) {
        return cacheCdf[n][nt][r];
    }

    private static Apfloat cacheGetPdf(int n, int nt, int r) {
        return cachePdf[n][nt][r];
    }

    private static void cacheInit() {
        int maxRankSum;
        int nt;
        int n;
        System.out.println("RankSumPdf: Initializing cache");
        cachePdf = new Apfloat[41][41][];
        cacheCdf = new Apfloat[41][41][];
        for (n = 1; n <= 40; ++n) {
            for (nt = 1; nt <= 40; ++nt) {
                maxRankSum = n * nt;
                RankSumPdf.cachePdf[n][nt] = new Apfloat[maxRankSum + 1];
                RankSumPdf.cacheCdf[n][nt] = new Apfloat[maxRankSum + 1];
                for (int rs = 1; rs <= maxRankSum; ++rs) {
                    RankSumPdf.cachePdf[n][nt][rs] = BAD;
                    RankSumPdf.cacheCdf[n][nt][rs] = BAD;
                }
            }
        }
        System.out.print("Initializing rankSum Pdf/Cdf caches:");
        for (n = 1; n <= 40; ++n) {
            System.out.print('.');
            for (nt = 1; nt < n; ++nt) {
                maxRankSum = n * nt;
                Apfloat c = new Apfloat(0L);
                for (int r = 1; r <= maxRankSum; ++r) {
                    Apfloat p = RankSumPdf.pdf(n, nt, r);
                    c = c.add(p);
                    RankSumPdf.cacheSetCdf(n, nt, r, c);
                }
            }
        }
        System.out.println("done");
    }

    private static void cacheSetCdf(int n, int nt, int r, Apfloat p) {
        RankSumPdf.cacheCdf[n][nt][r] = p;
        ++cacheMiss;
    }

    private static void cacheSetPdf(int n, int nt, int r, Apfloat p) {
        RankSumPdf.cachePdf[n][nt][r] = p;
        ++cacheMiss;
    }

    public static boolean canBeCached(int n, int nt) {
        return n <= 40 && nt <= 40;
    }

    public static Apfloat cdf(int n, int nt, int r) {
        if (nt <= 0 || nt > n) {
            return Apcomplex.ZERO;
        }
        if (n <= 0) {
            return Apcomplex.ZERO;
        }
        long max = RankSumPdf.maxRankSum(n, nt);
        long min = RankSumPdf.minRankSum(n, nt);
        if ((long)r < min) {
            return Apcomplex.ZERO;
        }
        if ((long)r >= max) {
            return Apcomplex.ONE;
        }
        if (!RankSumPdf.canBeCached(n, nt)) {
            return RankSumPdf.cdfNormal(n, nt, r);
        }
        Apfloat cdf = RankSumPdf.cacheGetCdf(n, nt, r);
        if (cdf.compareTo((Apfloat)Apcomplex.ZERO) >= 0) {
            ++cacheHit;
            return cdf;
        }
        Apfloat sum = new Apfloat(0L);
        for (int i2 = 1; i2 <= r; ++i2) {
            sum = sum.add(RankSumPdf.pdf(n, nt, i2));
        }
        RankSumPdf.cacheSetCdf(n, nt, r, sum);
        return sum;
    }

    public static Apfloat cdfNormal(int n, int nt, int r) {
        double mu = RankSumPdf.mean(n, nt);
        double sigma = RankSumPdf.sigma(n, nt);
        Apfloat cdf = NormalDistribution.cdf(r, mu, sigma);
        return cdf;
    }

    public static boolean isOk(Apfloat p) {
        return p.compareTo(BAD) != 0;
    }

    public static void main(String[] args) {
        System.out.println("Begin: RankSumPdf");
        for (double x = 0.0; x > -100.0; x -= 1.0) {
            Apfloat cdf = NormalDistribution.cdf(x, 0.0, 1.0);
            Log.debug("x: " + x + "\tcdf: " + String.valueOf(cdf) + "\tcdfOri: " + normal.cumulative((double)x, (double)0.0, (double)1.0) + "\t" + new org.apache.commons.math3.distribution.NormalDistribution(0.0, 1.0).density(x));
        }
        System.out.println("End: RankSumPdf");
    }

    public static long maxRankSum(int n, int nt) {
        return (long)nt * (long)n;
    }

    public static double mean(int n, int nt) {
        return (double)nt * ((double)n + 1.0) / 2.0;
    }

    public static long minRankSum(int n, int nt) {
        return nt;
    }

    public static Apfloat pdf(int n, int nt, int r) {
        if (nt <= 0 || nt > n) {
            return Apcomplex.ZERO;
        }
        if (n <= 0) {
            return Apcomplex.ZERO;
        }
        long max = RankSumPdf.maxRankSum(n, nt);
        long min = RankSumPdf.minRankSum(n, nt);
        if ((long)r < min) {
            return Apcomplex.ZERO;
        }
        if ((long)r > max) {
            return Apcomplex.ZERO;
        }
        if (nt == 1) {
            double p = 1.0 / (double)n;
            return new Apfloat(p);
        }
        if (!RankSumPdf.canBeCached(n, nt)) {
            return RankSumPdf.pdfNormal(n, nt, r);
        }
        Apfloat pdf = RankSumPdf.cacheGetPdf(n, nt, r);
        if (pdf.compareTo((Apfloat)Apcomplex.ZERO) >= 0) {
            ++cacheHit;
            return pdf;
        }
        Apfloat sum = new Apfloat(0L);
        int maxSum = Math.max(Math.min(r - nt + 1, n), 1);
        for (int i2 = 1; i2 <= maxSum; ++i2) {
            sum.add(RankSumPdf.pdf(n, nt - 1, r - i2));
        }
        Apfloat p = sum.divide(new Apfloat((long)n));
        RankSumPdf.cacheSetPdf(n, nt, r, p);
        return p;
    }

    public static Apfloat pdfNormal(int n, int nt, int r) {
        double mu = RankSumPdf.mean(n, nt);
        double sigma = RankSumPdf.sigma(n, nt);
        return NormalDistribution.pdf(n, mu, sigma);
    }

    public static double sigma(int n, int nt) {
        return Math.sqrt(RankSumPdf.variance(n, nt));
    }

    public static double variance(int n, int nt) {
        double dn = n;
        return (double)nt * (dn * dn - 1.0) / 12.0;
    }

    static {
        SMALL = 1.0E-20;
        RankSumPdf.cacheInit();
        cacheMiss = 0;
        cacheHit = 0;
    }
}

