/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.probablility;

import org.apache.commons.math3.special.Gamma;
import org.snpeff.probablility.Hypergeometric;

public class FisherExactTest {
    private static FisherExactTest fisherExactTest = null;
    Hypergeometric hd = Hypergeometric.get();

    public static FisherExactTest get() {
        if (fisherExactTest == null) {
            fisherExactTest = new FisherExactTest();
        }
        return fisherExactTest;
    }

    private FisherExactTest() {
    }

    public boolean canUseChiSquareApproximation(int k, int N, int D, int n) {
        double n11 = k;
        double n12 = D - k;
        double n21 = n - k;
        double n22 = N + k - n - D;
        double N1d = n11 + n12;
        double N2d = n21 + n22;
        double Nd1 = n11 + n21;
        double Nd2 = n12 + n22;
        double Ndd = N;
        double E11 = N1d * Nd1 / Ndd;
        double E12 = N1d * Nd2 / Ndd;
        double E21 = N2d * Nd1 / Ndd;
        double E22 = N2d * Nd2 / Ndd;
        return !(E11 < 10.0 || E12 < 10.0 || E21 < 10.0) && !(E22 < 10.0);
    }

    public double chiSquareApproximation(int k, int N, int D, int n) {
        double n11 = k;
        double n12 = D - k;
        double n21 = n - k;
        double n22 = N + k - n - D;
        double N1d = n11 + n12;
        double N2d = n21 + n22;
        double Nd1 = n11 + n21;
        double Nd2 = n12 + n22;
        double Ndd = N;
        if (N1d != (double)D || Nd1 != (double)n || Nd2 != (double)(N - n) || N2d != (double)(N - D)) {
            throw new RuntimeException("ERROR: This should never happen!");
        }
        double chiSquare = Ndd * Math.pow(Math.abs(n11 * n22 - n12 * n21), 2.0) / (N1d * N2d * Nd1 * Nd2);
        return this.chiSquareCDFComplementary(chiSquare, 1);
    }

    public double chiSquareCDF(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return Gamma.regularizedGammaP((double)nu / 2.0, chiSquare / 2.0);
    }

    public double chiSquareCDFComplementary(double chiSquare, int nu) {
        if (nu <= 0) {
            throw new IllegalArgumentException("The degrees of freedom [nu], " + nu + ", must be greater than zero");
        }
        return Gamma.regularizedGammaQ((double)nu / 2.0, chiSquare / 2.0);
    }

    public double fisherExactTestDown(int k, int N, int D, int n) {
        int minTest;
        if (n == 0) {
            if (k == 1) {
                return 1.0;
            }
            return 0.0;
        }
        double cumulativeHG = 0.0;
        for (int i2 = minTest = Math.max(n + D - N, 0); i2 < k; ++i2) {
            cumulativeHG += this.hd.hypergeometric(i2, N, D, n);
        }
        return cumulativeHG;
    }

    public double fisherExactTestDown(int k, int N, int D, int n, double threshold) {
        double mean;
        if (k == 1 && n == 0) {
            return 1.0;
        }
        if (k == 1 && D == 0) {
            return 1.0;
        }
        if (k == 0) {
            return 0.0;
        }
        if ((double)(--k) > (mean = this.mean(k, N, D, n)) && threshold <= 0.5) {
            return 1.0;
        }
        double cumulativeHG = 0.0;
        int maxTest = Math.min(n, D);
        if (k >= maxTest) {
            return 1.0;
        }
        double hypergeom = this.hd.hypergeometric(k, N, D, n);
        if (hypergeom <= 0.0) {
            return Double.MIN_NORMAL;
        }
        cumulativeHG += hypergeom;
        for (int i2 = k - 1; i2 >= 0; --i2) {
            if (hypergeom <= 0.0) {
                return cumulativeHG;
            }
            int kk = i2 + 1;
            double num = (double)kk * (double)(N + kk - n - D);
            double den = (double)(D - i2) * (double)(n - i2);
            if (!((cumulativeHG += (hypergeom *= num / den)) >= threshold)) continue;
            return 1.0;
        }
        return Math.min(cumulativeHG, 1.0);
    }

    public double fisherExactTestUp(int k, int N, int D, int n) {
        if (k == 0) {
            return 1.0;
        }
        if (n == 0) {
            return 0.0;
        }
        double cumulativeHG = 0.0;
        int maxTest = Math.min(n, D);
        for (int i2 = k; i2 <= maxTest; ++i2) {
            cumulativeHG += this.hd.hypergeometric(i2, N, D, n);
        }
        return Math.min(cumulativeHG, 1.0);
    }

    public double fisherExactTestUp(int k, int N, int D, int n, double threshold) {
        if (k == 0) {
            return 1.0;
        }
        double mean = this.mean(k, N, D, n);
        if ((double)k < mean && threshold < 0.5) {
            return 1.0;
        }
        double cumulativeHG = 0.0;
        int maxTest = Math.min(n, D);
        double hypergeom = this.hd.hypergeometric(k, N, D, n);
        if (hypergeom <= 0.0) {
            return Double.MIN_NORMAL;
        }
        cumulativeHG += hypergeom;
        for (int i2 = k + 1; i2 <= maxTest; ++i2) {
            if (hypergeom <= 0.0) {
                return cumulativeHG;
            }
            int kk = i2 - 1;
            double num = (double)(D - kk) * (double)(n - kk);
            double den = (double)i2 * (double)(N + i2 - n - D);
            if (!((cumulativeHG += (hypergeom *= num / den)) >= threshold)) continue;
            return 1.0;
        }
        return Math.min(cumulativeHG, 1.0);
    }

    public double mean(int k, int N, int D, int n) {
        return (double)n * (double)D / (double)N;
    }

    public double pValueDown(int k, int N, int D, int n) {
        return this.fisherExactTestDown(k + 1, N, D, n, 1.0);
    }

    public double pValueDown(int k, int N, int D, int n, double threshold) {
        return this.fisherExactTestDown(k + 1, N, D, n, threshold);
    }

    public double pValueUp(int k, int N, int D, int n) {
        return this.fisherExactTestUp(k, N, D, n, 1.0);
    }

    public double pValueUp(int k, int N, int D, int n, double threshold) {
        return this.fisherExactTestUp(k, N, D, n, threshold);
    }

    public String toR(int k, int N, int D, int n, boolean lowerTail) {
        return "phyper( " + k + ", " + D + ", " + (N - D) + ", " + n + ", lower.tail = " + Boolean.toString(lowerTail).toUpperCase() + " )";
    }

    public double variance(int k, int N, int D, int n) {
        return (double)n * (double)D * (double)(N - n) * (double)(N - n) * (double)(N - D) / ((double)N * (double)N * (double)(N - 1));
    }
}

