/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.probablility;

import org.apache.commons.math3.distribution.NormalDistribution;

public class CochranArmitageTest {
    public static final double[] WEIGHT_DOMINANT = new double[]{1.0, 1.0, 0.0};
    public static final double[] WEIGHT_RECESSIVE = new double[]{0.0, 1.0, 1.0};
    public static final double[] WEIGHT_TREND = new double[]{0.0, 1.0, 2.0};
    private static CochranArmitageTest cochranArmitageTest = new CochranArmitageTest();
    public static double EPSILON = 1.0E-20;

    public static CochranArmitageTest get() {
        return cochranArmitageTest;
    }

    private CochranArmitageTest() {
    }

    public double p(int[] N1, int[] N2, double[] weight) {
        double t = this.test(N1, N2, weight);
        if (t > 0.0) {
            t = -t;
        }
        double p = new NormalDistribution(0.0, 1.0).cumulativeProbability(t);
        return p;
    }

    double t(int[] N1, int[] N2, double[] weight) {
        int R1 = 0;
        int R22 = 0;
        int k = N1.length;
        for (int i2 = 0; i2 < k; ++i2) {
            R1 += N1[i2];
            R22 += N2[i2];
        }
        double t = 0.0;
        for (int i3 = 0; i3 < N1.length; ++i3) {
            t += weight[i3] * (double)(N1[i3] * R22 - N2[i3] * R1);
        }
        return t;
    }

    public double test(int[] N1, int[] N2, double[] weight) {
        if (N1.length != N2.length) {
            throw new RuntimeException("Row length do not match: " + N1.length + " != " + N2.length);
        }
        if (N1.length != weight.length) {
            throw new RuntimeException("Weight length does not match data rows length: " + N1.length + " != " + weight.length);
        }
        double t = this.t(N1, N2, weight);
        double var = this.var(N1, N2, weight);
        return t / Math.sqrt(var);
    }

    double var(int[] N1, int[] N2, double[] weight) {
        int k = N1.length;
        int R1 = 0;
        int R22 = 0;
        for (int i2 = 0; i2 < k; ++i2) {
            R1 += N1[i2];
            R22 += N2[i2];
        }
        int N = R1 + R22;
        double sum1 = 0.0;
        for (int i3 = 0; i3 < k; ++i3) {
            int Ci = N1[i3] + N2[i3];
            sum1 += weight[i3] * weight[i3] * (double)Ci * (double)(N - Ci);
        }
        double sum2 = 0.0;
        for (int i4 = 0; i4 < k - 1; ++i4) {
            int Ci = N1[i4] + N2[i4];
            for (int j = i4 + 1; j < k; ++j) {
                int Cj = N1[j] + N2[j];
                sum2 += weight[i4] * weight[j] * (double)Ci * (double)Cj;
            }
        }
        double var = (double)R1 * (double)R22 / (double)N * (sum1 - 2.0 * sum2);
        return var;
    }
}

