/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.ped;

import java.util.Collection;
import java.util.HashMap;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class PlinkMap {
    public static boolean debug = false;
    HashMap<String, Integer> id2LineNumber;
    String[] chrNames;
    int[] positions;
    String[] ids;

    public PlinkMap() {
        this.id2LineNumber = new HashMap();
    }

    public PlinkMap(String mapFileName) {
        this.read(mapFileName);
    }

    public String getChrName(int idx) {
        return this.chrNames[idx];
    }

    public Collection<String> getGenotypeNames() {
        return this.id2LineNumber.keySet();
    }

    public Integer getGenotypeNames(String idStr) {
        return this.id2LineNumber.get(idStr);
    }

    public String getId(int idx) {
        return this.ids[idx];
    }

    public int getPosition(int idx) {
        return this.positions[idx];
    }

    protected void read(String mapFileName) {
        String cols = Gpr.readFile(mapFileName);
        String[] lines = cols.split("\n");
        this.positions = new int[lines.length];
        this.chrNames = new String[lines.length];
        this.ids = new String[lines.length];
        this.id2LineNumber = new HashMap();
        int lineNum = 0;
        for (String line : lines) {
            String[] fields = line.split("\\s");
            this.chrNames[lineNum] = fields[0];
            this.ids[lineNum] = fields[1];
            this.positions[lineNum] = Gpr.parseIntSafe(fields[fields.length - 1]);
            String id = this.ids[lineNum];
            if (!id.isEmpty()) {
                if (this.id2LineNumber.containsKey(id)) {
                    throw new RuntimeException("Duplicate ID '" + id + "'. File '" + mapFileName + "', line '" + (lineNum + 1) + "'");
                }
                this.id2LineNumber.put(id, lineNum);
                if (debug) {
                    Log.debug("genotypeNames.put(" + id + ", " + lineNum + ")");
                }
            }
            ++lineNum;
        }
    }

    public int size() {
        return this.positions.length;
    }
}

