/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.ped;

import org.snpeff.util.GprSeq;

public class PedGenotype {
    String[] genotypes;
    String chrName;
    int position;

    public PedGenotype(String[] genotypes) {
        this.genotypes = genotypes;
    }

    public PedGenotype(String[] genotypes, String chrName, int position) {
        this.genotypes = genotypes;
        this.chrName = chrName;
        this.position = position;
    }

    public String get(int idx) {
        return this.genotypes[idx];
    }

    public String[] getGenotypes() {
        return this.genotypes;
    }

    public int getPosition() {
        return this.position;
    }

    public boolean has(String genotype) {
        for (String gen : this.genotypes) {
            if (!gen.equals(genotype)) continue;
            return true;
        }
        return false;
    }

    public boolean isHomozygous() {
        for (int i2 = 1; i2 < this.genotypes.length; ++i2) {
            if (this.genotypes[i2] == this.genotypes[i2 - 1]) continue;
            return false;
        }
        return true;
    }

    public boolean isValid() {
        for (String g : this.genotypes) {
            if (!g.equalsIgnoreCase("x") && !g.equalsIgnoreCase("0")) continue;
            return false;
        }
        return true;
    }

    public int size() {
        return this.genotypes.length;
    }

    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean wcComplement) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < this.genotypes.length; ++i2) {
            if (this.genotypes[i2].isEmpty()) {
                sb.append(".");
            } else if (wcComplement) {
                sb.append(GprSeq.wc(this.genotypes[i2]));
            } else {
                sb.append(this.genotypes[i2]);
            }
            if (i2 >= this.genotypes.length - 1) continue;
            sb.append("/");
        }
        return sb.toString();
    }
}

