/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.pdb;

import htsjdk.samtools.util.RuntimeEOFException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.zip.GZIPOutputStream;
import org.biojava.nbio.structure.io.PDBFileReader;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Transcript;
import org.snpeff.pdb.DistanceResult;
import org.snpeff.pdb.IdMapper;
import org.snpeff.pdb.IdMapperEntry;
import org.snpeff.pdb.PdbFile;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Log;

public class ProteinInteractions {
    public static final String PROTEIN_INTERACTION_FILE = "interactions.bin";
    public static final String DEFAULT_PDB_DIR = "db/pdb";
    public static final double DEFAULT_DISTANCE_THRESHOLD = 3.0;
    public static final double DEFAULT_MAX_MISMATCH_RATE = 0.05;
    public static final int DEFAULT_PDB_MIN_AA_SEPARATION = 20;
    public static final String DEFAULT_PDB_ORGANISM_COMMON = "HUMAN";
    public static final String DEFAULT_PDB_ORGANISM_SCIENTIFIC = "HOMO SAPIENS";
    public static final double DEFAULT_PDB_RESOLUTION = 3.0;
    int aaMinSeparation = 20;
    Config config;
    boolean debug;
    boolean verbose;
    List<DistanceResult> distanceResults;
    double distanceThreshold = 3.0;
    double distanceThresholdNon = Double.POSITIVE_INFINITY;
    String idMapFile;
    int countFilesPass;
    int countMapError;
    int countMapOk;
    String genomeVer;
    IdMapper idMapper;
    double maxMismatchRate = 0.05;
    BufferedWriter outpufDbFile;
    String outputDbFileName;
    String pdbDir = "db/pdb";
    Collection<String> pdbFileNames;
    String pdbOrganismCommon = "HUMAN";
    String pdbOrganismScientific = "HOMO SAPIENS";
    PDBFileReader pdbReader;
    double pdbResolution = 3.0;
    Set<String> saved;
    Map<String, Transcript> trancriptById;

    public String checkParams() {
        if (this.genomeVer == null || this.genomeVer.isEmpty()) {
            return "Missing genomer version parameter";
        }
        if (this.idMapFile == null || this.idMapFile.isEmpty()) {
            return "Missing ID map file";
        }
        if (this.distanceThreshold <= 0.0) {
            return "Max distance in '-maxdist' command line option must be a positive number";
        }
        if (this.maxMismatchRate <= 0.0) {
            return "Max mismatch rate in '-maxErr' command line option must be a positive number";
        }
        if (this.pdbResolution <= 0.0) {
            return "Resoluton in '-res' command line option must be a positive number";
        }
        if (this.aaMinSeparation <= 0) {
            return "Minimum separation in '-aaSep' command line option must be a positive, integer number";
        }
        return null;
    }

    void createTranscriptMap() {
        this.trancriptById = new HashMap<String, Transcript>();
        for (Gene g : this.config.getSnpEffectPredictor().getGenome().getGenes()) {
            for (Transcript tr : g) {
                String trId = IdMapper.transcriptIdNoVersion(tr.getId());
                this.trancriptById.put(trId, tr);
            }
        }
    }

    void closeOuptutDb() {
        try {
            if (this.outpufDbFile != null) {
                this.outpufDbFile.close();
            }
            this.outpufDbFile = null;
            this.saved = null;
        }
        catch (IOException e) {
            throw new RuntimeException("Error closing output file", e);
        }
    }

    public void deleteOutputDb() {
        File of = new File(this.outputDbFileName);
        of.delete();
    }

    Collection<String> findPdbFiles() {
        return this.findPdbFiles(new File(this.pdbDir));
    }

    Collection<String> findPdbFiles(File dir) {
        if (this.debug) {
            Log.debug("Finding PDB files in directory: " + String.valueOf(dir));
        }
        LinkedList<String> list = new LinkedList<String>();
        if (!dir.isDirectory()) {
            throw new RuntimeException("No such directory '" + String.valueOf(dir) + "'");
        }
        for (File f : dir.listFiles()) {
            if (f.isDirectory()) {
                list.addAll(this.findPdbFiles(f));
                continue;
            }
            if (!this.isPdbFile(f)) continue;
            list.add(f.getAbsolutePath());
            if (!this.debug) continue;
            Log.debug("Found PDB file: " + f.getAbsolutePath());
        }
        return list;
    }

    public boolean filterTranscript(String trId) {
        Transcript tr = this.trancriptById.get(trId);
        if (tr == null) {
            if (this.debug) {
                Log.debug("Transcript '" + trId + "' not found in " + this.genomeVer + ".");
            }
            return false;
        }
        return true;
    }

    public Set<String> findTranscriptIds(String pdbId) {
        List<IdMapperEntry> idEntries = this.idMapper.getByPdbId(pdbId);
        Set<String> trIds = IdMapper.transcriptIds(idEntries);
        if (this.debug) {
            StringBuilder sb = new StringBuilder();
            sb.append("PDB ID: " + pdbId);
            sb.append("\tEntries:\n");
            if (idEntries != null) {
                for (IdMapperEntry ime : idEntries) {
                    sb.append("\t\t" + String.valueOf(ime) + "\n");
                }
                sb.append("\tTranscripts:\t" + String.valueOf(trIds) + "\n");
            }
            Log.debug(sb);
        }
        return trIds;
    }

    public int getAaMinSeparation() {
        return this.aaMinSeparation;
    }

    public void setAaMinSeparation(int aaMinSeparation) {
        this.aaMinSeparation = aaMinSeparation;
    }

    public List<IdMapperEntry> getByProteinId(String proteinId) {
        return this.idMapper.getByPdbId(proteinId);
    }

    public List<DistanceResult> getDistanceResults() {
        return this.distanceResults;
    }

    public double getDistanceThreshold() {
        return this.distanceThreshold;
    }

    public void setDistanceThreshold(double distanceThreshold) {
        this.distanceThreshold = distanceThreshold;
    }

    public double getDistanceThresholdNon() {
        return this.distanceThresholdNon;
    }

    public void setDistanceThresholdNon(double distanceThresholdNon) {
        this.distanceThresholdNon = distanceThresholdNon;
    }

    public String getIdMapFile() {
        return this.idMapFile;
    }

    public void setIdMapFile(String idMapFile) {
        this.idMapFile = idMapFile;
    }

    public double getMaxMismatchRate() {
        return this.maxMismatchRate;
    }

    public void setMaxMismatchRate(double maxMismatchRate) {
        this.maxMismatchRate = maxMismatchRate;
    }

    public String getPdbOrganismCommon() {
        return this.pdbOrganismCommon;
    }

    public void setPdbOrganismCommon(String pdbOrganismCommon) {
        this.pdbOrganismCommon = pdbOrganismCommon;
    }

    public String getPdbOrganismScientific() {
        return this.pdbOrganismScientific;
    }

    public void setPdbOrganismScientific(String pdbOrganismScientific) {
        this.pdbOrganismScientific = pdbOrganismScientific;
    }

    public double getPdbResolution() {
        return this.pdbResolution;
    }

    public void setPdbResolution(double pdbResolution) {
        this.pdbResolution = pdbResolution;
    }

    public Transcript getTranscript(String trId) {
        return this.trancriptById.get(IdMapper.transcriptIdNoVersion(trId));
    }

    public void incCountFilesPass() {
        ++this.countFilesPass;
    }

    public void incCountMapOk() {
        ++this.countMapOk;
    }

    public void incCountMapError() {
        ++this.countMapError;
    }

    public void initialize(Config config) {
        this.config = config;
        this.outputDbFileName = config.getDirDataGenomeVersion() + "/interactions.bin";
        this.deleteOutputDb();
    }

    void initTranscriptById() {
        this.trancriptById = new HashMap<String, Transcript>();
        for (Gene g : this.config.getSnpEffectPredictor().getGenome().getGenes()) {
            for (Transcript tr : g) {
                String id = tr.getId();
                if (id.indexOf(46) > 0) {
                    id = id.substring(0, id.indexOf(46));
                }
                if (this.trancriptById.containsKey(id)) {
                    String chrPrev = this.trancriptById.get(id).getChromosomeName();
                    String chr = tr.getChromosomeName();
                    if (chr.length() >= chrPrev.length()) continue;
                    this.trancriptById.put(id, tr);
                    continue;
                }
                this.trancriptById.put(id, tr);
            }
        }
    }

    public boolean isDebug() {
        return this.debug;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    boolean isPdbFile(File f) {
        String fileName = f.getName();
        return f.isFile() && (fileName.endsWith(".pdb") || fileName.endsWith(".pdb.gz") || fileName.endsWith(".ent") || fileName.endsWith(".ent.gz"));
    }

    public void loadIdMapper() {
        if (this.verbose) {
            Log.info("Loading id maps " + this.idMapFile);
        }
        this.idMapper = new IdMapper();
        this.idMapper.setVerbose(this.verbose);
        this.idMapper.load(this.idMapFile);
    }

    void openOuptutDbFile() {
        try {
            if (this.verbose) {
                Log.info("Saving results to database file '" + this.outputDbFileName + "'");
            }
            this.outpufDbFile = new BufferedWriter(new OutputStreamWriter(new GZIPOutputStream(new FileOutputStream(this.outputDbFileName))));
            this.saved = new HashSet<String>();
        }
        catch (IOException e) {
            throw new RuntimeEOFException("Error opening output file '" + this.outputDbFileName + "'", e);
        }
    }

    public void pdb() {
        if (this.verbose) {
            Log.info("Finding PDB files");
        }
        this.pdbFileNames = this.findPdbFiles();
        this.createTranscriptMap();
        if (this.verbose) {
            Log.info("Analyzing PDB sequences");
        }
        this.pdbAnalysis();
    }

    protected void pdbAnalysis() {
        if (this.verbose) {
            Log.info("Analyzing PDB files");
        }
        for (String pdbFileName : this.pdbFileNames) {
            try {
                PdbFile pdbFile = new PdbFile(this, pdbFileName);
                pdbFile.pdbAnalysis();
            }
            catch (IOException e) {
                Log.error("Error processing file '" + pdbFileName + "'. Message: " + e.getMessage());
            }
        }
        if (this.verbose) {
            Log.info("Done.\n\tNumber of PDB files : " + this.pdbFileNames.size() + "\n\tPDB files analyzed  : " + this.countFilesPass + "\n\tAA 'in contact'     : " + this.countMapOk + "\n\tMapping errors      : " + this.countMapError);
        }
    }

    public boolean run() {
        this.loadIdMapper();
        this.initTranscriptById();
        this.pdbReader = new PDBFileReader();
        this.openOuptutDbFile();
        this.pdb();
        this.closeOuptutDb();
        return true;
    }

    public boolean run(boolean storeResults) {
        this.distanceResults = new ArrayList<DistanceResult>();
        this.run();
        return true;
    }

    public void save(List<DistanceResult> distResults) {
        if (this.debug) {
            Log.debug("Saving " + distResults.size() + " results");
        }
        for (DistanceResult d : distResults) {
            try {
                String dstr = d.toString();
                if (this.saved.contains(dstr)) continue;
                this.outpufDbFile.write(dstr + "\n");
                this.saved.add(dstr);
                if (this.distanceResults == null) continue;
                this.distanceResults.add(d);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setGenomeVer(String genomeVer) {
        this.genomeVer = genomeVer;
    }

    public void setPdbDir(String pdbDir) {
        this.pdbDir = pdbDir;
    }
}

