/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.pdb;

import java.util.ArrayList;
import java.util.List;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Atom;
import org.biojava.nbio.structure.Calc;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.Group;

public class PdbUtil {
    public static List<AminoAcid> aminoAcids(Chain chain) {
        ArrayList<AminoAcid> aas = new ArrayList<AminoAcid>();
        for (Group group : chain.getAtomGroups()) {
            if (!(group instanceof AminoAcid)) continue;
            aas.add((AminoAcid)group);
        }
        return aas;
    }

    public static double distanceMin(AminoAcid aa1, AminoAcid aa2) {
        double distMin = Double.POSITIVE_INFINITY;
        for (Atom atom1 : aa1.getAtoms()) {
            for (Atom atom2 : aa2.getAtoms()) {
                double dist = Calc.getDistance((Atom)atom1, (Atom)atom2);
                distMin = Math.min(distMin, dist);
            }
        }
        return distMin;
    }
}

