/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.pdb;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.biojava.nbio.core.util.InputStreamProvider;
import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.Chain;
import org.biojava.nbio.structure.DBRef;
import org.biojava.nbio.structure.EntityInfo;
import org.biojava.nbio.structure.Group;
import org.biojava.nbio.structure.GroupType;
import org.biojava.nbio.structure.Structure;
import org.biojava.nbio.structure.io.FileParsingParameters;
import org.biojava.nbio.structure.io.PDBFileParser;
import org.snpeff.interval.Transcript;
import org.snpeff.pdb.DistanceResult;
import org.snpeff.pdb.IdMapperEntry;
import org.snpeff.pdb.PdbUtil;
import org.snpeff.pdb.ProteinInteractions;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class PdbFile {
    public static final String PDB_ENT_EXT = ".pdb";
    public static final String PDB_ENT_EXT_GZ = ".pdb.gz";
    public static final String PDB_EXT = ".ent";
    public static final String PDB_EXT_GZ = ".ent.gz";
    public static final String[] PDB_EXTS = new String[]{".pdb.gz", ".pdb", ".ent.gz", ".ent"};
    public static final double PDB_RESOLUTION_UNSET = 99.0;
    public static final String UNIPROT_DATABASE = "UNP";
    boolean debug;
    boolean verbose;
    String fileName;
    File file;
    String proteinId;
    ProteinInteractions proteinInteractions;
    Structure pdbStructure;
    Set<String> trIds;

    public PdbFile(ProteinInteractions proteinInteractions, String fileName) {
        this.proteinInteractions = proteinInteractions;
        this.fileName = fileName;
        this.debug = proteinInteractions.isDebug();
        this.verbose = proteinInteractions.isVerbose();
    }

    private static boolean contains(String s1, String s2) {
        return s1 != null && s1.contains(s2);
    }

    Map<String, String> chainUniprotIds(Structure pdbStruct) {
        HashMap<String, String> chain2uniproId = new HashMap<String, String>();
        for (DBRef dbref : pdbStruct.getDBRefs()) {
            if (this.debug) {
                Log.debug("PDB_DBREF\tchain:" + dbref.getChainName() + "\tdb: " + dbref.getDatabase() + "\tID: " + dbref.getDbAccession());
            }
            if (!dbref.getDatabase().equals(UNIPROT_DATABASE)) continue;
            chain2uniproId.put(dbref.getChainName(), dbref.getDbAccession());
        }
        return chain2uniproId;
    }

    List<IdMapperEntry> checkSequencePdbGenome() {
        ArrayList<IdMapperEntry> list = new ArrayList<IdMapperEntry>();
        for (String trId : this.trIds) {
            if (!this.proteinInteractions.filterTranscript(trId)) continue;
            list.addAll(this.checkSequencePdbGenome(trId));
        }
        return list;
    }

    List<IdMapperEntry> checkSequencePdbGenome(String trId) {
        if (this.debug) {
            Log.debug("\nChecking '" + trId + "'\t<->\t'" + this.proteinId + "'");
        }
        List<IdMapperEntry> idmapsOri = this.proteinInteractions.getByProteinId(this.proteinId);
        ArrayList<IdMapperEntry> idmapsNew = new ArrayList<IdMapperEntry>();
        for (Chain chain : this.pdbStructure.getChains()) {
            idmapsNew.addAll(this.checkSequencePdbGenome(chain, trId, idmapsOri));
        }
        if (this.debug) {
            for (IdMapperEntry ime : idmapsNew) {
                Log.debug(ime);
            }
        }
        return idmapsNew;
    }

    List<IdMapperEntry> checkSequencePdbGenome(Chain chain, String trId, List<IdMapperEntry> idmapsOri) {
        ArrayList<IdMapperEntry> idmapsNew = new ArrayList<IdMapperEntry>();
        if (!this.filterPdbChain(chain)) {
            return idmapsNew;
        }
        Transcript tr = this.proteinInteractions.getTranscript(trId);
        String prot = tr.protein();
        if (this.debug) {
            System.err.println("\tTranscript ID: " + tr.getId() + "\tProtein [" + prot.length() + "]: " + prot);
        }
        StringBuilder protSeq = new StringBuilder();
        StringBuilder trSeq = new StringBuilder();
        StringBuilder diff = new StringBuilder();
        int countMatch = 0;
        int countMismatch = 0;
        for (Group group : chain.getAtomGroups()) {
            AminoAcid aa;
            int aaPos;
            if (!(group instanceof AminoAcid) || (aaPos = (aa = (AminoAcid)group).getResidueNumber().getSeqNum() - 1) < 0) continue;
            char aaLetter = aa.getChemComp().getOneLetterCode().charAt(0);
            if (prot.length() > aaPos) {
                char trAaLetter = prot.charAt(aaPos);
                trSeq.append(trAaLetter);
                if (aaLetter == trAaLetter) {
                    ++countMatch;
                    diff.append(' ');
                } else {
                    ++countMismatch;
                    diff.append('|');
                }
            } else {
                ++countMismatch;
            }
            protSeq.append(aa.getChemComp().getOneLetterCode());
        }
        if (countMatch + countMismatch > 0) {
            double err = (double)countMismatch / (double)(countMatch + countMismatch);
            if (this.debug) {
                Log.debug("\tChain: " + chain.getId() + "\terror: " + err + "\n\tprotein    : " + String.valueOf(protSeq) + "\n\t diff      : " + String.valueOf(diff) + "\n\ttranscript : " + String.valueOf(trSeq));
            }
            if (err < this.proteinInteractions.getMaxMismatchRate()) {
                if (this.debug) {
                    Log.debug("\tMapping OK    :\t" + trId + "\terror: " + err);
                }
                int trAaLen = tr.protein().length();
                int pdbAaLen = chain.getAtomGroups(GroupType.AMINOACID).size();
                for (IdMapperEntry idm : idmapsOri) {
                    if (!trId.equals(idm.trId) || !this.proteinId.equals(idm.proteinId)) continue;
                    idmapsNew.add(idm.cloneAndSet(chain.getId(), pdbAaLen, trAaLen));
                    break;
                }
            } else if (this.debug) {
                Log.debug("\tMapping ERROR :\t" + trId + "\terror: " + err);
            }
        }
        return idmapsNew;
    }

    public String fileName2ProteinId() {
        String base = Gpr.baseName(this.fileName);
        if (base.startsWith("pdb")) {
            base = base.substring(3);
            base = Gpr.removeExt(base, PDB_EXTS);
            return base.toUpperCase();
        }
        if (base.startsWith("AF-")) {
            String[] segments = base.split("-");
            return segments[1].toUpperCase();
        }
        if (this.debug) {
            Log.debug("Could not parse protein ID for file '" + this.fileName + "', base name '" + base + "'");
        }
        return null;
    }

    boolean filterPdb() {
        double res = this.pdbStructure.getPDBHeader().getResolution();
        if (res > this.proteinInteractions.getPdbResolution() && res < 99.0) {
            if (this.debug) {
                Log.debug("PDB resolution is " + res + ", ignoring file");
            }
            return false;
        }
        boolean ok = false;
        for (Chain chain : this.pdbStructure.getChains()) {
            ok |= this.filterPdbChain(chain);
        }
        return ok;
    }

    boolean filterPdbChain(Chain chain) {
        for (EntityInfo entityInfo : chain.getStructure().getEntityInfos()) {
            if (!PdbFile.contains(entityInfo.getOrganismCommon(), this.proteinInteractions.getPdbOrganismCommon()) && !PdbFile.contains(entityInfo.getOrganismScientific(), this.proteinInteractions.getPdbOrganismScientific())) continue;
            return true;
        }
        return false;
    }

    List<DistanceResult> findInteractingCompound(Chain chain1, Chain chain2, String trId1, String trId2) {
        ArrayList<DistanceResult> results = new ArrayList<DistanceResult>();
        Transcript tr1 = this.proteinInteractions.getTranscript(trId1);
        Transcript tr2 = this.proteinInteractions.getTranscript(trId2);
        List<AminoAcid> aas1 = PdbUtil.aminoAcids(chain1);
        List<AminoAcid> aas2 = PdbUtil.aminoAcids(chain2);
        for (AminoAcid aa1 : aas1) {
            for (AminoAcid aa2 : aas2) {
                double dmin = PdbUtil.distanceMin(aa1, aa2);
                if (!this.select(dmin)) continue;
                DistanceResult dres = new DistanceResult(this.proteinId, aa1, aa2, tr1, tr2, dmin);
                if (dres.hasValidCoords()) {
                    results.add(dres);
                    this.proteinInteractions.incCountMapOk();
                    if (!this.debug) continue;
                    Log.debug((dmin <= this.proteinInteractions.getDistanceThreshold() ? "AA_IN_CONTACT\t" : "AA_NOT_IN_CONTACT\t") + String.valueOf(dres));
                    continue;
                }
                this.proteinInteractions.incCountMapError();
            }
        }
        return results;
    }

    List<DistanceResult> findInteractingSingle(Transcript tr) {
        ArrayList<DistanceResult> results = new ArrayList<DistanceResult>();
        for (Chain chain : this.pdbStructure.getChains()) {
            if (!this.filterPdbChain(chain)) continue;
            results.addAll(this.findInteractingSingle(chain, tr));
        }
        return results;
    }

    List<DistanceResult> findInteractingSingle(Chain chain, Transcript tr) {
        ArrayList<DistanceResult> results = new ArrayList<DistanceResult>();
        List<AminoAcid> aas = PdbUtil.aminoAcids(chain);
        for (int i2 = 0; i2 < aas.size(); ++i2) {
            int minj;
            for (int j = minj = i2 + this.proteinInteractions.getAaMinSeparation(); j < aas.size(); ++j) {
                AminoAcid aa2;
                AminoAcid aa1 = aas.get(i2);
                double d = PdbUtil.distanceMin(aa1, aa2 = aas.get(j));
                if (!this.select(d)) continue;
                DistanceResult dres = new DistanceResult(this.proteinId, aa1, aa2, tr, tr, d);
                if (dres.hasValidCoords()) {
                    results.add(dres);
                    this.proteinInteractions.incCountMapOk();
                    if (!this.debug) continue;
                    Log.debug((d <= this.proteinInteractions.getDistanceThreshold() ? "AA_IN_CONTACT\t" : "AA_NOT_IN_CONTACT\t") + String.valueOf(dres));
                    continue;
                }
                this.proteinInteractions.incCountMapError();
            }
        }
        return results;
    }

    public String getProteinId() {
        Log.debug("DEBUG: " + String.valueOf(this.pdbStructure.getPDBHeader().getPdbId()));
        Log.debug("DEBUG: " + this.pdbStructure.getPDBHeader().getId());
        throw new RuntimeException("UNIMPLEMENTED");
    }

    List<IdMapperEntry> idMapChain(Chain chain, List<IdMapperEntry> idMaps) {
        ArrayList<IdMapperEntry> idMapChain = new ArrayList<IdMapperEntry>();
        for (IdMapperEntry idmap : idMaps) {
            if (!idmap.proteinId.equals(this.proteinId) || !idmap.pdbChainId.equals(chain.getId())) continue;
            idMapChain.add(idmap);
        }
        return idMapChain;
    }

    boolean isCompound() {
        List compounds = this.pdbStructure.getEntityInfos();
        return compounds != null && !compounds.isEmpty();
    }

    public Structure load() throws IOException {
        if (this.verbose) {
            Log.info("Reading PDB file: " + this.fileName);
        }
        this.file = new File(this.fileName);
        System.setProperty("com.sun.xml.bind.v2.bytecode.ClassTailor.noOptimize", "true");
        System.setProperty("PDB_DIR", this.file.getParent());
        InputStreamProvider isp = new InputStreamProvider();
        InputStream inStream = isp.getInputStream(this.file);
        PDBFileParser pdbpars = new PDBFileParser();
        FileParsingParameters params = new FileParsingParameters();
        pdbpars.setFileParsingParameters(params);
        Structure structure = pdbpars.parsePDBFile(inStream);
        inStream.close();
        return structure;
    }

    public void pdbAnalysis() throws IOException {
        this.proteinId = this.fileName2ProteinId();
        if (this.proteinId == null) {
            return;
        }
        if (this.verbose) {
            Log.info("Analysing PDB file '" + this.fileName + "', protein ID '" + this.proteinId + "'");
        }
        this.trIds = this.proteinInteractions.findTranscriptIds(this.proteinId);
        if (this.trIds == null || this.trIds.isEmpty()) {
            if (this.debug) {
                Log.debug("No transcript IDs found for PDB entry '" + this.proteinId + "'");
            }
            return;
        }
        this.pdbStructure = this.load();
        if (this.pdbStructure == null || !this.filterPdb()) {
            return;
        }
        this.pdbAnalysisSingle();
        if (this.isCompound()) {
            this.pdbAnalysisCompound();
        }
    }

    void pdbAnalysisCompound() {
        this.proteinInteractions.incCountFilesPass();
        List<IdMapperEntry> idMapConfirmed = this.checkSequencePdbGenome();
        if (idMapConfirmed == null || idMapConfirmed.isEmpty()) {
            return;
        }
        Map<String, String> chain2uniproId = this.chainUniprotIds(this.pdbStructure);
        for (Chain chain1 : this.pdbStructure.getChains()) {
            String chainId1 = chain1.getId();
            List<IdMapperEntry> idMapChain1 = this.idMapChain(chain1, idMapConfirmed);
            if (idMapChain1.isEmpty()) {
                if (!this.debug) continue;
                Log.debug("Empty maps for chain '" + chainId1 + "'");
                continue;
            }
            for (Chain chain2 : this.pdbStructure.getChains()) {
                String chainId2 = chain2.getId();
                if (chainId1.compareTo(chainId2) >= 0) continue;
                String uniprot1 = chain2uniproId.get(chainId1);
                String uniprot2 = chain2uniproId.get(chainId2);
                if (uniprot1 != null && uniprot2 != null && uniprot1.equals(uniprot2)) {
                    if (!this.debug) continue;
                    Log.debug("Filtering out two chains with same UNIPROT ID: '" + uniprot1);
                    continue;
                }
                List<IdMapperEntry> idMapChain2 = this.idMapChain(chain2, idMapConfirmed);
                if (idMapChain2.isEmpty()) {
                    if (!this.debug) continue;
                    Log.debug("Empty maps for chain '" + chainId2 + "'");
                    continue;
                }
                for (IdMapperEntry im1 : idMapChain1) {
                    for (IdMapperEntry im2 : idMapChain2) {
                        if (im1.trId.equals(im2.trId)) continue;
                        List<DistanceResult> dres = this.findInteractingCompound(chain1, chain2, im1.trId, im2.trId);
                        this.proteinInteractions.save(dres);
                    }
                }
            }
        }
    }

    void pdbAnalysisSingle() {
        if (this.debug) {
            Log.debug("Protein structure analysis for " + this.pdbStructure.getIdentifier());
        }
        this.proteinInteractions.incCountFilesPass();
        List<IdMapperEntry> idMapConfirmed = this.checkSequencePdbGenome();
        if (idMapConfirmed == null || idMapConfirmed.isEmpty()) {
            return;
        }
        for (IdMapperEntry idmap : idMapConfirmed) {
            Transcript tr = this.proteinInteractions.getTranscript(idmap.trId);
            List<DistanceResult> dres = this.findInteractingSingle(tr);
            this.proteinInteractions.save(dres);
        }
    }

    boolean select(double d) {
        if (!Double.isInfinite(this.proteinInteractions.getDistanceThreshold())) {
            return d <= this.proteinInteractions.getDistanceThreshold();
        }
        if (!Double.isInfinite(this.proteinInteractions.getDistanceThresholdNon())) {
            return d > this.proteinInteractions.getDistanceThresholdNon();
        }
        throw new RuntimeException("Neither distance is finite!");
    }
}

