/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.pdb;

public class IdMapperEntry
implements Cloneable,
Comparable<IdMapperEntry> {
    public String trId;
    public String proteinId;
    public String pdbChainId;
    public int pdbAaLen;
    public int trAaLen;

    public IdMapperEntry(String proteinId, String trId) {
        this.trId = trId;
        this.proteinId = proteinId;
        this.pdbChainId = "";
        this.trAaLen = 0;
        this.pdbAaLen = 0;
    }

    public IdMapperEntry cloneAndSet(String chainId, int pdbAaLen, int trAaLen) {
        try {
            IdMapperEntry cloned = (IdMapperEntry)this.clone();
            cloned.pdbChainId = chainId;
            cloned.pdbAaLen = pdbAaLen;
            cloned.trAaLen = trAaLen;
            return cloned;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int compareTo(IdMapperEntry o) {
        int cmp = this.trId.compareTo(o.trId);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.proteinId.compareTo(o.proteinId);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.pdbChainId.compareTo(o.pdbChainId);
        return cmp;
    }

    public String toString() {
        return this.proteinId + "\t" + this.trId + "\t" + this.pdbChainId + "\t" + this.pdbAaLen + "\t" + this.trAaLen;
    }
}

