/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.pdb;

import org.biojava.nbio.structure.AminoAcid;
import org.biojava.nbio.structure.PdbId;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Transcript;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class DistanceResult {
    public static boolean debug = false;
    public char aa1;
    public char aa2 = (char)46;
    public int aaPos1 = -1;
    public int aaPos2 = -1;
    public String chr1 = "";
    public String chr2 = "";
    public int pos1 = -1;
    public int pos2 = -1;
    public double distance = -1.0;
    public String proteinId = "";
    public String pdbChainId1 = "";
    public String pdbChainId2 = "";
    public String trId1 = "";
    public String trId2 = "";

    public DistanceResult() {
        this.aa1 = (char)46;
    }

    public DistanceResult(String proteinId, AminoAcid aa1, AminoAcid aa2, Transcript tr1, Transcript tr2, double distance) {
        this();
        this.proteinId = proteinId;
        this.setAa1(aa1);
        this.setAa2(aa2);
        this.setTr1(tr1);
        this.setTr2(tr2);
        this.distance = distance;
    }

    public DistanceResult(String line) {
        this();
        try {
            String chrPos2;
            String[] f;
            String chrPos1;
            String[] fields = line.split("\t");
            int n = 0;
            if (fields.length < 7) {
                return;
            }
            this.proteinId = fields[n++];
            this.pdbChainId1 = fields[n++];
            this.pdbChainId2 = fields[n++];
            this.distance = Gpr.parseDoubleSafe(fields[n++]);
            this.aa1 = fields[n++].charAt(0);
            this.aaPos1 = Gpr.parseIntSafe(fields[n++]);
            this.aa2 = fields[n++].charAt(0);
            this.aaPos2 = Gpr.parseIntSafe(fields[n++]);
            if (fields.length > n && !(chrPos1 = fields[n++]).isEmpty()) {
                f = chrPos1.split(":");
                this.chr1 = f[0];
                this.pos1 = Gpr.parseIntSafe(f[1]);
            }
            if (fields.length > n && !(chrPos2 = fields[n++]).isEmpty()) {
                f = chrPos2.split(":");
                this.chr2 = f[0];
                this.pos2 = Gpr.parseIntSafe(f[1]);
            }
            if (fields.length > n) {
                this.trId1 = fields[n++];
            }
            if (fields.length > n) {
                this.trId2 = fields[n++];
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error processing line:\t'" + line + "'", e);
        }
    }

    int aaNum2ChrPos(Transcript tr, int aaNum, char aa) {
        if (aaNum < 0) {
            if (debug) {
                Log.debug("Invalid AA number:" + aaNum + "\n\tDistanceResult: " + String.valueOf(this) + "\n\tTranscript    : " + String.valueOf(tr));
            }
            return -1;
        }
        String protein = tr.protein();
        if (protein == null || protein.length() <= aaNum) {
            if (debug) {
                Log.debug("Invalid AA number:\n\tAA number     : " + aaNum + "\n\tProtein length: " + protein.length() + "\n\tDistanceResult: " + String.valueOf(this) + "\n\tTranscript    : " + String.valueOf(tr));
            }
            return -1;
        }
        if (protein.charAt(aaNum) != aa) {
            if (debug) {
                Log.debug("AA not matching the expected sequence:\n\tAA             :\t" + aa + "\n\ttr.protein     :\t" + protein + "\n\ttr.protein[" + aaNum + "]:\t" + protein.charAt(aaNum) + "\n\tDistanceResult: " + String.valueOf(this) + "\n\tTranscript    : " + String.valueOf(tr));
            }
            return -1;
        }
        int[] aa2pos = tr.aaNumber2Pos();
        if (aa2pos.length <= aaNum) {
            if (debug) {
                Log.debug("AA number out of range in aa2pos[]: \n\tAA number        : " + aaNum + "\n\ttr.aa2pos.length : " + aa2pos.length + "\n\tDistanceResult: " + String.valueOf(this) + "\n\tTranscript       : " + String.valueOf(tr));
            }
            return -1;
        }
        return aa2pos[aaNum];
    }

    public int compareByPos(DistanceResult d) {
        int comp = Chromosome.compare(this.chr1, d.chr1);
        if (comp != 0) {
            return comp;
        }
        comp = this.pos1 - d.pos1;
        if (comp != 0) {
            return comp;
        }
        comp = Chromosome.number(this.chr2) - Chromosome.number(d.chr2);
        if (comp != 0) {
            return comp;
        }
        comp = Chromosome.compare(this.chr2, d.chr2);
        if (comp != 0) {
            return comp;
        }
        comp = this.pos2 - d.pos2;
        if (comp != 0) {
            return comp;
        }
        return (int)Math.signum(this.distance - d.distance);
    }

    public boolean equalPos(DistanceResult d) {
        return this.chr1.equals(d.chr1) && this.chr2.equals(d.chr2) && this.pos1 == d.pos1 && this.pos2 == d.pos2;
    }

    public String getId() {
        return this.proteinId + ":" + this.pdbChainId1 + "_" + (this.aaPos1 + 1) + "-" + this.pdbChainId2 + "_" + (this.aaPos2 + 1) + ":" + this.trId1 + (String)(!this.trId2.equals(this.trId1) ? "-" + this.trId2 : "");
    }

    public boolean hasValidCoords() {
        return !this.chr1.isEmpty() && !this.trId1.isEmpty() && this.pos1 >= 0 && !this.chr2.isEmpty() && !this.trId2.isEmpty() && this.pos2 >= 0;
    }

    public void setAa1(AminoAcid aa) {
        PdbId pdbId = aa.getChain().getStructure().getPDBHeader().getPdbId();
        if (pdbId != null) {
            this.setProteinId(pdbId.toString());
        }
        this.pdbChainId1 = aa.getChainId();
        this.aaPos1 = aa.getResidueNumber().getSeqNum() - 1;
        this.aa1 = aa.getChemComp().getOneLetterCode().charAt(0);
    }

    public void setAa2(AminoAcid aa) {
        PdbId pdbId = aa.getChain().getStructure().getPDBHeader().getPdbId();
        if (pdbId != null) {
            this.setProteinId(pdbId.toString());
        }
        this.pdbChainId2 = aa.getChainId();
        this.aaPos2 = aa.getResidueNumber().getSeqNum() - 1;
        this.aa2 = aa.getChemComp().getOneLetterCode().charAt(0);
    }

    void setProteinId(String proteinId) {
        if (this.proteinId == null || this.proteinId.isEmpty()) {
            this.proteinId = proteinId;
        } else if (!this.proteinId.equals(proteinId)) {
            throw new RuntimeException("New pdbId does not match old pdbId: " + this.proteinId + " != " + proteinId);
        }
    }

    public void setTr1(Transcript tr) {
        this.trId1 = tr.getId();
        this.chr1 = tr.getChromosomeName();
        this.pos1 = this.aaNum2ChrPos(tr, this.aaPos1, this.aa1);
    }

    public void setTr2(Transcript tr) {
        this.trId2 = tr.getId();
        this.chr2 = tr.getChromosomeName();
        this.pos2 = this.aaNum2ChrPos(tr, this.aaPos2, this.aa2);
    }

    public String toString() {
        return this.proteinId + "\t" + this.pdbChainId1 + "\t" + this.pdbChainId2 + "\t" + this.distance + "\t" + this.aa1 + "\t" + this.aaPos1 + "\t" + this.aa2 + "\t" + this.aaPos2 + "\t" + (String)(!this.chr1.isEmpty() ? this.chr1 + ":" + this.pos1 : "") + "\t" + (String)(!this.chr2.isEmpty() ? this.chr2 + ":" + this.pos2 : "") + "\t" + this.trId1 + "\t" + this.trId2;
    }

    public String toStringPos() {
        return (String)(this.chr1 != null ? "\t" + this.chr1 + ":" + this.pos1 : "") + (String)(this.chr2 != null ? "\t" + this.chr2 + ":" + this.pos2 : "");
    }
}

