/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.overlap;

import org.snpeff.binseq.DnaSequence;
import org.snpeff.binseq.coder.DnaCoder;
import org.snpeff.overlap.BasesChangeCounter;
import org.snpeff.overlap.Overlap;
import org.snpeff.overlap.SequenceRotator;
import org.snpeff.util.Gpr;

public class OverlapDnaSeq
extends Overlap<DnaSequence> {
    public static boolean debug = false;
    private static BasesChangeCounter basesChangeCounter = new BasesChangeCounter(DnaCoder.get());
    private static int basesPerWord = DnaCoder.get().basesPerWord();
    private static int bitsPerBase = DnaCoder.get().bitsPerBase();
    SequenceRotator rotator;
    int minOverlap = 0;

    public int getMinOverlap() {
        return this.minOverlap;
    }

    @Override
    public int overlap(DnaSequence seq1, DnaSequence seq2) {
        int lenLeft;
        this.bestScore = Integer.MAX_VALUE;
        this.bestOffset = 0;
        this.rotator = new SequenceRotator(seq1);
        int lenRight = seq2.length() - this.minOverlap + 1;
        int len = Math.max(lenRight, lenLeft = seq1.length() - this.minOverlap + 1);
        if (len <= 0) {
            this.bestScore = Math.min(seq1.length(), seq2.length());
            this.bestOffset = 0;
        }
        for (int off = 0; off < len; ++off) {
            int score = Integer.MAX_VALUE;
            if (off < lenRight) {
                score = this.overlapScore(seq1, seq2, off);
            }
            if (score < this.bestScore) {
                this.bestScore = score;
                this.bestOffset = off;
                if (score == 0) {
                    return score;
                }
            }
            if (off < lenLeft) {
                score = this.overlapScore(seq1, seq2, -off);
            }
            if (score >= this.bestScore) continue;
            this.bestScore = score;
            this.bestOffset = -off;
            if (score != 0) continue;
            return score;
        }
        return this.bestScore;
    }

    int overlapScore(DnaSequence seq1, DnaSequence seq2, int offsetSeq1) {
        int offset = Math.abs(offsetSeq1);
        int offsetLongs = offset / basesPerWord;
        int offsetBases = offset % basesPerWord;
        if (offsetSeq1 < 0 && offsetBases != 0) {
            ++offsetLongs;
            offsetBases = basesPerWord - offsetBases;
        }
        DnaSequence rotated = this.rotator.rotate(offsetBases);
        long[] longs1 = rotated.getCodes();
        long[] longs2 = seq2.getCodes();
        int score = 0;
        int len1 = 0;
        int len2 = 0;
        int i1 = 0;
        int i2 = 0;
        if (offsetSeq1 >= 0) {
            len1 = longs1.length;
            len2 = longs2.length;
            i2 = offsetLongs;
        } else {
            len1 = longs1.length;
            len2 = longs2.length;
            i1 = offsetLongs;
        }
        if (debug) {
            System.out.println("Offset:" + offsetSeq1 + "\toffsetLongs: " + offsetLongs + "\toffsetBases:" + offsetBases + "\nseq1 : " + String.valueOf(rotated) + "\nseq2 : " + String.valueOf(seq2) + "\nlen1:" + len1 + "\tlen2:" + len2);
        }
        while (i1 < len1 && i2 < len2) {
            int lastBits;
            long b1 = i1 >= 0 ? longs1[i1] : 0L;
            long b2 = i2 >= 0 ? longs2[i2] : 0L;
            long mask = -1L;
            if (i1 == 0 && offsetBases != 0) {
                mask &= Long.MIN_VALUE >> bitsPerBase * offsetBases - 1 ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (i1 >= len1 - 1 && (lastBits = bitsPerBase * ((seq1.length() + offsetSeq1) % basesPerWord)) != 0) {
                mask &= Long.MIN_VALUE >> lastBits - 1;
            }
            if (i2 >= len2 - 1 && (lastBits = bitsPerBase * (seq2.length() % basesPerWord)) != 0) {
                mask &= Long.MIN_VALUE >> lastBits - 1;
            }
            if (mask != -1L) {
                if (debug) {
                    System.out.println("\tmask: " + Gpr.bin64(mask));
                }
                b1 &= mask;
                b2 &= mask;
            }
            long xor = b1 ^ b2;
            int changed = basesChangeCounter.changed(xor);
            score += changed;
            if (debug) {
                System.out.println("\tb1  : " + Gpr.bin64(b1) + "\n\tb2  : " + Gpr.bin64(b2) + "\n\tXOR : " + Gpr.bin64(xor) + "\n\ti: " + i1 + "\tChanged: " + changed + "\tScore: " + score);
            }
            ++i1;
            ++i2;
        }
        return score;
    }

    public void setMinOverlap(int minOverlap) {
        if (minOverlap < 0) {
            throw new RuntimeException("Minimum overlap must be a non-negative number: " + minOverlap);
        }
        this.minOverlap = minOverlap;
    }
}

