/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.overlap;

import org.snpeff.binseq.coder.Coder;

public class BasesChangeCounter {
    private static int CACHED_BASES = 8;
    private static int CACHED_BITS = 2 * CACHED_BASES;
    private static int MASK = (1 << CACHED_BITS) - 1;
    Coder coder;
    int[] changed;

    public BasesChangeCounter(Coder coder) {
        this.coder = coder;
        this.changed = new int[1 << CACHED_BITS];
        for (int i2 = 0; i2 < this.changed.length; ++i2) {
            int count = 0;
            for (int ii = 0; ii < CACHED_BASES; ++ii) {
                int j = i2 >> coder.bitsPerBase() * ii & (int)coder.mask(0);
                if (j == 0) continue;
                ++count;
            }
            this.changed[i2] = count;
        }
    }

    int changed(long xor) {
        if (xor == 0L) {
            return 0;
        }
        int changedBases = 0;
        for (int i2 = 0; i2 < 4; ++i2) {
            long j = xor >>> i2 * CACHED_BITS & (long)MASK;
            changedBases += this.changed[(int)j];
        }
        return changedBases;
    }
}

