/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.outputFormatter;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.snpeff.filter.VariantEffectFilter;
import org.snpeff.interval.Marker;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.VariantEffect;

public abstract class OutputFormatter {
    boolean supressOutput = false;
    boolean showHeader = true;
    boolean useHgvs;
    boolean useGeneId;
    boolean useSequenceOntology;
    boolean useOicr;
    int sectionNum = 0;
    int outOffset = 1;
    String commandLineStr;
    String version;
    String chrStr;
    String outputFile = null;
    BufferedWriter out;
    Marker section;
    VariantEffectFilter variantEffectResutFilter = null;
    List<VariantEffect> variantEffects = new ArrayList<VariantEffect>();
    Config config;

    public void add(VariantEffect variantEffect) {
        if (this.variantEffectResutFilter == null || !this.variantEffectResutFilter.filter(variantEffect)) {
            this.variantEffects.add(variantEffect);
        }
    }

    public OutputFormatter clone() {
        OutputFormatter newOutputFormatter = null;
        try {
            newOutputFormatter = (OutputFormatter)this.getClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            newOutputFormatter.supressOutput = this.supressOutput;
            newOutputFormatter.showHeader = this.showHeader;
            newOutputFormatter.useHgvs = this.useHgvs;
            newOutputFormatter.useGeneId = this.useGeneId;
            newOutputFormatter.useSequenceOntology = this.useSequenceOntology;
            newOutputFormatter.useOicr = this.useOicr;
            newOutputFormatter.sectionNum = this.sectionNum;
            newOutputFormatter.outOffset = this.outOffset;
            newOutputFormatter.commandLineStr = this.commandLineStr;
            newOutputFormatter.version = this.version;
            newOutputFormatter.chrStr = this.chrStr;
            newOutputFormatter.section = this.section;
            newOutputFormatter.variantEffectResutFilter = this.variantEffectResutFilter;
            newOutputFormatter.config = this.config;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return newOutputFormatter;
    }

    public void close() {
        if (this.out != null) {
            try {
                this.out.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public String endSection(Marker marker) {
        String header;
        StringBuilder sb = new StringBuilder();
        if (this.showHeader && this.sectionNum == 0 && !(header = this.toStringHeader()).isEmpty()) {
            sb.append(header);
            sb.append("\n");
        }
        sb.append(this.toString());
        ++this.sectionNum;
        this.variantEffects.clear();
        return this.supressOutput ? null : sb.toString();
    }

    public void print(String outStr) {
        try {
            if (this.outputFile != null && this.out == null) {
                this.out = new BufferedWriter(new FileWriter(this.outputFile));
            }
            if (outStr != null && !outStr.isEmpty()) {
                if (this.out != null) {
                    this.out.write(outStr);
                    this.out.write("\n");
                } else if (!this.supressOutput) {
                    System.out.println(outStr);
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void printSection(Marker marker) {
        this.print(this.endSection(marker));
    }

    public void setChrStr(String chrStr) {
        this.chrStr = chrStr;
    }

    public void setCommandLineStr(String commandLineStr) {
        this.commandLineStr = commandLineStr;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public void setOutOffset(int outOffset) {
        this.outOffset = outOffset;
    }

    public void setOutputFile(String outputFile) {
        this.outputFile = outputFile;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public void setSupressOutput(boolean supressOutput) {
        this.supressOutput = supressOutput;
    }

    public void setUseGeneId(boolean useGeneId) {
        this.useGeneId = useGeneId;
    }

    public void setUseHgvs(boolean useHgvs) {
        this.useHgvs = useHgvs;
    }

    public void setUseOicr(boolean useOicr) {
        this.useOicr = useOicr;
    }

    public void setUseSequenceOntology(boolean useSequenceOntology) {
        this.useSequenceOntology = useSequenceOntology;
    }

    public void setVariantEffectResutFilter(VariantEffectFilter changeEffectResutFilter) {
        this.variantEffectResutFilter = changeEffectResutFilter;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void startSection(Marker marker) {
        this.section = marker;
    }

    public String toString() {
        throw new RuntimeException("Method toString() must be overridden!");
    }

    protected abstract String toStringHeader();
}

