/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.outputFormatter;

import java.util.HashSet;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Regulation;
import org.snpeff.interval.Variant;
import org.snpeff.outputFormatter.BedOutputFormatter;
import org.snpeff.snpEffect.VariantEffect;

public class BedAnnotationOutputFormatter
extends BedOutputFormatter {
    public BedAnnotationOutputFormatter() {
        this.outOffset = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String toString() {
        Variant variant = (Variant)this.section;
        String variantName = variant.getChromosomeName() + ":" + (variant.getStart() + this.outOffset);
        HashSet<void> chEffs = new HashSet<void>();
        for (VariantEffect changeEffect : this.variantEffects) {
            void var6_6;
            if (this.variantEffectResutFilter != null && this.variantEffectResutFilter.filter(changeEffect)) continue;
            Object var6_7 = null;
            Marker m = changeEffect.getMarker();
            if (m != null) {
                String geneName = null;
                Gene gene = changeEffect.getGene();
                if (gene != null) {
                    geneName = this.useGeneId ? gene.getId() : gene.getGeneName();
                }
                Object type = m.getType().toString();
                if (m instanceof Regulation) {
                    Regulation r = (Regulation)m;
                    type = (String)type + "|" + r.getName() + "|" + r.getRegulationType();
                }
                String string = m.getChromosomeName() + "\t\t" + (m.getStart() + this.outOffset) + "\t" + (m.getEnd() + this.outOffset + 1) + "\t" + variantName + ";" + (String)type + (String)(geneName != null ? ":" + geneName : "");
            }
            if (var6_6 == null) continue;
            chEffs.add(var6_6);
        }
        StringBuilder sb = new StringBuilder();
        for (String string : chEffs) {
            sb.append(string + "\n");
        }
        return sb.toString();
    }

    @Override
    public String toStringHeader() {
        return "# SnpEff version " + this.version + "\n# Command line: " + this.commandLineStr + "\n# Chromo\tStart\tEnd\tVariant;Annotation\tScore";
    }
}

