/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.osCmd;

import java.io.File;
import java.io.OutputStream;
import org.snpeff.osCmd.LineFilter;
import org.snpeff.osCmd.Progress;
import org.snpeff.osCmd.StreamGobbler;
import org.snpeff.util.Log;

public class ExecuteOsCommand
extends Thread
implements Progress {
    public static boolean debug = false;
    String[] commandArgs;
    String error = "";
    String pwd = null;
    boolean quietStdout = false;
    boolean quietStderr = false;
    boolean saveStd = false;
    boolean executing = false;
    boolean started = false;
    boolean binaryStdout = false;
    boolean binaryStderr = false;
    boolean showExceptions = true;
    int progress = 0;
    int exitValue = 0;
    String redirectStdout = null;
    String redirectStderr = null;
    Object objetcToNotify = null;
    OutputStream stdin = null;
    StreamGobbler stdErrGobbler = null;
    StreamGobbler stdOutGobbler = null;
    LineFilter stdOutFilter = null;
    Process pr;

    public ExecuteOsCommand(String[] args) {
        this.commandArgs = args;
    }

    public ExecuteOsCommand(String command) {
        this.commandArgs = new String[1];
        this.commandArgs[0] = command;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int exec() {
        try {
            this.executing = true;
            ProcessBuilder pb = new ProcessBuilder(this.commandArgs);
            if (this.pwd != null) {
                pb.directory(new File(this.pwd));
            }
            if (debug) {
                Log.debug("PWD: " + this.pwd);
                for (String arg : this.commandArgs) {
                    Log.debug("ARGS: " + arg);
                }
            }
            this.pr = pb.start();
            this.stdErrGobbler = new StreamGobbler(this.pr.getErrorStream(), true);
            this.stdOutGobbler = new StreamGobbler(this.pr.getInputStream(), false);
            if (this.quietStderr) {
                this.stdErrGobbler.setQuietMode();
            }
            if (this.quietStdout) {
                this.stdOutGobbler.setQuietMode();
            }
            this.stdErrGobbler.setSaveLinesInMemory(this.saveStd);
            this.stdOutGobbler.setSaveLinesInMemory(this.saveStd);
            this.stdErrGobbler.setBinary(this.binaryStderr);
            this.stdOutGobbler.setBinary(this.binaryStdout);
            if (this.redirectStderr != null) {
                this.stdErrGobbler.setRedirectTo(this.redirectStderr);
            }
            if (this.redirectStdout != null) {
                this.stdOutGobbler.setRedirectTo(this.redirectStdout);
            }
            this.stdOutGobbler.setLineFilter(this.stdOutFilter);
            this.stdErrGobbler.setProgress(this);
            this.stdOutGobbler.setProgress(this);
            this.stdErrGobbler.start();
            this.stdOutGobbler.start();
            this.stdin = this.pr.getOutputStream();
            this.started = true;
            this.exitValue = this.pr.waitFor();
            while (this.stdOutGobbler.isRunning() || this.stdErrGobbler.isRunning()) {
                Thread.sleep(100L);
            }
            if (debug && this.exitValue != 0) {
                Log.debug("Exit value: " + this.exitValue);
            }
        }
        catch (Exception e) {
            this.error = e.getMessage();
            this.exitValue = -1;
            if (this.showExceptions) {
                e.printStackTrace();
            }
        }
        finally {
            this.started = true;
            this.executing = false;
            if (this.objetcToNotify != null) {
                Object object = this.objetcToNotify;
                synchronized (object) {
                    this.objetcToNotify.notify();
                }
            }
        }
        return this.exitValue;
    }

    public String[] getCommandArgs() {
        return this.commandArgs;
    }

    public int getExitValue() {
        return this.exitValue;
    }

    public String getHead() {
        if (this.stdOutGobbler != null) {
            return this.stdOutGobbler.getHead();
        }
        return "";
    }

    public String getHeadStderr() {
        if (this.stdErrGobbler != null) {
            return this.stdErrGobbler.getHead();
        }
        return "";
    }

    @Override
    public int getProgress() {
        return this.progress;
    }

    public String getPwd() {
        return this.pwd;
    }

    public String getRedirectStderr() {
        return this.redirectStderr;
    }

    public String getRedirectStdout() {
        return this.redirectStdout;
    }

    public String getStderr() {
        return this.stdErrGobbler == null ? "" : this.stdErrGobbler.getAllLines();
    }

    public OutputStream getStdin() {
        return this.stdin;
    }

    public String getStdout() {
        return this.stdOutGobbler == null ? "" : this.stdOutGobbler.getAllLines();
    }

    public LineFilter getStdOutFilter() {
        return this.stdOutFilter;
    }

    public boolean isAlertDone() {
        return this.stdOutGobbler.isAlertDone();
    }

    public boolean isBinaryStderr() {
        return this.binaryStderr;
    }

    public boolean isBinaryStdout() {
        return this.binaryStdout;
    }

    public boolean isExecuting() {
        return this.executing;
    }

    public boolean isQuiet() {
        return this.quietStdout;
    }

    public boolean isSaveStd() {
        return this.saveStd;
    }

    public boolean isStarted() {
        return this.started;
    }

    public void kill() {
        if (this.pr != null) {
            this.pr.destroy();
        }
        if (debug) {
            Log.debug("Process was killed");
        }
    }

    @Override
    public void progress() {
        ++this.progress;
    }

    public void resetBuffers() {
        this.stdOutGobbler.resetBuffer();
        this.stdErrGobbler.resetBuffer();
    }

    @Override
    public void run() {
        if (debug) {
            Log.debug("Running ExecOsCommand thread");
        }
        this.exec();
    }

    public void setBinaryStderr(boolean binaryStderr) {
        this.binaryStderr = binaryStderr;
    }

    public void setBinaryStdout(boolean binaryStdout) {
        this.binaryStdout = binaryStdout;
    }

    public void setCommandArgs(String[] commandArgs) {
        this.commandArgs = commandArgs;
    }

    public void setObjetcToNotify(Object objetcToNotify) {
        this.objetcToNotify = objetcToNotify;
    }

    public void setPwd(String pwd) {
        this.pwd = pwd;
    }

    public void setQuiet(boolean quietStdout, boolean quietStderr) {
        this.quietStdout = quietStdout;
        this.quietStderr = quietStderr;
    }

    public void setRedirectStderr(String redirectStderr) {
        this.redirectStderr = redirectStderr;
    }

    public void setRedirectStdout(String redirectStdout) {
        this.redirectStdout = redirectStdout;
    }

    public void setSaveStd(boolean saveStd) {
        this.saveStd = saveStd;
    }

    public void setShowExceptions(boolean showExceptions) {
        this.showExceptions = showExceptions;
    }

    public void setStdoutAlert(String alert) {
        this.stdOutGobbler.setAlert(alert);
    }

    public void setStdoutAlertNotify(Object toBeNotified) {
        this.stdOutGobbler.setAlertNotify(toBeNotified);
    }

    public void setStdOutFilter(LineFilter stdOutFilter) {
        this.stdOutFilter = stdOutFilter;
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (String c : this.commandArgs) {
            sb.append(c + " ");
        }
        return sb.toString();
    }
}

