/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.snpeff.nextProt.Identifier;
import org.snpeff.nextProt.NextProtHandler;
import org.snpeff.nextProt.NextProtMarkerFactory;
import org.snpeff.nextProt.NextProtXmlAnnotation;
import org.snpeff.nextProt.NextProtXmlIsoform;
import org.snpeff.nextProt.NextProtXmlNode;
import org.xml.sax.Attributes;

public class NextProtXmlEntry
extends NextProtXmlNode {
    List<NextProtXmlAnnotation> annotations;
    Identifier currentIdentifier;
    NextProtHandler handler;
    Set<Identifier> identifiers;
    Map<String, NextProtXmlIsoform> isoformsByAccession = new HashMap<String, NextProtXmlIsoform>();

    public NextProtXmlEntry(String accession, NextProtHandler handler) {
        super(accession);
        this.identifiers = new HashSet<Identifier>();
        this.annotations = new ArrayList<NextProtXmlAnnotation>();
        this.handler = handler;
    }

    public void add(NextProtXmlAnnotation ann) {
        this.annotations.add(ann);
    }

    public void addIsoformSequence(String isoformAccession, String sequence) {
        this.getOrCreateIsoform(isoformAccession).setSequence(sequence);
    }

    public void addMarkers(NextProtMarkerFactory markersFactory) {
        for (NextProtXmlAnnotation a : this.annotations) {
            a.addMarkers(markersFactory);
        }
    }

    public List<NextProtXmlAnnotation> getAnnotations() {
        return this.annotations;
    }

    public NextProtHandler getHandler() {
        return this.handler;
    }

    public Set<Identifier> getIdentifiers() {
        return this.identifiers;
    }

    public NextProtXmlIsoform getIsoform(String isoformAccession) {
        return this.isoformsByAccession.get(isoformAccession);
    }

    public Map<String, NextProtXmlIsoform> getIsoformsByAccession() {
        return this.isoformsByAccession;
    }

    public NextProtXmlIsoform getOrCreateIsoform(String isoformAccession) {
        NextProtXmlIsoform iso = this.isoformsByAccession.get(isoformAccession);
        if (iso == null) {
            iso = new NextProtXmlIsoform(isoformAccession);
            this.isoformsByAccession.put(isoformAccession, iso);
        }
        return iso;
    }

    void identifierEnd(String id) {
        this.currentIdentifier.id = id;
        this.identifiers.add(this.currentIdentifier);
        this.currentIdentifier = null;
    }

    void identifierStart(Attributes attributes) {
        this.currentIdentifier = new Identifier(attributes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Entry: '" + this.accession + "':\n");
        sb.append("\tIsoforms: " + this.isoformsByAccession.size() + "\n");
        for (String isoId : this.isoformsByAccession.keySet()) {
            sb.append("\t\t" + String.valueOf(this.isoformsByAccession.get(isoId)) + "\n");
        }
        sb.append("\tIdentifiers: " + this.identifiers.size() + "\n");
        for (Identifier i2 : this.identifiers) {
            sb.append("\t\t" + String.valueOf(i2) + "\n");
        }
        sb.append("\tAnnotations: " + this.annotations.size() + "\n");
        for (NextProtXmlAnnotation a : this.annotations) {
            sb.append("\t\t" + a.toString("\t\t") + "\n");
        }
        return sb.toString();
    }
}

