/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.ArrayList;
import java.util.List;
import org.snpeff.nextProt.CvTerm;
import org.snpeff.nextProt.Location;
import org.snpeff.nextProt.LocationTargetIsoform;
import org.snpeff.nextProt.LocationTargetIsoformInteraction;
import org.snpeff.nextProt.NextProtMarkerFactory;
import org.snpeff.nextProt.NextProtXmlEntry;
import org.snpeff.nextProt.NextProtXmlIsoform;
import org.snpeff.nextProt.NextProtXmlNode;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.snpeff.vcf.VcfEntry;
import org.xml.sax.Attributes;

public class NextProtXmlAnnotation
extends NextProtXmlNode {
    CvTerm cvTerm;
    String description;
    NextProtXmlEntry entry;
    String category;
    List<Location> locations;
    Location location;

    public NextProtXmlAnnotation(NextProtXmlEntry entry, String category) {
        super(null);
        this.entry = entry;
        this.category = category;
        this.init();
    }

    public void addMarkers(NextProtMarkerFactory markersFactory) {
        for (Location l : this.locations) {
            LocationTargetIsoform loc = (LocationTargetIsoform)l;
            NextProtXmlIsoform iso = this.entry.getIsoform(loc.accession);
            if (iso == null) {
                Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Isoform '" + loc.accession + "' not found for entry '" + this.entry.getAccession() + "'");
                continue;
            }
            for (String trId : iso.getTranscriptIds()) {
                markersFactory.addMarkers(this.entry, iso, this, loc, trId);
            }
        }
    }

    public String description() {
        if (this.cvTerm != null) {
            return this.cvTerm.description;
        }
        if (this.description != null) {
            if (this.description.indexOf(59) > 0) {
                return this.description.split(";")[0];
            }
            return this.description;
        }
        return null;
    }

    public String getCategory() {
        return this.category;
    }

    public CvTerm getCvTerm() {
        return this.cvTerm;
    }

    public void setCvTerm(CvTerm cvTerm) {
        this.cvTerm = cvTerm;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<Location> getLocations() {
        return this.locations;
    }

    public boolean hasCvTerm() {
        return this.cvTerm != null;
    }

    void init() {
        if (this.isIgnore(this.category)) {
            return;
        }
        this.locations = new ArrayList<Location>();
    }

    boolean isAnnotate(String category) {
        switch (category) {
            case "active-site": 
            case "binding-site": 
            case "cleavage-site": 
            case "cysteines": 
            case "disulfide-bond": 
            case "glycosylation-site": 
            case "lipidation-site": 
            case "modified-residue": 
            case "metal-binding-site": 
            case "selenocysteine": {
                return true;
            }
        }
        return false;
    }

    public boolean isEmpty() {
        return this.locations == null || this.locations.isEmpty();
    }

    boolean isIgnore(String category) {
        switch (category) {
            case "antibody-mapping": 
            case "beta-strand": 
            case "calcium-binding-region": 
            case "coiled-coil-region": 
            case "compositionally-biased-region": 
            case "cross-link": 
            case "dna-binding-region": 
            case "domain": 
            case "expression-info": 
            case "expression-profile": 
            case "function-info": 
            case "go-biological-process": 
            case "go-molecular-function": 
            case "go-cellular-component": 
            case "helix": 
            case "interacting-region": 
            case "initiator-methionine": 
            case "interaction-info": 
            case "interaction-mapping": 
            case "intramembrane-region": 
            case "mature-protein": 
            case "miscellaneous-region": 
            case "miscellaneous-site": 
            case "mitochondrial-transit-peptide": 
            case "mutagenesis": 
            case "non-terminal-residue": 
            case "nucleotide-phosphate-binding-region": 
            case "pathway": 
            case "pdb-mapping": 
            case "peptide-mapping": 
            case "peroxisome-transit-peptide": 
            case "propeptide": 
            case "repeat": 
            case "sequence-conflict": 
            case "short-sequence-motif": 
            case "signal-peptide": 
            case "srm-peptide-mapping": 
            case "subcellular-location": 
            case "topological-domain": 
            case "transmembrane-region": 
            case "turn": 
            case "uniprot-keyword": 
            case "variant": 
            case "zinc-finger-region": {
                return true;
            }
        }
        return false;
    }

    boolean isIntreaction(String category) {
        return category.equals("disulfide-bond");
    }

    public void locationBeginPos(Attributes attributes) {
        if (this.location != null) {
            this.location.begin = Gpr.parseIntSafe(attributes.getValue("position")) - 1;
        }
    }

    public void locationEnd() {
        if (this.locations != null) {
            if (this.isIntreaction(this.category)) {
                this.location = new LocationTargetIsoformInteraction((LocationTargetIsoform)this.location);
            }
            this.locations.add(this.location);
            if (!this.isAnnotate(this.category)) {
                this.entry.getHandler().countMissingCategory(this.category);
            }
        }
        this.location = null;
    }

    public void locationEndPos(Attributes attributes) {
        if (this.location != null) {
            this.location.end = Gpr.parseIntSafe(attributes.getValue("position")) - 1;
        }
    }

    public void locationIsoformStart(String accession) {
        this.location = new LocationTargetIsoform(accession);
    }

    public void locationStart(Attributes attributes) {
        if (this.location == null) {
            String type = attributes.getValue("type");
            this.location = new Location(type);
        }
    }

    public String name() {
        String descr = this.description();
        Object name = this.category + (String)(descr != null ? " " + descr : "");
        name = ((String)name).replace('.', '_');
        return VcfEntry.cleanUnderscores(VcfEntry.vcfInfoValueSafe((String)name));
    }

    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder();
        sb.append("Annotation '" + this.name() + "'\n");
        sb.append("\tDescription: " + this.description + "\n");
        sb.append("\t" + String.valueOf(this.cvTerm) + "\n");
        if (this.locations != null) {
            for (Location l : this.locations) {
                sb.append(prefix + "\t" + String.valueOf(l) + "\n");
            }
        }
        return sb.toString();
    }
}

