/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.ArrayList;
import java.util.Collections;
import org.snpeff.collections.AutoHashMap;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.NextProt;
import org.snpeff.snpEffect.Config;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Log;

public class NextProtSequenceConservation {
    public static final double HIGHLY_CONSERVED_AA_PERCENT = 0.99;
    public static final int HIGHLY_CONSERVED_AA_COUNT = 5;
    boolean debug;
    boolean verbose;
    AutoHashMap<String, CountByType> countAaSequenceByType = new AutoHashMap(new CountByType());

    public NextProtSequenceConservation() {
        this.verbose = Config.get().isVerbose();
        this.debug = Config.get().isDebug();
    }

    public void add(String category, String aaSequence) {
        CountByType cbt = this.countAaSequenceByType.getOrCreate(category);
        cbt.inc(aaSequence);
    }

    void analyzeSequenceConservation(Markers markers) {
        if (this.verbose) {
            Log.info("Sequence conservation analysis.\n\tAA sequence length  : 1\n\tMin AA count        : 5\n\tMin AA conservation : 0.99");
        }
        ArrayList keys = new ArrayList();
        keys.addAll(this.countAaSequenceByType.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            this.analyzeSequenceConservation(key, markers);
        }
    }

    void analyzeSequenceConservation(String category, Markers markers) {
        if (this.isHighlyConserved(category)) {
            int count = 0;
            for (Marker m : markers) {
                NextProt nextProt = (NextProt)m;
                if (!nextProt.getName().equals(category)) continue;
                nextProt.setHighlyConservedAaSequence(true);
                ++count;
            }
            if (this.verbose) {
                Log.info("NextProt " + count + " markers type '" + category + "' marked as highly conserved AA sequence");
            }
        }
    }

    int averageAaSeqLength(CountByType cbt) {
        int totlen = 0;
        for (String aas : cbt.keySet()) {
            totlen += aas.length();
        }
        return cbt.keySet().size() > 0 ? totlen / cbt.keySet().size() : 0;
    }

    boolean isHighlyConserved(String category) {
        CountByType cbt = (CountByType)this.countAaSequenceByType.get(category);
        long total = cbt.sum();
        int avgLen = this.averageAaSeqLength(cbt);
        if (this.verbose) {
            Log.info("Category '" + category + "', count: " + cbt.getTotalCount() + ", different sequences: " + cbt.keySet().size() + ", AA sequence length: " + avgLen);
        }
        boolean highlyConservedAaSequence = false;
        int rank = 1;
        for (String aas : cbt.keysRanked(false)) {
            long count = cbt.get(aas);
            double perc = (double)count / (double)total;
            if (this.verbose) {
                Log.info("\t" + count + "\t" + 100.0 * perc + "%\t\t" + aas);
            }
            if (perc > 0.99 && total >= 5L) {
                highlyConservedAaSequence = true;
            }
            if (++rank <= 50 || aas.length() <= 2 || !(perc < 0.001)) continue;
            break;
        }
        return highlyConservedAaSequence;
    }
}

