/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.NextProt;
import org.snpeff.interval.Transcript;
import org.snpeff.nextProt.Location;
import org.snpeff.nextProt.NextProtSequenceConservation;
import org.snpeff.nextProt.NextProtXmlAnnotation;
import org.snpeff.nextProt.NextProtXmlEntry;
import org.snpeff.nextProt.NextProtXmlIsoform;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public class NextProtMarkerFactory {
    int count;
    Config config;
    Genome genome;
    Markers markers;
    NextProtSequenceConservation sequenceConservation;
    Map<String, Transcript> trById;
    boolean verbose;

    public NextProtMarkerFactory(Config config) {
        this.config = config;
        this.genome = config.getGenome();
        this.trById = new HashMap<String, Transcript>();
        this.sequenceConservation = new NextProtSequenceConservation();
        this.markers = new Markers();
        this.addTranscripts();
        this.verbose = Config.get().isVerbose();
    }

    public Markers addMarkers(NextProtXmlEntry entry, NextProtXmlIsoform isoform, NextProtXmlAnnotation annotation, Location location, String trId) {
        if (isoform.getSequence() == null) {
            if (this.verbose) {
                Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Isoform '" + isoform.getAccession() + "' has no sequence");
            }
            return null;
        }
        Transcript tr = this.trById.get(trId);
        if (tr == null) {
            if (this.verbose) {
                Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Transcript '" + trId + "' not found");
            }
            return null;
        }
        if (!this.isProteinMatch(tr, isoform, location)) {
            return null;
        }
        if (this.verbose && this.count++ % 1000 == 0) {
            Log.info("ANNOTATION: " + annotation.name() + "\t" + trId + "\t" + location.begin + "\t" + location.end);
        }
        this.addConservation(isoform, annotation, location, tr);
        this.markers.add(this.nextProt(tr, annotation, location));
        return this.markers;
    }

    void addConservation(NextProtXmlIsoform isoform, NextProtXmlAnnotation annotation, Location location, Transcript tr) {
        int aaStart = location.begin;
        int aaEnd = location.end;
        if (location.isInteraction()) {
            String seq = isoform.getSequence();
            String aaSubSeq1 = seq.substring(aaStart, aaStart + 1);
            String aaSubSeq2 = seq.substring(aaEnd, aaEnd + 1);
            String name = annotation.name();
            this.sequenceConservation.add(name, aaSubSeq1);
            this.sequenceConservation.add(name, aaSubSeq2);
        } else if (location.isIsoform()) {
            String aaSubSeq = isoform.getSequence().substring(aaStart, aaEnd + 1);
            String name = annotation.name();
            this.sequenceConservation.add(name, aaSubSeq);
        }
    }

    void addTr(Transcript tr) {
        String trId = tr.getId();
        this.trById.put(trId, tr);
        if (trId.indexOf(46) > 0) {
            trId = trId.split("\\.")[0];
            this.trById.put(trId, tr);
        }
    }

    void addTranscripts() {
        for (Gene gene : this.genome.getGenes()) {
            for (Transcript tr : gene) {
                this.addTr(tr);
            }
        }
    }

    public void conservation() {
        this.sequenceConservation.analyzeSequenceConservation(this.markers);
    }

    public Markers getMarkers() {
        return this.markers;
    }

    boolean isProteinMatch(Transcript tr, NextProtXmlIsoform isoform, Location location) {
        if (!tr.isProteinCoding()) {
            if (this.verbose) {
                Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Transcript '" + tr.getId() + "' is not protein coding");
            }
            return false;
        }
        String aaSeqTr = tr.protein();
        if (aaSeqTr == null || aaSeqTr.isBlank()) {
            if (this.verbose) {
                Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Could not find protein sequence for transcript '" + tr.getId() + "'");
            }
            return false;
        }
        if ((aaSeqTr = this.proteinSequenceCleanup(aaSeqTr)).isBlank()) {
            if (this.verbose) {
                Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "Empty protein sequence after cleanup,  transcript '" + tr.getId() + "'");
            }
            return false;
        }
        String aaSeqIso = isoform.getSequence();
        if (aaSeqIso == null || aaSeqIso.isBlank()) {
            return false;
        }
        int aaStart = location.begin;
        int aaEnd = location.end;
        if (aaStart > aaEnd || aaStart < 0 || aaEnd >= aaSeqTr.length()) {
            if (this.verbose) {
                Log.warning("Amino acid coordinates error, transcript '" + tr.getId() + "', location [" + location.begin + ", " + location.end + "], for protein length " + aaSeqTr.length());
            }
            return false;
        }
        if (!(aaSeqIso = aaSeqIso.substring(aaStart, aaEnd).toUpperCase()).equals(aaSeqTr = aaSeqTr.substring(aaStart, aaEnd).toUpperCase())) {
            if (this.verbose) {
                Log.warning("Transcript '" + tr.getId() + "' protein sequence does not match isform '" + isoform.getAccession() + "' at [" + aaStart + ", " + aaEnd + "]\n" + GprSeq.showMismatch(tr.protein(), isoform.getSequence(), "\t"));
            }
            return false;
        }
        return true;
    }

    public Markers nextProt(Transcript tr, NextProtXmlAnnotation annotation, Location location) {
        if (location.isInteraction()) {
            Markers nextprotMarkers = new Markers();
            nextprotMarkers.add(this.nextProt(tr, annotation.accession, annotation.name(), location.begin, location.begin));
            nextprotMarkers.add(this.nextProt(tr, annotation.accession, annotation.name(), location.end, location.end));
            return nextprotMarkers;
        }
        return this.nextProt(tr, annotation.accession, annotation.name(), location.begin, location.end);
    }

    public Markers nextProt(Transcript tr, String accession, String name, int aaStart, int aaEnd) {
        int start = -1;
        int end = -1;
        if (tr.isStrandPlus()) {
            start = tr.codonNumber2Pos(aaStart)[0];
            end = tr.codonNumber2Pos(aaEnd)[2];
        } else {
            start = tr.codonNumber2Pos(aaEnd)[0];
            end = tr.codonNumber2Pos(aaStart)[2];
        }
        Marker marker = new Marker(tr.getChromosome(), start, end);
        Markers exons = new Markers();
        exons.addAll((Collection<? extends Marker>)tr.getExons());
        Markers exonsIntersected = exons.intersect(marker);
        Markers nextProtMarkers = new Markers();
        for (Marker m : exonsIntersected) {
            nextProtMarkers.add(new NextProt(tr, m.getStart(), m.getEnd(), accession, name));
        }
        return nextProtMarkers;
    }

    String proteinSequenceCleanup(String protein) {
        boolean change;
        do {
            int lastAa;
            change = false;
            int n = lastAa = !protein.isEmpty() ? (int)protein.charAt(protein.length() - 1) : 32;
            if (lastAa != 42 && lastAa != 63) continue;
            protein = protein.substring(0, protein.length() - 1);
            change = true;
        } while (change);
        return protein;
    }

    public void saveDatabase() {
        String nextProtBinFile = this.config.getDirDataGenomeVersion() + "/nextProt.bin";
        if (this.config.isVerbose()) {
            Log.info("Saving database to file '" + nextProtBinFile + "'");
        }
        HashSet<Chromosome> chromos = new HashSet<Chromosome>();
        for (Marker m : this.markers) {
            chromos.add(m.getChromosome());
        }
        Markers markersToSave = new Markers();
        markersToSave.add(this.genome);
        for (Chromosome chr : chromos) {
            markersToSave.add(chr);
        }
        for (Marker m : this.markers) {
            markersToSave.add(m);
        }
        markersToSave.save(nextProtBinFile);
    }
}

