/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.util.Stack;
import org.snpeff.nextProt.CvTerm;
import org.snpeff.nextProt.NextProtMarkerFactory;
import org.snpeff.nextProt.NextProtXmlAnnotation;
import org.snpeff.nextProt.NextProtXmlEntry;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Log;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class NextProtHandler
extends DefaultHandler {
    NextProtXmlAnnotation annotation;
    String annotationCategory;
    CvTerm cvTerm;
    NextProtXmlEntry entry;
    String isoformAccession;
    NextProtMarkerFactory markersFactory;
    CountByType missingCategories;
    Stack<String> stack;
    StringBuilder text;

    public NextProtHandler(NextProtMarkerFactory markersFactory) {
        this.markersFactory = markersFactory;
        this.stack = new Stack();
        this.missingCategories = new CountByType();
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        this.text.append(ch, start, length);
    }

    public void countMissingCategory(String category) {
        this.missingCategories.inc(category);
    }

    @Override
    public void endElement(String uri, String localName, String qName) throws SAXException {
        String qNamePop = this.stack.pop();
        if (!qNamePop.equals(qName)) {
            Log.info("Stack does not match: '" + qNamePop + "' != '" + qName + "'");
        }
        switch (qName) {
            case "annotation": {
                if (this.annotation != null && !this.annotation.isEmpty()) {
                    this.entry.add(this.annotation);
                }
                this.annotation = null;
                break;
            }
            case "annotation-category": {
                this.annotationCategory = null;
                break;
            }
            case "cv-term": {
                if (this.annotation != null && !this.annotation.hasCvTerm() && this.cvTerm != null && this.level().equals("annotation")) {
                    this.cvTerm.description = this.text.toString();
                    this.annotation.setCvTerm(this.cvTerm);
                }
                this.cvTerm = null;
                break;
            }
            case "description": {
                if (this.annotation == null || !this.level().equals("annotation") || this.annotation.getDescription() != null) break;
                this.annotation.setDescription(this.text.toString());
                break;
            }
            case "entry": {
                if (this.entry != null) {
                    this.entry.addMarkers(this.markersFactory);
                }
                this.entry = null;
                break;
            }
            case "identifier": {
                this.entry.identifierEnd(this.text.toString());
                break;
            }
            case "isoform-mapping": {
                this.isoformAccession = null;
                break;
            }
            case "isoform-sequence": {
                this.entry.addIsoformSequence(this.isoformAccession, this.text.toString());
                this.isoformAccession = null;
                break;
            }
            case "location": {
                if (this.annotation == null) break;
                this.annotation.locationEnd();
            }
        }
    }

    public CountByType getMissingCategories() {
        return this.missingCategories;
    }

    String level() {
        return (String)this.stack.lastElement();
    }

    @Override
    public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
        this.text = new StringBuilder();
        this.stack.push(qName);
        String accession = attributes.getValue("accession");
        switch (qName) {
            case "annotation": {
                if (this.entry == null) break;
                this.annotation = new NextProtXmlAnnotation(this.entry, this.annotationCategory);
                break;
            }
            case "annotation-category": {
                this.annotationCategory = attributes.getValue("category");
                break;
            }
            case "begin": {
                if (this.annotation == null) break;
                this.annotation.locationBeginPos(attributes);
                break;
            }
            case "cv-term": {
                if (this.annotation == null) break;
                this.cvTerm = new CvTerm(attributes);
                break;
            }
            case "end": {
                if (this.annotation == null) break;
                this.annotation.locationEndPos(attributes);
                break;
            }
            case "entry": {
                this.entry = new NextProtXmlEntry(accession, this);
                break;
            }
            case "identifier": {
                this.entry.identifierStart(attributes);
                break;
            }
            case "isoform-mapping": 
            case "isoform-sequence": {
                this.isoformAccession = accession;
                break;
            }
            case "location": {
                if (this.annotation == null) break;
                this.annotation.locationStart(attributes);
                break;
            }
            case "target-isoform": {
                if (this.annotation == null) break;
                this.annotation.locationIsoformStart(accession);
                break;
            }
            case "transcript-mapping": {
                this.entry.getOrCreateIsoform(this.isoformAccession).addTranscriptMapping(attributes);
                break;
            }
            case "transcript-protein": {
                this.entry.getIsoform(this.isoformAccession).addProteinMapping(attributes);
            }
        }
    }

    String toString(Attributes attributes) {
        StringBuilder sb = new StringBuilder();
        for (int i2 = 0; i2 < attributes.getLength(); ++i2) {
            String aname = attributes.getQName(i2);
            String aval = attributes.getValue(i2);
            String atype = attributes.getType(i2);
            sb.append(aname + " (" + atype + ") = '" + aval + "', ");
        }
        return sb.toString();
    }

    String toStringStack() {
        StringBuilder sb = new StringBuilder();
        for (String s : this.stack) {
            sb.append((s.length() > 0 ? " -> " : "") + s);
        }
        return sb.toString();
    }
}

