/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.nextProt;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.util.Locale;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.io.input.ReaderInputStream;
import org.snpeff.nextProt.NextProtHandler;
import org.snpeff.nextProt.NextProtMarkerFactory;
import org.snpeff.snpEffect.Config;
import org.snpeff.stats.CountByType;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;
import org.xml.sax.helpers.DefaultHandler;

public class NextProtDb {
    boolean debug;
    boolean verbose;
    String xmlDirName;
    Config config;
    NextProtMarkerFactory markersFactory;
    NextProtHandler handler;

    public NextProtDb(String xmlDirName, Config config) {
        this.config = config;
        this.xmlDirName = xmlDirName;
        this.markersFactory = new NextProtMarkerFactory(config);
    }

    public boolean parse() {
        String[] files;
        if (this.verbose) {
            Log.info("done");
        }
        if (this.verbose) {
            Log.info("Reading NextProt files from directory '" + this.xmlDirName + "'");
        }
        if ((files = new File(this.xmlDirName).list()) != null) {
            for (String xmlFileName : files) {
                if (this.verbose) {
                    Log.info("\tNextProt file '" + xmlFileName + "'");
                }
                if (!xmlFileName.endsWith(".xml.gz") && !xmlFileName.endsWith(".xml")) continue;
                String path = this.xmlDirName + "/" + xmlFileName;
                this.parse(path);
            }
        } else {
            Log.fatalError("No XML files found in directory '" + this.xmlDirName + "'");
        }
        this.markersFactory.conservation();
        StringBuilder sb = new StringBuilder();
        CountByType missingCats = this.handler.getMissingCategories();
        for (String cat : missingCats.keysRanked(true)) {
            sb.append("\t" + missingCats.get(cat) + "\t" + cat + "\n");
        }
        if (sb.length() > 0) {
            Log.warning("Missing categories:\n" + String.valueOf(sb));
        }
        return true;
    }

    void parse(String xmlFileName) {
        try {
            if (this.verbose) {
                Log.info("Reading file:" + xmlFileName);
            }
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            SAXParser saxParser = factory.newSAXParser();
            boolean isGzipped = xmlFileName.toLowerCase(Locale.ROOT).endsWith(".gz");
            BufferedReader reader = Gpr.reader(xmlFileName, isGzipped);
            ReaderInputStream inStream = new ReaderInputStream((Reader)reader);
            this.handler = new NextProtHandler(this.markersFactory);
            saxParser.parse((InputStream)inStream, (DefaultHandler)this.handler);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void saveDatabase() {
        this.markersFactory.saveDatabase();
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }
}

