/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.motif;

import org.snpeff.util.Gpr;

public class Pwm {
    public static final int SCALE = 100;
    static final double LOG2 = Math.log(2.0);
    public static final char[] BASES = new char[]{'A', 'C', 'G', 'T'};
    int[][] countMatrix;
    int[] count;
    double[][] logOdds;
    int length;
    int totalCount;
    String name;
    String id;
    char[] bestSequence;

    public Pwm(int length) {
        this.length = length;
        this.countMatrix = new int[BASES.length][length];
        this.count = new int[BASES.length];
        this.logOdds = null;
    }

    public Pwm(String file) {
        String data = Gpr.readFile(file);
        String[] lines = data.split("\n");
        this.length = lines.length;
        this.countMatrix = new int[BASES.length][this.length];
        this.count = new int[BASES.length];
        this.logOdds = new double[BASES.length][this.length];
        for (int lineNum = 0; lineNum < lines.length; ++lineNum) {
            String[] val = lines[lineNum].trim().split("\\s+");
            for (int baseNum = 0; baseNum < BASES.length; ++baseNum) {
                this.logOdds[baseNum][lineNum] = Gpr.parseDoubleSafe(val[baseNum]);
            }
        }
    }

    int base2int(char base) {
        switch (base) {
            case 'A': 
            case 'a': {
                return 0;
            }
            case 'C': 
            case 'c': {
                return 1;
            }
            case 'G': 
            case 'g': {
                return 2;
            }
            case 'T': 
            case 'U': 
            case 't': 
            case 'u': {
                return 3;
            }
        }
        return -1;
    }

    public void calcLogOddsWeight() {
        int baseNum;
        this.logOdds = new double[BASES.length][this.length];
        double[] b = new double[BASES.length];
        int total = 0;
        for (baseNum = 0; baseNum < BASES.length; ++baseNum) {
            this.count[baseNum] = 0;
            for (int i2 = 0; i2 < this.length; ++i2) {
                int n = baseNum;
                this.count[n] = this.count[n] + this.countMatrix[baseNum][i2];
                total += this.countMatrix[baseNum][i2];
            }
        }
        for (baseNum = 0; baseNum < BASES.length; ++baseNum) {
            b[baseNum] = (double)(this.count[baseNum] + 1) / (double)total;
        }
        for (int i3 = 0; i3 < this.length; ++i3) {
            for (int baseNum2 = 0; baseNum2 < BASES.length; ++baseNum2) {
                double p = (double)(this.countMatrix[baseNum2][i3] + 1) / (double)total;
                this.logOdds[baseNum2][i3] = -p * Math.log(p / b[baseNum2]) / LOG2;
            }
        }
    }

    public char[] getBestSequence() {
        if (this.bestSequence == null) {
            this.bestSequence = new char[this.length];
            for (int i2 = 0; i2 < this.countMatrix[0].length; ++i2) {
                int max = 0;
                int maxb = 0;
                for (int b = 0; b < BASES.length; ++b) {
                    if (max >= this.countMatrix[b][i2]) continue;
                    max = this.countMatrix[b][i2];
                    maxb = b;
                }
                this.bestSequence[i2] = BASES[maxb];
            }
        }
        return this.bestSequence;
    }

    public String getBestSequenceStr() {
        return new String(this.getBestSequence());
    }

    public int getCount(char base, int position) {
        return this.countMatrix[this.base2int(base)][position];
    }

    public String getId() {
        return this.id;
    }

    public double getLogOdds(char base, int position) {
        int baseIdx = this.base2int(base);
        if (baseIdx < 0 || position >= this.size()) {
            return 0.0;
        }
        return this.logOdds[baseIdx][position];
    }

    public String getName() {
        return this.name;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public boolean isConserved(int pos) {
        int countNonZero = 0;
        for (int i2 = 0; i2 < this.countMatrix.length; ++i2) {
            if (this.countMatrix[i2][pos] <= 0) continue;
            ++countNonZero;
        }
        return countNonZero == 1;
    }

    public int length() {
        return this.length;
    }

    public double score(String dna) {
        if (this.logOdds == null) {
            this.calcLogOddsWeight();
        }
        char[] bases = dna.toCharArray();
        double score = 0.0;
        for (int i2 = 0; i2 < bases.length; ++i2) {
            score += this.getLogOdds(bases[i2], i2);
        }
        return score / (double)this.length;
    }

    public void set(String dna) {
        char[] bases = dna.toCharArray();
        for (int i2 = 0; i2 < bases.length; ++i2) {
            for (int j = 0; j < BASES.length; ++j) {
                this.countMatrix[j][i2] = 1;
            }
            this.countMatrix[this.base2int((char)bases[i2])][i2] = 100;
        }
    }

    public void setCounts(char base, int[] counts) {
        int rowIdx = this.base2int(base);
        for (int i2 = 0; i2 < counts.length; ++i2) {
            this.countMatrix[rowIdx][i2] = counts[i2];
        }
    }

    public void setId(String id) {
        this.id = id;
    }

    public void setName(String name) {
        this.name = name;
    }

    int size() {
        return this.countMatrix[0].length;
    }

    public String toString() {
        int i2;
        StringBuffer sb = new StringBuffer();
        sb.append("Name: " + this.name + "\tId: " + this.id + "\n");
        if (this.countMatrix != null) {
            sb.append("Counts:\n");
            for (int b = 0; b < BASES.length; ++b) {
                sb.append(BASES[b] + "\t");
                for (i2 = 0; i2 < this.countMatrix[b].length; ++i2) {
                    sb.append(String.format("%10d  ", this.countMatrix[b][i2]));
                }
                sb.append("\n");
            }
            sb.append("Max:\t");
            char[] best = this.getBestSequence();
            for (i2 = 0; i2 < this.countMatrix[0].length; ++i2) {
                sb.append(String.format("%10s  ", Character.valueOf(best[i2])));
            }
            sb.append("\n");
        }
        if (this.logOdds != null) {
            sb.append("\nWeights:\n");
            for (int b = 0; b < BASES.length; ++b) {
                sb.append(BASES[b] + "\t");
                for (i2 = 0; i2 < this.logOdds[b].length; ++i2) {
                    sb.append(String.format("%10.2f  ", this.logOdds[b][i2]));
                }
                sb.append("\n");
            }
            sb.append("Max:\t");
            for (int i3 = 0; i3 < this.countMatrix[0].length; ++i3) {
                int maxb = 0;
                double max = Double.NEGATIVE_INFINITY;
                for (int b = 0; b < BASES.length; ++b) {
                    if (!(max < this.logOdds[b][i3])) continue;
                    max = this.logOdds[b][i3];
                    maxb = b;
                }
                sb.append(String.format("%10s  ", Character.valueOf(BASES[maxb])));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public void updateCounts(String dna) {
        this.updateCounts(dna, 1);
    }

    public void updateCounts(String dna, int inc) {
        this.totalCount += inc;
        char[] bases = dna.toCharArray();
        for (int i2 = 0; i2 < bases.length; ++i2) {
            int code = this.base2int(bases[i2]);
            if (code < 0) continue;
            int[] nArray = this.countMatrix[code];
            int n = i2;
            nArray[n] = nArray[n] + inc;
        }
    }
}

