/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.logStatsServer;

import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class LogStats
extends Thread {
    public static final int LOG_THREAD_WAIT_TIME = 1000;
    public static final int LOG_THREAD_WAIT_TIME_REPEAT = 5;
    public static boolean debug = false;
    private static final String URL_WWW = "http://www.dnaminer.com";
    private static final String URL_ROOT = "http://www.dnaminer.com/recuse.php";
    private static final String HTTP_CHARSET = "ISO-8859-1";
    private static final int HTTP_CONNECT_TIMEOUT_MSECS = 22000;
    private static final int HTTP_READ_TIMEOUT_MSECS = 23000;
    public StringBuilder msg = new StringBuilder();
    private final String versionFull;
    private final String programName;
    private RequestResult res = RequestResult.NOINFO;
    private long duration;
    protected boolean log = true;
    protected boolean verbose = false;
    HashMap<String, String> values;

    public static LogStats report(String software, String versionShort, String versionFull, boolean ok, boolean verbose, String[] args, String errorMessage, HashMap<String, String> reportValues) {
        LogStats logStats = new LogStats(software, versionShort, versionFull);
        if (args != null) {
            for (int i2 = 0; i2 < args.length; ++i2) {
                logStats.add("args_" + i2, args[i2]);
            }
        }
        logStats.add("Finished_OK", Boolean.toString(ok));
        if (errorMessage != null && !errorMessage.isEmpty()) {
            logStats.add("Error", errorMessage);
        }
        String[] properties = new String[]{"user.name", "os.name", "os.version", "os.arch"};
        for (String prop : properties) {
            try {
                logStats.add(prop, System.getProperty(prop));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            logStats.add("num.cores", "" + Gpr.NUM_CORES);
            logStats.add("total.mem", "" + Runtime.getRuntime().totalMemory());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (String name : reportValues.keySet()) {
            logStats.add(name, reportValues.get(name));
        }
        logStats.start();
        if (verbose) {
            Log.info("Logging");
        }
        for (int i3 = 0; i3 < 5 && logStats.isAlive(); ++i3) {
            try {
                Thread.sleep(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (logStats.isAlive() && !logStats.isInterrupted()) {
            logStats.interrupt();
        }
        return logStats;
    }

    public LogStats(String software, String versionShort, String versionFull) {
        this.programName = software;
        this.versionFull = versionFull;
        this.values = new HashMap();
    }

    public void add(String name, String value) {
        value = value.replaceAll("\\n", "\\\\n");
        value = value.replaceAll("\\t", "\\\\t");
        value = value.replaceAll("\\r", "");
        this.values.put(name, value);
    }

    private URL buildUrl() throws MalformedURLException {
        StringBuilder urlsb = new StringBuilder();
        urlsb.append(URL_ROOT).append("?");
        urlsb.append("program=").append(this.encode2url(this.programName));
        urlsb.append("&version=").append(this.encode2url(this.versionFull));
        ArrayList<String> names = new ArrayList<String>();
        names.addAll(this.values.keySet());
        Collections.sort(names);
        for (String name : names) {
            urlsb.append("&" + name + "=").append(this.encode2url(this.values.get(name)));
        }
        if (debug) {
            Log.debug("URL: " + String.valueOf(urlsb));
        }
        return new URL(urlsb.toString());
    }

    private URL buildUrlWrap() {
        try {
            return this.buildUrl();
        }
        catch (MalformedURLException e) {
            this.msg.append(e.getMessage());
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void connect() {
        int step = 0;
        long t0 = System.currentTimeMillis();
        if (debug) {
            Log.debug("Connect Step = " + step);
        }
        try {
            URL url = this.buildUrlWrap();
            step = 1;
            if (debug) {
                Log.debug("Connect Step = " + step);
            }
            URLConnection httpConnection = url.openConnection();
            step = 2;
            if (debug) {
                Log.debug("Connect Step = " + step);
            }
            httpConnection.setConnectTimeout(22000);
            httpConnection.setReadTimeout(23000);
            step = 3;
            if (debug) {
                Log.debug("Connect Step = " + step);
            }
            step = 4;
            String responseStr = Gpr.read(httpConnection.getInputStream());
            if (debug) {
                Log.debug("Server response: " + responseStr);
            }
            this.res = RequestResult.OK;
        }
        catch (Exception e) {
            if (debug) {
                e.printStackTrace();
            }
            this.msg.append(step > 3 ? "Bad response" : "Error in connection. ").append(" Step " + step).append("(").append(e.toString()).append(")");
            this.res = RequestResult.ERROR;
        }
        finally {
            this.duration = System.currentTimeMillis() - t0;
            if (debug && !this.res.completed()) {
                Log.debug("Error in connection: " + String.valueOf((Object)this.res) + " step=" + step + " duration(msecs)=" + this.duration + " " + String.valueOf(this.msg));
            }
        }
        if (debug) {
            Log.debug("Connect done!");
        }
    }

    private String encode2url(String data) {
        try {
            return URLEncoder.encode(data, HTTP_CHARSET);
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public RequestResult getRes() {
        return this.res;
    }

    @Override
    public void run() {
        block4: {
            try {
                if (debug) {
                    Log.debug("Running thread");
                }
                this.connect();
                if (debug) {
                    Log.debug("Thread finished");
                }
            }
            catch (Throwable t) {
                if (!debug) break block4;
                t.printStackTrace();
            }
        }
    }

    public static enum RequestResult {
        OK,
        ERROR,
        NOINFO;


        public boolean completed() {
            return this != ERROR && this != NOINFO;
        }
    }
}

