/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.tree;

import java.util.Arrays;
import java.util.Iterator;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.tree.Itree;
import org.snpeff.util.Log;

public class IntervalTreeArray
implements Itree {
    public static final int MIN_MARKERS_PER_LEAF = 4;
    public static final int INITIAL_CAPACITY = 1024;
    protected static final Marker[] EMPTY_MARKER_ARRAY = new Marker[0];
    protected boolean debug;
    protected boolean verbose;
    protected Markers markers = new Markers();
    protected boolean inSync;
    protected int[] left;
    protected int[] right;
    protected int[] mid;
    protected Marker[][] intersectMarkers;
    protected int lastIdx;

    public IntervalTreeArray() {
        this(null);
    }

    public IntervalTreeArray(Markers markers) {
        if (markers != null) {
            this.markers.add(markers);
        }
        this.inSync = false;
        this.reset();
    }

    @Override
    public void add(Marker interval) {
        this.markers.add(interval);
        this.inSync = false;
    }

    @Override
    public void add(Markers markers) {
        markers.add(markers);
        this.inSync = false;
    }

    @Override
    public void build() {
        this.markers.sort();
        this.reset();
        this.build(this.markers);
    }

    protected int build(Markers markers) {
        if (markers.isEmpty()) {
            return -1;
        }
        int idx = this.nextEntry();
        int center = markers.getMedian();
        Markers left = new Markers();
        Markers right = new Markers();
        Markers intersecting = new Markers();
        for (Marker interval : markers) {
            if (interval.getEnd() < center) {
                left.add(interval);
                continue;
            }
            if (interval.getStart() > center) {
                right.add(interval);
                continue;
            }
            intersecting.add(interval);
        }
        Marker[] intMarkers = null;
        if (!intersecting.isEmpty()) {
            intMarkers = intersecting.toArray();
        }
        int leftIdx = this.build(left);
        int rightIdx = this.build(right);
        this.set(idx, leftIdx, rightIdx, center, intMarkers);
        return idx;
    }

    int capacity() {
        if (this.left == null) {
            return 0;
        }
        return this.left.length;
    }

    @Override
    public Markers getIntervals() {
        return this.markers;
    }

    void grow() {
        int oldCapacity = this.capacity();
        int newCapacity = oldCapacity + (oldCapacity >> 1);
        this.left = Arrays.copyOf(this.left, newCapacity);
        this.right = Arrays.copyOf(this.right, newCapacity);
        this.mid = Arrays.copyOf(this.mid, newCapacity);
        this.intersectMarkers = (Marker[][])Arrays.copyOf(this.intersectMarkers, newCapacity);
    }

    @Override
    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    @Override
    public boolean isInSync() {
        return this.inSync;
    }

    boolean isLeaf(int idx) {
        return this.left[idx] == -1 && this.right[idx] == -1;
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.markers.iterator();
    }

    @Override
    public void load(String fileName, Genome genome) {
        throw new RuntimeException("Unimplemented!");
    }

    int nextEntry() {
        if (this.lastIdx >= this.capacity()) {
            this.grow();
        }
        return this.lastIdx++;
    }

    @Override
    public Markers query(Interval marker) {
        Markers results = new Markers();
        this.query(marker, 0, results);
        return results;
    }

    protected void query(Interval marker, int idx, Markers results) {
        if (this.debug) {
            Log.debug("query( " + String.valueOf(marker) + ", " + idx + " )\t" + this.toString(idx));
        }
        if (idx < 0) {
            return;
        }
        this.queryIntersects(marker, idx, results);
        int midPos = this.mid[idx];
        if (this.debug) {
            Log.debug("midPos:" + midPos);
        }
        if (marker.getStart() < midPos && this.left[idx] >= 0) {
            this.query(marker, this.left[idx], results);
        }
        if (midPos < marker.getEnd() && this.right[idx] >= 0) {
            this.query(marker, this.right[idx], results);
        }
    }

    protected void queryIntersects(Interval marker, int idx, Markers results) {
        Marker[] markers;
        if (this.debug) {
            Log.debug("queryIntersects( " + String.valueOf(marker) + ", " + idx + " )");
        }
        if (this.intersectMarkers[idx] == null) {
            return;
        }
        for (Marker m : markers = this.intersectMarkers[idx]) {
            if (!m.intersects(marker)) continue;
            results.add(m);
            if (!this.debug) continue;
            Log.debug("\tMatches entry: " + String.valueOf(m));
        }
    }

    protected void reset() {
        this.left = new int[1024];
        this.right = new int[1024];
        this.mid = new int[1024];
        this.intersectMarkers = new Marker[1024][];
        this.lastIdx = 0;
        for (int i2 = 0; i2 < this.left.length; ++i2) {
            this.right[i2] = -1;
            this.left[i2] = -1;
        }
    }

    void set(int idx, int leftIdx, int rightIdx, int midPos, Marker[] intMarkers) {
        this.left[idx] = leftIdx;
        this.right[idx] = rightIdx;
        this.mid[idx] = midPos;
        this.intersectMarkers[idx] = intMarkers;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    @Override
    public int size() {
        return this.markers.size();
    }

    @Override
    public Markers stab(int point) {
        Markers results = new Markers();
        this.stab(point, 0, results);
        return results;
    }

    protected void stab(int point, int idx, Markers results) {
        if (this.debug) {
            Log.debug("stab( " + point + ", " + idx + " )\t" + this.toString(idx));
        }
        if (idx < 0) {
            return;
        }
        this.stabIntersects(point, idx, results);
        int midPos = this.mid[idx];
        if (this.debug) {
            Log.debug("midPos:" + midPos);
        }
        if (point < midPos && this.left[idx] >= 0) {
            this.stab(point, this.left[idx], results);
        }
        if (midPos < point && this.right[idx] >= 0) {
            this.stab(point, this.right[idx], results);
        }
    }

    protected void stabIntersects(int point, int idx, Markers results) {
        Marker[] markers;
        if (this.debug) {
            Log.debug("stabIntersects( " + point + ", " + idx + " )");
        }
        if (this.intersectMarkers[idx] == null) {
            return;
        }
        for (Marker m : markers = this.intersectMarkers[idx]) {
            if (!m.intersects(point)) continue;
            results.add(m);
            if (!this.debug) continue;
            Log.debug("\tMatches entry: " + String.valueOf(m));
        }
    }

    public String toString() {
        return "Size: " + this.lastIdx + ", capacity: " + this.capacity();
    }

    public String toString(int idx) {
        if (idx < 0) {
            return "None";
        }
        StringBuilder sb = new StringBuilder();
        sb.append(idx + "\tleftIdx: " + this.left[idx] + "\trightIdx: " + this.right[idx] + "\tmidPos: " + this.mid[idx]);
        if (this.intersectMarkers[idx] != null) {
            sb.append("\tintersect: (" + this.intersectMarkers[idx].length + ")\n");
            for (int i2 = 0; i2 < this.intersectMarkers[idx].length; ++i2) {
                sb.append("\t\t" + i2 + ":\t" + String.valueOf(this.intersectMarkers[idx][i2]) + "\n");
            }
        }
        return sb.toString();
    }

    public String toStringAll() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.toString() + "\n");
        for (int i2 = 0; i2 < this.lastIdx; ++i2) {
            sb.append("\t" + this.toString(i2) + "\n");
        }
        return sb.toString();
    }
}

