/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.tree;

import java.io.Serializable;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;

public class IntervalNode
implements Serializable {
    private static final long serialVersionUID = -444656480302906048L;
    protected int center;
    protected IntervalNode leftNode;
    protected IntervalNode rightNode;
    protected Marker[] intervalsCenter;

    public IntervalNode() {
    }

    public IntervalNode(Markers markers) {
        this.build(markers);
    }

    protected void build(Markers markers) {
        if (markers.size() == 0) {
            this.center = 0;
            return;
        }
        this.center = markers.getMedian();
        Markers left = new Markers();
        Markers right = new Markers();
        Markers intersecting = new Markers();
        for (Marker interval : markers) {
            if (interval.getEnd() < this.center) {
                left.add(interval);
                continue;
            }
            if (interval.getStart() > this.center) {
                right.add(interval);
                continue;
            }
            intersecting.add(interval);
        }
        this.intervalsCenter = intersecting.isEmpty() ? null : intersecting.toArray();
        if (left.size() > 0) {
            this.leftNode = this.newNode(left);
        }
        if (right.size() > 0) {
            this.rightNode = this.newNode(right);
        }
    }

    public Integer getCenter() {
        return this.center;
    }

    public IntervalNode getLeft() {
        return this.leftNode;
    }

    public IntervalNode getRight() {
        return this.rightNode;
    }

    protected IntervalNode newNode(Markers markers) {
        return new IntervalNode(markers);
    }

    public Markers query(Interval queryInterval) {
        Markers results = new Markers();
        if (this.intervalsCenter != null) {
            for (Marker marker : this.intervalsCenter) {
                if (!marker.intersects(queryInterval)) continue;
                results.add(marker);
            }
        }
        if (queryInterval.getStart() < this.center && this.leftNode != null) {
            results.add(this.leftNode.query(queryInterval));
        }
        if (queryInterval.getEnd() > this.center && this.rightNode != null) {
            results.add(this.rightNode.query(queryInterval));
        }
        return results;
    }

    public Markers stab(Integer point) {
        Markers result = new Markers();
        if (this.intervalsCenter != null) {
            for (Marker marker : this.intervalsCenter) {
                if (!marker.intersects(point.intValue())) continue;
                result.add(marker);
            }
        }
        if (point < this.center && this.leftNode != null) {
            result.add(this.leftNode.stab(point));
        } else if (point > this.center && this.rightNode != null) {
            result.add(this.rightNode.stab(point));
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.center + ":\n");
        if (this.intervalsCenter != null) {
            for (Marker marker : this.intervalsCenter) {
                sb.append("\t" + String.valueOf(marker) + "\n");
            }
        }
        return sb.toString();
    }
}

