/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.tree;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.tree.IntervalTree;
import org.snpeff.interval.tree.Itree;
import org.snpeff.util.Log;

public class IntervalForest
implements Serializable,
Iterable<Itree> {
    private static final long serialVersionUID = 1L;
    boolean debug;
    String name;
    HashMap<String, Itree> forest = new HashMap();

    public IntervalForest() {
    }

    public IntervalForest(Markers markers) {
        this.add(markers);
    }

    public void add(Collection<? extends Marker> intervals) {
        for (Marker marker : intervals) {
            this.add(marker);
        }
    }

    public void add(Marker interval) {
        if (interval == null) {
            return;
        }
        String chName = Chromosome.simpleName(interval.getChromosomeName());
        this.getOrCreateTreeChromo(chName).add(interval);
    }

    public void add(Markers intervals) {
        for (Marker i2 : intervals) {
            this.add(i2);
        }
    }

    public void build() {
        for (String key : this.forest.keySet()) {
            if (this.debug) {
                Log.debug("Building interval tree for '" + key + "'");
            }
            Itree tree = this.forest.get(key);
            tree.build();
        }
    }

    public String getName() {
        return this.name;
    }

    public Itree getOrCreateTree(String id) {
        Itree itree = this.forest.get(id);
        if (itree == null) {
            itree = this.newItree();
            itree.build();
            this.forest.put(id, itree);
        }
        return itree;
    }

    public Itree getOrCreateTreeChromo(String chromo) {
        return this.getOrCreateTree(Chromosome.simpleName(chromo));
    }

    public Itree getTree(String key) {
        return this.forest.get(key);
    }

    public Itree getTreeChromo(String chromo) {
        return this.forest.get(Chromosome.simpleName(chromo));
    }

    public boolean hasTree(String chromo) {
        return this.getTreeChromo(chromo) != null;
    }

    public Markers intersect(Markers markers) {
        Markers result = new Markers();
        for (Marker mm : markers) {
            Markers query = this.query(mm);
            if (query == null) continue;
            for (Marker mq : query) {
                int start = Math.max(mq.getStart(), mm.getStart());
                int end = Math.max(mq.getEnd(), mm.getEnd());
                Marker mintq = new Marker(mq.getParent(), start, end, mq.isStrandMinus(), "");
                result.add(mintq);
            }
        }
        return result;
    }

    @Override
    public Iterator<Itree> iterator() {
        return this.forest.values().iterator();
    }

    public Collection<String> keySet() {
        return this.forest.keySet();
    }

    protected Itree newItree() {
        return new IntervalTree();
    }

    public Markers query(Marker marker) {
        return this.getOrCreateTreeChromo(marker.getChromosomeName()).query(marker);
    }

    public Markers query(Markers marker) {
        Markers ints = new Markers();
        for (Marker i2 : marker) {
            ints.add(this.query(i2));
        }
        return ints;
    }

    public Markers queryUnique(Markers markers) {
        HashSet<Marker> uniqueMarkers = new HashSet<Marker>();
        for (Marker q : markers) {
            Markers results = this.query(q);
            for (Marker r : results) {
                uniqueMarkers.add(r);
            }
        }
        Markers ints = new Markers();
        for (Marker r : uniqueMarkers) {
            ints.add(r);
        }
        return ints;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int size() {
        int size = 0;
        for (Itree it : this.forest.values()) {
            size += it.size();
        }
        return size;
    }

    public Markers stab(Marker marker) {
        return this.stab(marker.getChromosomeName(), marker.getStart());
    }

    public Markers stab(String chromo, int point) {
        return this.getOrCreateTreeChromo(chromo).stab(point);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.forest.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            Itree tree = this.getOrCreateTreeChromo(key);
            sb.append(key + "\tsize:" + tree.size() + "\tin_sync: " + tree.isInSync() + "\n");
        }
        return sb.toString();
    }
}

