/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import org.snpeff.interval.Exon;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChange;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Log;

public abstract class CodonChangeStructural
extends CodonChange {
    public static boolean debug = false;
    protected boolean coding;
    protected int exonFull;
    protected int exonPartial;
    protected String cdsAlt;
    protected String cdsRef;

    public CodonChangeStructural(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.coding = transcript.isProteinCoding() || Config.get().isTreatAllAsProteinCoding();
        this.countAffectedExons();
    }

    protected void cdsDiff() {
        int codonNumEndAlt;
        int min = Math.min(this.cdsRef.length(), this.cdsAlt.length()) / 3;
        this.codonStartNum = 0;
        this.codonStartIndex = 0;
        for (int i2 = 0; i2 <= min; ++i2) {
            this.codonStartNum = i2;
            if (debug) {
                Log.debug("cdsDiff Start\tcodonEquals(" + i2 + " , " + i2 + "): " + this.codonEquals(this.cdsRef, this.cdsAlt, i2, i2) + "\n\tcodonsRef [" + this.codonStartNum + "]: " + this.codons(this.cdsRef, this.codonStartNum, -1) + "\n\tcodonsAlt [" + this.codonStartNum + "]: " + this.codons(this.cdsAlt, this.codonStartNum, -1));
            }
            if (this.codonEquals(this.cdsRef, this.cdsAlt, i2, i2)) continue;
            this.codonStartIndex = this.codonDiffIndex(this.cdsRef, this.cdsAlt, i2, i2);
            break;
        }
        int codonNumEndRef = this.cdsRef.length() / 3;
        for (codonNumEndAlt = this.cdsAlt.length() / 3; codonNumEndRef >= this.codonStartNum && codonNumEndAlt >= this.codonStartNum; --codonNumEndRef, --codonNumEndAlt) {
            if (debug) {
                Log.debug("cdsDiff End\tcodonEquals(" + codonNumEndRef + " , " + codonNumEndAlt + "): " + this.codonEquals(this.cdsRef, this.cdsAlt, codonNumEndRef, codonNumEndAlt) + "\n\tcodonsRef [" + this.codonStartNum + " , " + codonNumEndRef + "]: " + this.codons(this.cdsRef, this.codonStartNum, codonNumEndRef) + "\n\tcodonsAlt [" + this.codonStartNum + " , " + codonNumEndAlt + "]: " + this.codons(this.cdsAlt, this.codonStartNum, codonNumEndAlt));
            }
            if (!this.codonEquals(this.cdsRef, this.cdsAlt, codonNumEndRef, codonNumEndAlt)) break;
        }
        this.codonsRef = this.codons(this.cdsRef, this.codonStartNum, codonNumEndRef);
        this.codonsAlt = this.codons(this.cdsAlt, this.codonStartNum, codonNumEndAlt);
        if (this.codonsRef.isEmpty() && this.codonsAlt.isEmpty()) {
            this.codonStartIndex = -1;
            this.codonStartNum = -1;
        }
    }

    @Override
    public void codonChange() {
        if (this.variant.includes(this.transcript)) {
            this.effectTranscript();
        } else if (this.exonFull > 0 || this.exonPartial > 0) {
            this.exons();
        } else {
            this.intron();
        }
    }

    protected void codonChangeSuper() {
        super.codonChange();
    }

    private int codonDiffIndex(String cdsRef, String cdsAlt, int codonNumRef, int codonNumAlt) {
        int i2 = 3 * codonNumRef;
        int j = 3 * codonNumAlt;
        for (int h = 0; h < 3; ++h) {
            if (i2 >= cdsRef.length() || j >= cdsAlt.length()) {
                return h;
            }
            if (cdsRef.charAt(i2) != cdsAlt.charAt(j)) {
                return h;
            }
            ++i2;
            ++j;
        }
        return -1;
    }

    private boolean codonEquals(String cdsRef, String cdsAlt, int codonNumRef, int codonNumAlt) {
        int i2 = 3 * codonNumRef;
        int j = 3 * codonNumAlt;
        for (int h = 0; h < 3; ++h) {
            if (i2 >= cdsRef.length() || j >= cdsAlt.length()) {
                return i2 >= cdsRef.length() && j >= cdsAlt.length();
            }
            if (cdsRef.charAt(i2) != cdsAlt.charAt(j)) {
                return false;
            }
            ++i2;
            ++j;
        }
        return true;
    }

    private String codons(String cds, int codonNumStart, int codonNumEnd) {
        if (codonNumEnd >= 0 && codonNumEnd < codonNumStart) {
            return "";
        }
        int endBase = codonNumEnd < 0 ? cds.length() : 3 * (codonNumEnd + 1);
        endBase = Math.min(cds.length(), endBase);
        int startBase = Math.max(0, 3 * codonNumStart);
        return cds.substring(startBase, endBase);
    }

    protected void codonsRefAlt() {
        Transcript trNew = this.transcript.apply(this.variant);
        if (debug) {
            Log.debug("Transcript after apply: " + String.valueOf(trNew));
        }
        this.cdsAlt = trNew.cds();
        this.cdsRef = this.transcript.cds();
        this.cdsDiff();
    }

    protected void countAffectedExons() {
        this.exonPartial = 0;
        this.exonFull = 0;
        for (Exon ex : this.transcript) {
            if (this.variant.includes(ex)) {
                ++this.exonFull;
                continue;
            }
            if (!this.variant.intersects(ex)) continue;
            ++this.exonPartial;
        }
    }

    protected abstract void effectTranscript();

    protected abstract void exons();

    protected abstract void exonsCoding();

    protected abstract void exonsNoncoding();

    protected abstract void intron();
}

