/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import org.snpeff.interval.Exon;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChange;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.VariantEffects;

public class CodonChangeSnp
extends CodonChange {
    public CodonChangeSnp(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
        this.returnNow = true;
    }

    @Override
    protected boolean codonChange(Exon exon) {
        this.codonsRef = this.codonsRef();
        this.codonsAlt = this.codonsAlt();
        this.effect(exon, EffectType.CODON_CHANGE, true);
        if (this.codonsRef.isEmpty()) {
            this.variantEffects.addErrorWarning(this.variant, ErrorWarningType.ERROR_MISSING_CDS_SEQUENCE);
        }
        return true;
    }

    @Override
    protected String codonsAlt() {
        if (this.codonsRef.isEmpty()) {
            return "";
        }
        char[] codonChars = this.codonsRef.toLowerCase().toCharArray();
        char snpBase = this.variant.netChange(this.transcript.isStrandMinus()).charAt(0);
        if (this.codonStartIndex < codonChars.length) {
            codonChars[this.codonStartIndex] = Character.toUpperCase(snpBase);
        }
        String codonsNew = new String(codonChars);
        return codonsNew;
    }

    @Override
    protected String codonsRef() {
        int maxBase;
        int numCodons = 1;
        String cdsStr = this.transcript.cds();
        int cdsLen = cdsStr.length();
        int minBase = this.codonStartNum * 3;
        if (minBase < 0) {
            minBase = 0;
        }
        if ((maxBase = this.codonStartNum * 3 + numCodons * 3) > cdsLen) {
            maxBase = cdsLen;
        }
        if (cdsStr.isEmpty() || cdsLen <= minBase) {
            return "";
        }
        char[] codonChars = cdsStr.substring(minBase, maxBase).toLowerCase().toCharArray();
        if (this.codonStartIndex < codonChars.length) {
            codonChars[this.codonStartIndex] = Character.toUpperCase(codonChars[this.codonStartIndex]);
        }
        String codon = new String(codonChars);
        return codon;
    }
}

