/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval.codonChange;

import org.snpeff.interval.Exon;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChange;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;

public class CodonChangeInv
extends CodonChange {
    public CodonChangeInv(Variant variant, Transcript transcript, VariantEffects variantEffects) {
        super(variant, transcript, variantEffects);
    }

    @Override
    public void codonChange() {
        if (this.variant.includes(this.transcript)) {
            this.effectNoCodon(this.transcript, EffectType.TRANSCRIPT_INVERSION);
        } else {
            boolean intersectsExons = false;
            for (Exon ex : this.transcript) {
                if (!this.variant.intersects(ex)) continue;
                intersectsExons = true;
                break;
            }
            if (intersectsExons) {
                this.exons();
            } else {
                this.intron();
            }
        }
    }

    void exons() {
        Marker cdsMarker = null;
        if (this.transcript.isProteinCoding()) {
            cdsMarker = this.transcript.cdsMarker();
        }
        for (Exon ex : this.transcript) {
            Marker intersect;
            if (!this.variant.intersects(ex)) continue;
            VariantEffect.EffectImpact impact = VariantEffect.EffectImpact.LOW;
            if (cdsMarker != null && (intersect = this.variant.intersect(ex)) != null && intersect.intersects(cdsMarker)) {
                impact = VariantEffect.EffectImpact.HIGH;
            }
            EffectType effType = this.variant.includes(ex) ? EffectType.EXON_INVERSION : EffectType.EXON_INVERSION_PARTIAL;
            this.effectNoCodon(ex, effType, impact);
        }
    }

    void intron() {
        this.effectNoCodon(this.transcript, EffectType.INTRON);
    }
}

