/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.LinkedList;
import java.util.List;
import org.snpeff.align.VariantRealign;
import org.snpeff.binseq.GenomicSequences;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.util.GprSeq;
import org.snpeff.util.IubString;

public class Variant
extends Marker {
    public static final int HUGE_DELETION_SIZE_THRESHOLD = 1000000;
    public static final double HUGE_DELETION_RATIO_THRESHOLD = 0.01;
    public static final Variant NO_VARIANT = new Variant(null, 0, 0, "");
    private static final long serialVersionUID = -2928105165111400441L;
    protected VariantType variantType;
    protected String ref;
    protected String alt;
    protected String genotype;
    protected boolean imprecise = false;

    public Variant() {
        this.alt = "";
        this.ref = "";
        this.variantType = VariantType.INTERVAL;
    }

    public Variant(Marker parent, int start, int end, String id) {
        super(parent, start, end, false, id);
        this.alt = "";
        this.ref = "";
        this.variantType = VariantType.INTERVAL;
    }

    public Variant(Marker parent, int position, String referenceStr, String altStr) {
        this(parent, position, referenceStr, altStr, "");
    }

    public Variant(Marker parent, int position, String referenceStr, String altStr, String id) {
        super(parent, position, position, false, id);
        this.init(parent, position, referenceStr, altStr, null, id);
    }

    public static List<Variant> factory(Chromosome chromo, int start, String ref, String altStr, String id, boolean expand) {
        String[] alts;
        LinkedList<Variant> list = new LinkedList<Variant>();
        if (altStr == null) {
            Variant var = new Variant((Marker)chromo, start, ref, null, id);
            list.add(var);
            return list;
        }
        if (altStr.indexOf(44) >= 0) {
            alts = altStr.split(",");
        } else {
            alts = altStr.split("/");
            if (alts.length == 2 && alts[0].equals(alts[1])) {
                Variant var = new Variant((Marker)chromo, start, ref, alts[0], id);
                list.add(var);
                return list;
            }
        }
        for (String alt : alts) {
            IubString iubsRef;
            Variant var;
            Variant var2;
            if (!expand) {
                var2 = new Variant((Marker)chromo, start, ref, alt, id);
                list.add(var2);
                continue;
            }
            boolean refIub = IubString.hasIUBMax(ref);
            boolean altIub = IubString.hasIUBMax(alt);
            if (!refIub && !altIub) {
                var2 = new Variant((Marker)chromo, start, ref, alt, id);
                list.add(var2);
                continue;
            }
            if (altIub && !refIub) {
                IubString iubsAlt = new IubString(alt);
                for (String seqAlt : iubsAlt) {
                    var = new Variant((Marker)chromo, start, ref, seqAlt, id);
                    list.add(var);
                }
                continue;
            }
            if (!altIub && refIub) {
                iubsRef = new IubString(ref);
                for (String seqRef : iubsRef) {
                    var = new Variant((Marker)chromo, start, seqRef, alt, id);
                    list.add(var);
                }
                continue;
            }
            if (!altIub || !refIub) continue;
            iubsRef = new IubString(ref);
            for (String seqRef : iubsRef) {
                IubString iubsAlt = new IubString(alt);
                for (String seqAlt : iubsAlt) {
                    Variant var3 = new Variant((Marker)chromo, start, seqRef, seqAlt, id);
                    list.add(var3);
                }
            }
        }
        return list;
    }

    @Override
    public Variant clone() {
        return (Variant)super.clone();
    }

    @Override
    public Variant cloneShallow() {
        Variant clone = (Variant)super.cloneShallow();
        clone.variantType = this.variantType;
        clone.ref = this.ref;
        clone.alt = this.alt;
        clone.genotype = this.genotype;
        clone.imprecise = this.imprecise;
        return clone;
    }

    @Override
    public int compareTo(Interval i2) {
        int comp = this.compareToPos(i2);
        if (comp != 0) {
            return comp;
        }
        Variant v2 = (Variant)i2;
        comp = this.ref.compareTo(v2.ref);
        if (comp != 0) {
            return comp;
        }
        comp = this.alt.compareTo(v2.alt);
        return comp;
    }

    public Variant[] decompose() {
        if (this.variantType != VariantType.MIXED) {
            throw new RuntimeException("Cannot decompose variant type " + String.valueOf((Object)this.variantType) + ":\n\t" + String.valueOf(this));
        }
        Variant varMnp = null;
        Variant varInDel = null;
        if (this.ref.length() < this.alt.length()) {
            varMnp = new Variant((Marker)this.getChromosome(), this.start, this.ref, this.alt.substring(0, this.ref.length()), this.id + "_MNP");
            varInDel = new Variant((Marker)this.getChromosome(), this.start + this.ref.length(), "", this.alt.substring(this.ref.length()), this.id + "_INS");
        } else {
            varMnp = new Variant((Marker)this.getChromosome(), this.start, this.ref.substring(0, this.alt.length()), this.alt, this.id + "_MNP");
            varInDel = new Variant((Marker)this.getChromosome(), this.start + this.alt.length(), this.ref.substring(this.alt.length()), "", this.id + "_DEL");
        }
        Variant[] variants = new Variant[]{varMnp, varInDel};
        return variants;
    }

    public String getAlt() {
        return this.alt;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public void setGenotype(String genotype) {
        this.genotype = genotype;
    }

    public String getReference() {
        return this.ref;
    }

    public VariantType getVariantType() {
        return this.variantType;
    }

    public void setVariantType(VariantType variantType) {
        this.variantType = variantType;
    }

    @Override
    public int hashCode() {
        int hashCode = this.getChromosomeName().hashCode();
        hashCode = hashCode * 31 + this.start;
        hashCode = hashCode * 31 + this.end;
        hashCode = hashCode * 31 + (this.strandMinus ? -1 : 1);
        hashCode = hashCode * 31 + this.id.hashCode();
        hashCode = hashCode * 31 + this.ref.hashCode();
        hashCode = hashCode * 31 + this.alt.hashCode();
        return hashCode;
    }

    void init(Marker parent, int position, String referenceStr, String altStr, VariantType variantType, String id) {
        if (altStr == null) {
            altStr = referenceStr;
            variantType = VariantType.INTERVAL;
        }
        this.ref = referenceStr.toUpperCase();
        this.alt = altStr.toUpperCase();
        if (altStr.indexOf(44) >= 0 || altStr.indexOf(47) >= 0) {
            throw new RuntimeException("Variants with multiple ALTs are not allowed (ALT: '" + altStr + "')");
        }
        if (this.ref.equals("*")) {
            this.ref = "";
        }
        if (this.alt.startsWith("+")) {
            this.alt = this.ref + this.alt.substring(1);
        } else if (this.alt.startsWith("-")) {
            this.ref = this.alt.substring(1);
            this.alt = "";
        } else if (this.alt.startsWith("=")) {
            this.alt = altStr.substring(1);
        }
        this.variantType = variantType == null ? (this.ref.equals(this.alt) ? VariantType.INTERVAL : (this.ref.length() == 1 && this.alt.length() == 1 ? VariantType.SNP : (this.ref.length() == this.alt.length() ? VariantType.MNP : (this.ref.length() < this.alt.length() && this.alt.startsWith(this.ref) ? VariantType.INS : (this.ref.length() > this.alt.length() && this.ref.startsWith(this.alt) ? VariantType.DEL : VariantType.MIXED))))) : variantType;
        this.start = position;
        if (this.isIns() || this.isSnp()) {
            this.end = this.start;
        } else if (this.ref.length() > 1) {
            this.end = this.start + this.ref.length() - 1;
        }
        this.type = EffectType.NONE;
        this.id = id;
    }

    public boolean isBnd() {
        return false;
    }

    public boolean isDel() {
        return this.variantType == VariantType.DEL;
    }

    public boolean isDup() {
        return this.variantType == VariantType.DUP;
    }

    public boolean isElongation() {
        return this.lengthChange() > 0;
    }

    public boolean isImprecise() {
        return this.imprecise;
    }

    public void setImprecise(boolean imprecise) {
        this.imprecise = imprecise;
    }

    public boolean isInDel() {
        return this.variantType == VariantType.INS || this.variantType == VariantType.DEL;
    }

    public boolean isIns() {
        return this.variantType == VariantType.INS;
    }

    public boolean isInterval() {
        return this.variantType == VariantType.INTERVAL;
    }

    public boolean isInv() {
        return this.variantType == VariantType.INV;
    }

    public boolean isMixed() {
        return this.variantType == VariantType.MIXED;
    }

    public boolean isMnp() {
        return this.variantType == VariantType.MNP;
    }

    public boolean isNonRef() {
        return false;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    public boolean isSnp() {
        return this.variantType == VariantType.SNP;
    }

    public boolean isStructural() {
        return this.isDel() || this.isInv() || this.isDup() || this.isBnd();
    }

    public boolean isStructuralHuge() {
        if (!this.isStructural()) {
            return false;
        }
        Chromosome chr = this.getChromosome();
        if (chr != null && chr.size() > 1000000) {
            double ratio = (double)this.size() / (double)chr.size();
            return this.size() > 1000000 || ratio > 0.01;
        }
        return this.size() > 1000000;
    }

    public boolean isTruncation() {
        return this.lengthChange() < 0;
    }

    public boolean isVariant() {
        return this.variantType != VariantType.INTERVAL;
    }

    public int lengthChange() {
        if (this.isSnp() || this.isMnp()) {
            return 0;
        }
        if (!this.ref.isEmpty() || !this.alt.isEmpty()) {
            return this.alt.length() - this.ref.length();
        }
        return this.end - this.start;
    }

    public String netChange(boolean reverseStrand) {
        if (this.isDel()) {
            return reverseStrand ? GprSeq.reverseWc(this.ref) : this.ref;
        }
        return reverseStrand ? GprSeq.reverseWc(this.alt) : this.alt;
    }

    public String netChange(Marker marker) {
        int removeAfter;
        int removeBefore;
        String netChange = this.alt;
        if (this.isDel()) {
            netChange = this.ref;
        }
        if ((removeBefore = marker.getStart() - this.start) > 0) {
            if (removeBefore >= netChange.length()) {
                return "";
            }
        } else {
            removeBefore = 0;
        }
        if ((removeAfter = this.end - marker.getEnd()) > 0) {
            if (removeBefore + removeAfter >= netChange.length()) {
                return "";
            }
        } else {
            removeAfter = 0;
        }
        netChange = netChange.substring(removeBefore, netChange.length() - removeAfter);
        return netChange;
    }

    public Variant realignLeft() {
        GenomicSequences gs = this.getGenome().getGenomicSequences();
        if (gs == null) {
            return this;
        }
        VariantRealign vr = new VariantRealign(this);
        vr.setDebug(Config.get().isDebug());
        if (!vr.realign()) {
            return this;
        }
        return vr.getVariantRealigned();
    }

    public Variant reverse() {
        Variant clone = (Variant)super.cloneShallow();
        clone.variantType = this.variantType;
        clone.alt = this.ref;
        clone.ref = this.alt;
        clone.genotype = this.ref;
        clone.imprecise = this.imprecise;
        return clone;
    }

    @Override
    public String toString() {
        if ((this.ref == null || this.ref.isEmpty()) && (this.alt == null || this.alt.isEmpty())) {
            return "chr" + this.getChromosomeName() + ":" + this.start + "-" + this.end + "[" + String.valueOf((Object)this.variantType) + "]";
        }
        return "chr" + this.getChromosomeName() + ":" + this.start + "_" + this.getReference() + "/" + this.getAlt() + (String)(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "");
    }

    public String toStringEnsembl() {
        return this.getChromosomeName() + "\t" + this.start + "\t" + this.end + "\t" + this.ref + "/" + this.alt + "\t+";
    }

    public String toStringOld() {
        if (this.isIns()) {
            return this.getChromosomeName() + ":" + this.getStart() + "_*/+" + this.getAlt();
        }
        if (this.isDel()) {
            return this.getChromosomeName() + ":" + this.getStart() + "_*/-" + this.getReference();
        }
        return this.getChromosomeName() + ":" + this.getStart() + "_" + this.getReference() + "/" + this.getAlt();
    }

    public static enum VariantType {
        SNP,
        MNP,
        INS,
        DEL,
        MIXED,
        INV,
        DUP,
        CNV,
        BND,
        INTERVAL;

    }
}

