/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

public enum TranscriptSupportLevel {
    TSL_1,
    TSL_2,
    TSL_3,
    TSL_4,
    TSL_5,
    TSL_NA;

    public static final int TSL_NULL_VALUE = 9;

    public static TranscriptSupportLevel parse(String str) {
        if (str.startsWith("TSL_")) {
            return TranscriptSupportLevel.valueOf(str);
        }
        if (str.length() > 2) {
            str = str.substring(0, 2).trim();
        }
        try {
            return TranscriptSupportLevel.valueOf("TSL_" + str);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static int tsl(TranscriptSupportLevel tsl) {
        if (tsl == null) {
            return 9;
        }
        switch (tsl.ordinal()) {
            case 0: {
                return 1;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 5;
            }
            case 5: {
                return 6;
            }
        }
        throw new RuntimeException("Unimplemented TSL level " + String.valueOf((Object)tsl));
    }
}

