/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Cds;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Downstream;
import org.snpeff.interval.Exon;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Gene;
import org.snpeff.interval.IntervalAndSubIntervals;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Intron;
import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerUtil;
import org.snpeff.interval.Markers;
import org.snpeff.interval.SpliceSite;
import org.snpeff.interval.TranscriptSupportLevel;
import org.snpeff.interval.Upstream;
import org.snpeff.interval.Utr;
import org.snpeff.interval.Utr3prime;
import org.snpeff.interval.Utr5prime;
import org.snpeff.interval.Variant;
import org.snpeff.interval.codonChange.CodonChange;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.stats.ObservedOverExpectedCpG;
import org.snpeff.util.Gpr;
import org.snpeff.util.GprSeq;
import org.snpeff.util.Log;

public class Transcript
extends IntervalAndSubIntervals<Exon> {
    private static final long serialVersionUID = -2665025617916107311L;
    boolean aaCheck;
    boolean canonical;
    boolean corrected;
    boolean dnaCheck;
    boolean proteinCoding;
    boolean ribosomalSlippage;
    int cdsStart;
    int cdsEnd;
    int spliceSiteSize;
    int spliceRegionExonSize;
    int spliceRegionIntronMin;
    int spliceRegionIntronMax;
    int upDownLength;
    BioType bioType;
    String cds;
    String mRna;
    String protein;
    String version = "";
    List<Utr> utrs;
    List<Cds> cdss;
    List<Intron> introns;
    Upstream upstream;
    Downstream downstream;
    Exon firstCodingExon;
    int[] aa2pos;
    int[] cds2pos;
    TranscriptSupportLevel transcriptSupportLevel = null;
    String tags;
    String proteinId;

    public Transcript() {
        this.utrs = new ArrayList<Utr>();
        this.cdss = new ArrayList<Cds>();
        this.type = EffectType.TRANSCRIPT;
    }

    public Transcript(Gene gene, int start, int end, boolean strandMinus, String id) {
        super(gene, start, end, strandMinus, id);
        this.type = EffectType.TRANSCRIPT;
    }

    public synchronized int[] aaNumber2Pos() {
        if (this.aa2pos != null) {
            return this.aa2pos;
        }
        this.calcCdsStartEnd();
        this.aa2pos = new int[this.protein().length()];
        for (int i2 = 0; i2 < this.aa2pos.length; ++i2) {
            this.aa2pos[i2] = -1;
        }
        int cdsMin = Math.min(this.cdsStart, this.cdsEnd);
        int cdsMax = Math.max(this.cdsStart, this.cdsEnd);
        int aaNum = 0;
        int step = this.isStrandPlus() ? 1 : -1;
        int codonFrame = 0;
        for (Exon exon : this.sortedStrand()) {
            int min = this.isStrandPlus() ? exon.getStart() : exon.getEnd();
            int aaIdxStart = -1;
            int aaIdxEnd = -1;
            int pos = min;
            while (exon.intersects(pos) && aaNum < this.aa2pos.length) {
                if (cdsMin <= pos && pos <= cdsMax) {
                    if (aaIdxStart < 0) {
                        aaIdxStart = aaNum;
                    }
                    aaIdxEnd = aaNum;
                    if (codonFrame == 0) {
                        this.aa2pos[aaNum] = pos;
                    }
                    if (codonFrame == 2) {
                        ++aaNum;
                    }
                    codonFrame = (codonFrame + 1) % 3;
                }
                pos += step;
            }
            if (aaIdxStart < 0) continue;
            exon.setAaIdx(aaIdxStart, aaIdxEnd);
        }
        return this.aa2pos;
    }

    public int aaNumber2Pos(int aaNum) {
        int[] aa2pos = this.aaNumber2Pos();
        if (aaNum < 0 || aaNum > aa2pos.length) {
            return -1;
        }
        return aa2pos[aaNum];
    }

    @Override
    public void add(Cds cdsInt) {
        this.cdss.add(cdsInt);
        this.cds = null;
    }

    @Override
    public void add(Intron intron) {
        if (this.introns == null) {
            this.introns = new ArrayList<Intron>();
        }
        this.introns.add(intron);
        if (this.isStrandPlus()) {
            Collections.sort(this.introns);
        } else {
            Collections.sort(this.introns, Collections.reverseOrder());
        }
    }

    @Override
    public void add(SpliceSite spliceSite) {
        for (Exon ex : this) {
            if (!ex.intersects(spliceSite)) continue;
            ex.add(spliceSite);
        }
        for (Intron intr : this.introns()) {
            if (!intr.intersects(spliceSite)) continue;
            intr.add(spliceSite);
        }
    }

    @Override
    public void add(Utr utr) {
        this.utrs.add(utr);
        this.cds = null;
    }

    boolean addMissingUtrs(Markers missingUtrs, boolean verbose) {
        missingUtrs.sort(false, this.isStrandMinus());
        int minCds = Integer.MAX_VALUE;
        int maxCds = 0;
        for (Cds c : this.cdss) {
            minCds = Math.min(minCds, c.getStart());
            maxCds = Math.max(maxCds, c.getEnd());
        }
        if (verbose) {
            System.out.println("Transcript '" + this.id + "' has missing UTRs. Strand: " + (this.strandMinus ? "-" : "+") + " (minCds: " + minCds + " , maxCds: " + maxCds + "):");
        }
        boolean retVal = false;
        for (Marker mu : missingUtrs) {
            Exon exon = this.queryExon(mu);
            if (exon == null) {
                throw new RuntimeException("Cannot find exon for UTR: " + String.valueOf(mu));
            }
            Utr toAdd = null;
            if (this.isStrandPlus()) {
                if (mu.getEnd() <= minCds) {
                    toAdd = new Utr5prime(exon, mu.getStart(), mu.getEnd(), this.strandMinus, mu.getId());
                } else if (mu.getStart() >= maxCds) {
                    toAdd = new Utr3prime(exon, mu.getStart(), mu.getEnd(), this.strandMinus, mu.getId());
                }
            } else if (mu.getStart() >= maxCds) {
                toAdd = new Utr5prime(exon, mu.getStart(), mu.getEnd(), this.strandMinus, mu.getId());
            } else if (mu.getEnd() <= minCds) {
                toAdd = new Utr3prime(exon, mu.getStart(), mu.getEnd(), this.strandMinus, mu.getId());
            }
            if (toAdd == null) continue;
            this.add(toAdd);
            if (verbose) {
                Log.info("\tAdding " + String.valueOf(toAdd));
            }
            retVal = true;
        }
        return retVal;
    }

    public boolean adjust() {
        boolean newStrandMinus;
        boolean changed = false;
        int strandSumTr = 0;
        int newStart = Integer.MAX_VALUE;
        int newEnd = Integer.MIN_VALUE;
        int countStrandPlus = 0;
        int countStrandMinus = 0;
        for (Exon exon : this.sortedStrand()) {
            newStart = Math.min(newStart, exon.getStart());
            newEnd = Math.max(newEnd, exon.getEnd());
            if (exon.isStrandPlus()) {
                ++countStrandPlus;
                continue;
            }
            ++countStrandMinus;
        }
        for (Utr utr : this.getUtrs()) {
            newStart = Math.min(newStart, utr.getStart());
            newEnd = Math.max(newEnd, utr.getEnd());
        }
        strandSumTr = countStrandPlus - countStrandMinus;
        boolean bl = newStrandMinus = strandSumTr < 0;
        if (countStrandPlus > 0 && countStrandMinus > 0) {
            Log.debug("Transcript '" + this.id + "' has " + countStrandPlus + " exons on the plus and " + countStrandMinus + " exons on the minus strand! This should never happen!");
        }
        if (this.strandMinus != newStrandMinus) {
            changed = true;
            this.setStrandMinus(newStrandMinus);
        }
        if (newStart < Integer.MAX_VALUE && newEnd > Integer.MIN_VALUE) {
            if (this.start != newStart) {
                this.setStart(newStart);
                changed = true;
            }
            if (this.end != newEnd) {
                this.setEnd(newEnd);
                changed = true;
            }
        }
        return changed;
    }

    @Override
    public Transcript apply(Variant variant) {
        if (!this.shouldApply(variant)) {
            return this;
        }
        Transcript newTr = (Transcript)super.apply(variant);
        if (newTr == null) {
            return null;
        }
        for (Utr utr : this.utrs) {
            Utr newUtr = (Utr)utr.apply(variant);
            if (newUtr == null) continue;
            Exon newExon = newTr.findExon(newUtr);
            if (newExon != null) {
                newUtr.setParent(newExon);
                newTr.utrs.add(newUtr);
                continue;
            }
            if (!Config.get().isDebug()) continue;
            Log.debug("WARNING: applying variant: Could not find 'new' parent exon for 'new' UTR\n\t\tVariant           : " + String.valueOf(variant) + "\n\n\t\tUTR        (ori) :" + String.valueOf(utr) + "\n\n\t\tTranscript (ori) :" + String.valueOf(this) + "\n\n\t\tUTR        (new) :" + String.valueOf(newUtr) + "\n\n\t\tTranscript (new) :" + String.valueOf(newTr));
        }
        newTr.rankExons();
        newTr.createUpDownStream(this.upDownLength);
        newTr.introns();
        newTr.createSpliceSites(this.spliceSiteSize, this.spliceRegionExonSize, this.spliceRegionIntronMin, this.spliceRegionIntronMax);
        return newTr;
    }

    public String baseAt(int pos) {
        this.calcCdsStartEnd();
        Exon ex = this.findExon(pos);
        if (ex == null) {
            return null;
        }
        return ex.basesAt(pos - ex.getStart(), 1);
    }

    public synchronized int baseNumber2MRnaPos(int pos) {
        int count = 0;
        for (Exon eint : this.sortedStrand()) {
            if (eint.intersects(pos)) {
                int dist = 0;
                dist = this.isStrandPlus() ? pos - eint.getStart() : eint.getEnd() - pos;
                if (dist < 0) {
                    throw new RuntimeException("Negative distance for position " + pos + ". This should never happen!\n" + String.valueOf(this));
                }
                return count + dist;
            }
            count += eint.size();
        }
        return -1;
    }

    public synchronized int baseNumberCds(int pos, boolean usePrevBaseIntron) {
        if (!this.intersects(pos)) {
            return -1;
        }
        if (this.isUtr(pos)) {
            return -1;
        }
        this.calcCdsStartEnd();
        int firstCdsBaseInExon = 0;
        for (Exon eint : this.sortedStrand()) {
            if (eint.intersects(pos)) {
                int cdsBaseInExon = this.isStrandPlus() ? pos - Math.max(eint.getStart(), this.cdsStart) : Math.min(eint.getEnd(), this.cdsStart) - pos;
                cdsBaseInExon = Math.max(0, cdsBaseInExon);
                return firstCdsBaseInExon + cdsBaseInExon;
            }
            if (this.isStrandPlus() && pos < eint.getStart() || this.isStrandMinus() && pos > eint.getEnd()) {
                return firstCdsBaseInExon - (usePrevBaseIntron ? 1 : 0);
            }
            if (this.isStrandPlus()) {
                firstCdsBaseInExon += Math.max(0, eint.getEnd() - Math.max(eint.getStart(), this.cdsStart) + 1);
                continue;
            }
            firstCdsBaseInExon += Math.max(0, Math.min(this.cdsStart, eint.getEnd()) - eint.getStart() + 1);
        }
        return firstCdsBaseInExon - 1;
    }

    public String baseNumberCds2Codon(int cdsBaseNumber) {
        int codonNum = cdsBaseNumber / 3;
        int min = codonNum * 3;
        int max = codonNum * 3 + 3;
        if (min >= 0 && max <= this.cds().length()) {
            return this.cds().substring(min, max).toUpperCase();
        }
        return null;
    }

    public synchronized int[] baseNumberCds2Pos() {
        if (this.cds2pos != null) {
            return this.cds2pos;
        }
        this.calcCdsStartEnd();
        this.cds2pos = new int[this.cds().length()];
        for (int i2 = 0; i2 < this.cds2pos.length; ++i2) {
            this.cds2pos[i2] = -1;
        }
        int cdsMin = Math.min(this.cdsStart, this.cdsEnd);
        int cdsMax = Math.max(this.cdsStart, this.cdsEnd);
        int cdsBaseNum = 0;
        for (Exon exon : this.sortedStrand()) {
            int min = this.isStrandPlus() ? exon.getStart() : exon.getEnd();
            int step = this.isStrandPlus() ? 1 : -1;
            int pos = min;
            while (exon.intersects(pos) && cdsBaseNum < this.cds2pos.length) {
                if (cdsMin <= pos && pos <= cdsMax) {
                    this.cds2pos[cdsBaseNum++] = pos;
                }
                pos += step;
            }
        }
        return this.cds2pos;
    }

    public int baseNumberCds2Pos(int cdsBaseNum) {
        if (this.cds2pos == null) {
            this.baseNumberCds2Pos();
        }
        if (cdsBaseNum < 0 || cdsBaseNum >= this.cds2pos.length) {
            return -1;
        }
        return this.cds2pos[cdsBaseNum];
    }

    synchronized void calcCdsStartEnd() {
        if (this.cdsStart < 0 && this.cdsEnd < 0) {
            if (this.utrs.isEmpty()) {
                this.cdsStart = this.isStrandPlus() ? this.end : this.start;
                this.cdsEnd = this.isStrandPlus() ? this.start : this.end;
                for (Exon ex : this) {
                    if (this.isStrandPlus()) {
                        this.cdsStart = Math.min(this.cdsStart, ex.getStart());
                        this.cdsEnd = Math.max(this.cdsEnd, ex.getEnd());
                        continue;
                    }
                    this.cdsStart = Math.max(this.cdsStart, ex.getEnd());
                    this.cdsEnd = Math.min(this.cdsEnd, ex.getStart());
                }
            } else {
                this.cdsStart = this.isStrandPlus() ? this.start : this.end;
                this.cdsEnd = this.isStrandPlus() ? this.end : this.start;
                int cdsStartNotExon = this.cdsStart;
                for (Utr utr : this.utrs) {
                    if (utr instanceof Utr5prime) {
                        if (this.isStrandPlus()) {
                            this.cdsStart = Math.max(this.cdsStart, utr.getEnd() + 1);
                            continue;
                        }
                        this.cdsStart = Math.min(this.cdsStart, utr.getStart() - 1);
                        continue;
                    }
                    if (!(utr instanceof Utr3prime)) continue;
                    if (this.isStrandPlus()) {
                        this.cdsEnd = Math.min(this.cdsEnd, utr.getStart() - 1);
                        continue;
                    }
                    this.cdsEnd = Math.max(this.cdsEnd, utr.getEnd() + 1);
                }
                if (this.isStrandPlus()) {
                    this.cdsStart = this.firstExonPositionAfter(this.cdsStart);
                    this.cdsEnd = this.lastExonPositionBefore(this.cdsEnd);
                } else {
                    this.cdsStart = this.lastExonPositionBefore(this.cdsStart);
                    this.cdsEnd = this.firstExonPositionAfter(this.cdsEnd);
                }
                if (this.cdsStart < 0 || this.cdsEnd < 0) {
                    this.cdsStart = this.cdsEnd = cdsStartNotExon;
                }
            }
        }
    }

    public synchronized String cds() {
        if (this.cds != null) {
            return this.cds;
        }
        List exons = this.sortedStrand();
        StringBuilder sequence = new StringBuilder();
        int utr5len = 0;
        int utr3len = 0;
        for (Utr utr : this.get5primeUtrs()) {
            utr5len += utr.size();
        }
        boolean missingSequence = false;
        for (Exon exon : exons) {
            missingSequence |= !exon.hasSequence();
            sequence.append(exon.getSequence());
        }
        if (missingSequence) {
            this.cds = "";
        } else {
            for (Utr utr : this.get3primeUtrs()) {
                utr3len += utr.size();
            }
            int n = sequence.length() - utr3len;
            this.cds = utr5len > n ? "" : sequence.substring(utr5len, n);
        }
        return this.cds;
    }

    public Marker cdsMarker() {
        return this.isStrandPlus() ? new Marker(this, this.getCdsStart(), this.getCdsEnd()) : new Marker(this, this.getCdsEnd(), this.getCdsStart());
    }

    @Override
    public Transcript cloneShallow() {
        Transcript clone = (Transcript)super.cloneShallow();
        clone.proteinCoding = this.proteinCoding;
        clone.canonical = this.canonical;
        clone.bioType = this.bioType;
        clone.aaCheck = this.aaCheck;
        clone.dnaCheck = this.dnaCheck;
        clone.corrected = this.corrected;
        clone.ribosomalSlippage = this.ribosomalSlippage;
        return clone;
    }

    public int[] codonNumber2Pos(int codonNum) {
        int idxStart;
        if (this.cds2pos == null) {
            this.baseNumberCds2Pos();
        }
        int[] codon = new int[3];
        int step = this.isStrandPlus() ? 1 : -1;
        int i2 = idxStart = this.isStrandPlus() ? 0 : 2;
        for (int j = 3 * codonNum; i2 < codon.length && i2 >= 0 && j < this.cds2pos.length; i2 += step, ++j) {
            codon[i2] = this.cds2pos[j];
        }
        return codon;
    }

    public boolean collapseZeroGap() {
        if (this.ribosomalSlippage) {
            return false;
        }
        boolean ret = false;
        this.introns = null;
        Markers markers = new Markers();
        markers.addAll(this.subIntervals());
        Map<Marker, Marker> collapse = MarkerUtil.collapseZeroGap(markers);
        for (Marker marker : collapse.keySet()) {
            Exon collapsedExon = (Exon)collapse.get(marker);
            if (marker.size() == collapsedExon.size() && marker.getStart() == collapsedExon.getStart() && marker.getEnd() == collapsedExon.getEnd()) continue;
            ret = true;
            if (Config.get().isDebug()) {
                System.err.println("\t\t\tTranscript " + this.getId() + ": Collapsing exon " + marker.getId() + "\t[ " + marker.getStart() + " - " + marker.getEnd() + " ]\t=>\t[ " + collapsedExon.getStart() + " - " + collapsedExon.getEnd() + " ]");
            }
            this.remove((Exon)marker);
            if (!this.containsId(collapsedExon.getId())) {
                this.add(collapsedExon);
            }
            for (Marker marker2 : this.getUtrs()) {
                Utr utr = (Utr)marker2;
                if (utr.getParent() != marker) continue;
                utr.setParent(collapsedExon);
            }
        }
        collapse = MarkerUtil.collapseZeroGap(new Markers(this.cdss));
        this.cdss = new ArrayList<Cds>();
        Markers uniqCollapsedCds = new Markers(collapse.values()).unique();
        for (Marker cds : uniqCollapsedCds) {
            this.cdss.add((Cds)cds);
        }
        collapse = MarkerUtil.collapseZeroGap(new Markers(this.utrs));
        Markers markers2 = new Markers(collapse.values()).unique();
        this.utrs = new ArrayList<Utr>();
        for (Marker utr : markers2) {
            this.utrs.add((Utr)utr);
        }
        return ret;
    }

    public double cpgExonBias() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.oe(this);
    }

    public int cpgExons() {
        ObservedOverExpectedCpG oe = new ObservedOverExpectedCpG();
        return oe.observed(this);
    }

    public void createSpliceSites(int spliceSiteSize, int spliceRegionExonSize, int spliceRegionIntronMin, int spliceRegionIntronMax) {
        List<Intron> introns;
        this.spliceSiteSize = spliceSiteSize;
        this.spliceRegionExonSize = spliceRegionExonSize;
        this.spliceRegionIntronMin = spliceRegionIntronMin;
        this.spliceRegionIntronMax = spliceRegionIntronMax;
        ArrayList exons = (ArrayList)this.sortedStrand();
        if (exons.size() > 0) {
            for (int i2 = 0; i2 < exons.size(); ++i2) {
                Exon exon = (Exon)exons.get(i2);
                if (i2 > 0) {
                    exon.createSpliceSiteRegionStart(spliceRegionExonSize);
                }
                if (i2 < exon.size() - 1) {
                    exon.createSpliceSiteRegionEnd(spliceRegionExonSize);
                }
                int rank = i2 + 1;
                if (exon.getRank() == rank) continue;
                String msg = "Rank numbers do not march: " + rank + " != " + exon.getRank() + "\n\tTranscript: " + String.valueOf(this);
                throw new RuntimeException(msg);
            }
        }
        if ((introns = this.introns()) != null) {
            for (int i3 = 0; i3 < introns.size(); ++i3) {
                Intron intron = introns.get(i3);
                intron.createSpliceSiteAcceptor(spliceSiteSize);
                intron.createSpliceSiteDonor(spliceSiteSize);
                intron.createSpliceSiteRegionStart(spliceRegionIntronMin, spliceRegionIntronMax);
                intron.createSpliceSiteRegionEnd(spliceRegionIntronMin, spliceRegionIntronMax);
            }
        }
    }

    public void createUpDownStream(int upDownLength) {
        this.upDownLength = upDownLength;
        Chromosome chr = this.getChromosome();
        int chrMin = chr.getStart();
        int chrMax = chr.getEnd();
        int beforeStart = Math.max(this.start - upDownLength, chrMin);
        int beforeEnd = Math.max(this.start - 1, chrMin);
        int afterStart = Math.min(this.end + 1, chrMax);
        int afterEnd = Math.min(this.end + upDownLength, chrMax);
        if (this.isStrandPlus()) {
            if (beforeStart < beforeEnd) {
                this.upstream = new Upstream(this, beforeStart, beforeEnd, false, this.id);
            }
            if (afterStart < afterEnd) {
                this.downstream = new Downstream(this, afterStart, afterEnd, false, this.id);
            }
        } else {
            if (afterStart < afterEnd) {
                this.upstream = new Upstream(this, afterStart, afterEnd, false, this.id);
            }
            if (beforeStart < beforeEnd) {
                this.downstream = new Downstream(this, beforeStart, beforeEnd, false, this.id);
            }
        }
    }

    public boolean deleteRedundant() {
        boolean ret = false;
        this.introns = null;
        Map<Marker, Marker> includedIn = MarkerUtil.redundant(this.subIntervals());
        for (Marker exon : includedIn.keySet()) {
            ret = true;
            this.remove((Exon)exon);
            for (Marker marker : this.getUtrs()) {
                Utr utr = (Utr)marker;
                if (utr.getParent() != exon) continue;
                utr.setParent(includedIn.get(exon));
            }
        }
        includedIn = MarkerUtil.redundant(this.cdss);
        for (Marker cds : includedIn.keySet()) {
            this.cdss.remove(cds);
        }
        includedIn = MarkerUtil.redundant(this.utrs);
        for (Marker utr : includedIn.keySet()) {
            this.utrs.remove(utr);
        }
        return ret;
    }

    public Cds findCds(Exon exon) {
        for (Cds cds : this.cdss) {
            if (!exon.includes(cds)) continue;
            return cds;
        }
        return null;
    }

    public Exon findExon(int pos) {
        for (Exon exon : this) {
            if (!exon.intersects(pos)) continue;
            return exon;
        }
        return null;
    }

    public Exon findExon(Marker marker) {
        for (Exon exon : this) {
            if (!exon.intersects(marker)) continue;
            return exon;
        }
        return null;
    }

    public Intron findIntron(int pos) {
        for (Intron intron : this.introns()) {
            if (!intron.intersects(pos)) continue;
            return intron;
        }
        return null;
    }

    public Utr findUtr(int pos) {
        for (Utr utr : this.utrs) {
            if (!utr.intersects(pos)) continue;
            return utr;
        }
        return null;
    }

    public List<Utr> findUtrs(Marker marker) {
        LinkedList<Utr> utrs = new LinkedList<Utr>();
        for (Utr utr : utrs) {
            if (!utr.intersects(marker)) continue;
            utrs.add(utr);
        }
        return utrs.isEmpty() ? null : utrs;
    }

    int firstExonPositionAfter(int pos) {
        for (Exon ex : this.sorted()) {
            if (pos <= ex.getStart()) {
                return ex.getStart();
            }
            if (pos > ex.getEnd()) continue;
            return pos;
        }
        Log.warning(ErrorWarningType.WARNING_EXON_NOT_FOUND, "WARNING: Cannot find first exonic position after " + pos + " for transcript '" + this.id + "'");
        return -1;
    }

    public synchronized boolean frameCorrection() {
        boolean changed;
        this.frameFromCds();
        boolean changedFirst = this.frameCorrectionFirstCodingExon();
        boolean changedNonFirst = this.frameCorrectionNonFirstCodingExon();
        boolean bl = changed = changedFirst || changedNonFirst;
        if (changed) {
            this.resetCache();
            this.corrected = true;
        }
        return changed;
    }

    synchronized boolean frameCorrectionFirstCodingExon() {
        List exons = this.sortedStrand();
        if (exons == null || exons.isEmpty()) {
            return false;
        }
        Exon exonFirst = this.getFirstCodingExon();
        if (exonFirst == null) {
            return false;
        }
        if (exonFirst.getFrame() <= 0) {
            return false;
        }
        Utr5prime utr5 = null;
        int frame = exonFirst.getFrame();
        if (this.isStrandPlus()) {
            int end = exonFirst.getStart() + (frame - 1);
            utr5 = new Utr5prime(exonFirst, exonFirst.getStart(), end, this.isStrandMinus(), exonFirst.getId());
        } else {
            int start = exonFirst.getEnd() - (frame - 1);
            utr5 = new Utr5prime(exonFirst, start, exonFirst.getEnd(), this.isStrandMinus(), exonFirst.getId());
        }
        if (Config.get().isDebug()) {
            Log.debug("Frame correction for first coding exon: Added 5'UTR to compensate frame=" + frame + ", new UTR: " + String.valueOf(utr5));
        }
        exonFirst.setFrame(0);
        Cds cds = this.findCds(exonFirst);
        if (cds != null) {
            cds.frameCorrection(cds.getFrame());
        }
        this.add(utr5);
        return true;
    }

    synchronized boolean frameCorrectionNonFirstCodingExon() {
        boolean corrected = false;
        List exons = this.sortedStrand();
        StringBuilder sequence = new StringBuilder();
        for (Exon exon : exons) {
            if (exon.hasSequence()) continue;
            return false;
        }
        int utr5Start = Integer.MAX_VALUE;
        int utr5End = -1;
        for (Utr utr : this.get5primeUtrs()) {
            utr.size();
            utr5Start = Math.min(utr5Start, utr.getStart());
            utr5End = Math.max(utr5End, utr.getEnd());
        }
        Marker utr5 = utr5End >= 0 ? new Marker(this, utr5Start, utr5End, this.strandMinus, "") : null;
        for (Exon exon : exons) {
            String seq = "";
            int utrOverlap = 0;
            boolean utrIncluded = false;
            if (utr5 != null && utr5.includes(exon)) {
                seq = "";
                utrIncluded = true;
            } else {
                seq = exon.getSequence();
                if (utr5 != null && utr5.intersects(exon) && (utrOverlap = utr5.intersectSize(exon)) > 0) {
                    seq = utrOverlap < seq.length() ? seq.substring(utrOverlap) : "";
                }
            }
            if (exon.getFrame() >= 0) {
                if (utrIncluded) {
                    if (exon.getFrame() >= 0) {
                        exon.setFrame(-1);
                    }
                } else {
                    int frameReal = FrameType.GFF.frameFromLength(sequence.length());
                    if (frameReal != exon.getFrame()) {
                        if (utrOverlap > 0) {
                            throw new RuntimeException("Fatal Error: First exon needs correction: This should never happen!\n\tThis method is supposed to be called AFTER method\n\tSnpEffPredictorFactory.frameCorrectionFirstCodingExon(), which\n\tshould have taken care of this problem.\n\t" + String.valueOf(this));
                        }
                        if (Config.get().isDebug()) {
                            Log.debug("Frame correction: Transcript '" + this.getId() + "' " + this.toStr() + ", exon rank: " + exon.getRank() + ", expected frame: " + frameReal + ", exon frame: " + exon.getFrame() + ", sequence len: " + sequence.length());
                        }
                        Cds cdsToCorrect = this.findCds(exon);
                        boolean ok = true;
                        while (ok && frameReal != exon.getFrame()) {
                            ok &= exon.frameCorrection(1);
                            if (cdsToCorrect != null) {
                                cdsToCorrect.frameCorrection(1);
                            }
                            corrected = true;
                        }
                        seq = exon.getSequence();
                    }
                }
            }
            sequence.append(seq);
        }
        return corrected;
    }

    void frameFromCds() {
        block0: for (Exon ex : this) {
            if (ex.getFrame() >= 0) continue;
            for (Cds cds : this.getCds()) {
                if (this.isStrandPlus() && ex.getStart() == cds.getStart()) {
                    ex.setFrame(cds.getFrame());
                    continue block0;
                }
                if (!this.isStrandMinus() || ex.getEnd() != cds.getEnd()) continue;
                ex.setFrame(cds.getFrame());
                continue block0;
            }
        }
    }

    public List<Utr3prime> get3primeUtrs() {
        ArrayList<Utr3prime> list = new ArrayList<Utr3prime>();
        for (Utr utr : this.utrs) {
            if (!(utr instanceof Utr3prime)) continue;
            list.add((Utr3prime)utr);
        }
        return list;
    }

    public List<Utr3prime> get3primeUtrsSorted() {
        List<Utr3prime> list = this.get3primeUtrs();
        Collections.sort(list);
        return list;
    }

    public List<Utr5prime> get5primeUtrs() {
        ArrayList<Utr5prime> list = new ArrayList<Utr5prime>();
        for (Utr utr : this.utrs) {
            if (!(utr instanceof Utr5prime)) continue;
            list.add((Utr5prime)utr);
        }
        return list;
    }

    public List<Utr5prime> get5primeUtrsSorted() {
        List<Utr5prime> list = this.get5primeUtrs();
        Collections.sort(list);
        return list;
    }

    public BioType getBioType() {
        return this.bioType;
    }

    public List<Cds> getCds() {
        return this.cdss;
    }

    public int getCdsEnd() {
        this.calcCdsStartEnd();
        return this.cdsEnd;
    }

    public int getCdsStart() {
        this.calcCdsStartEnd();
        return this.cdsStart;
    }

    public Downstream getDownstream() {
        return this.downstream;
    }

    public Collection<Exon> getExons() {
        return this.subIntervals();
    }

    public synchronized Exon getFirstCodingExon() {
        if (this.firstCodingExon == null) {
            long cstart = this.getCdsStart();
            for (Exon exon : this.sortedStrand()) {
                if (!exon.intersects(cstart)) continue;
                this.firstCodingExon = exon;
            }
            if (this.firstCodingExon == null) {
                Gene g = (Gene)this.getParent();
                Log.warning(ErrorWarningType.WARNING_EXON_NOT_FOUND, "Cannot find first coding exon for transcript '" + this.getId() + "', gene name '" + (g != null ? g.getGeneName() : "") + "', gene ID '" + (g != null ? g.getId() : "") + "'");
            }
        }
        return this.firstCodingExon;
    }

    public Gene getGene() {
        return (Gene)this.findParent(Gene.class);
    }

    public boolean hasProteinId() {
        return this.proteinId != null && !this.proteinId.isEmpty();
    }

    public String getProteinId() {
        return this.proteinId;
    }

    public String[] getTags() {
        if (!this.hasTags()) {
            return new String[0];
        }
        return this.tags.split(";");
    }

    public TranscriptSupportLevel getTranscriptSupportLevel() {
        return this.transcriptSupportLevel;
    }

    public Marker getTss() {
        this.calcCdsStartEnd();
        Marker tss = new Marker(this, this.start + (this.isStrandPlus() ? 0 : -1), this.start + (this.isStrandPlus() ? 1 : 0), false, "TSS_" + this.id);
        return tss;
    }

    public Upstream getUpstream() {
        return this.upstream;
    }

    public List<Utr> getUtrs() {
        return this.utrs;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public boolean hasCds() {
        return this.cdss != null && !this.cdss.isEmpty();
    }

    public boolean hasError() {
        return this.isErrorProteinLength() || this.isErrorStartCodon() || this.isErrorStopCodonsInCds();
    }

    public boolean hasErrorOrWarning() {
        return this.hasError() || this.hasWarning();
    }

    public boolean hasTag(String tag) {
        if (!this.hasTags()) {
            return false;
        }
        for (String t : this.getTags()) {
            if (!t.equals(tag)) continue;
            return true;
        }
        return false;
    }

    public boolean hasTags() {
        return this.tags != null && !this.tags.isEmpty();
    }

    public boolean hasTranscriptSupportLevelInfo() {
        return this.transcriptSupportLevel != null && this.transcriptSupportLevel != TranscriptSupportLevel.TSL_NA;
    }

    public boolean hasWarning() {
        return this.isWarningStopCodon();
    }

    public synchronized List<Intron> introns() {
        if (this.introns == null) {
            this.introns = new ArrayList<Intron>();
            Exon exBefore = null;
            for (Exon ex : this.sortedStrand()) {
                if (exBefore != null) {
                    int end;
                    int start;
                    int rank = this.introns.size() + 1;
                    if (this.isStrandPlus()) {
                        start = exBefore.getEnd() + 1;
                        end = ex.getStart() - 1;
                    } else {
                        start = ex.getEnd() + 1;
                        end = exBefore.getStart() - 1;
                    }
                    int size = end - start + 1;
                    if (size > 0) {
                        Intron intron = new Intron(this, start, end, this.strandMinus, this.id + "_intron_" + rank, exBefore, ex);
                        intron.setRank(rank);
                        this.introns.add(intron);
                    }
                }
                exBefore = ex;
            }
        }
        return this.introns;
    }

    public boolean isAaCheck() {
        return this.aaCheck;
    }

    public void setAaCheck(boolean aaCheck) {
        this.aaCheck = aaCheck;
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    boolean isCds(Variant variant) {
        this.calcCdsStartEnd();
        int cs = this.cdsStart;
        int ce = this.cdsEnd;
        if (this.isStrandMinus()) {
            cs = this.cdsEnd;
            ce = this.cdsStart;
        }
        return variant.getEnd() >= cs && variant.getStart() <= ce;
    }

    public boolean isChecked() {
        return this.aaCheck || this.dnaCheck;
    }

    public boolean isCorrected() {
        return this.corrected;
    }

    public boolean isDnaCheck() {
        return this.dnaCheck;
    }

    public void setDnaCheck(boolean dnaCheck) {
        this.dnaCheck = dnaCheck;
    }

    public boolean isDownstream(int pos) {
        return this.downstream != null && this.downstream.intersects(pos);
    }

    public boolean isErrorProteinLength() {
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding()) {
            return false;
        }
        return this.cds().length() % 3 != 0;
    }

    public boolean isErrorStartCodon() {
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding()) {
            return false;
        }
        String cds = this.cds();
        if (cds.length() < 3) {
            return true;
        }
        String codon = cds.substring(0, 3);
        return !this.codonTable().isStart(codon);
    }

    public boolean isErrorStopCodonsInCds() {
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding()) {
            return false;
        }
        String prot = this.protein();
        if (prot == null) {
            return false;
        }
        char[] bases = prot.toCharArray();
        int max = bases.length - 1;
        int countErrs = 0;
        for (int i2 = 0; i2 < max; ++i2) {
            if (bases[i2] != '*' || ++countErrs <= 1) continue;
            return true;
        }
        return false;
    }

    public boolean isIntron(int pos) {
        return this.findIntron(pos) != null;
    }

    public boolean isProteinCoding() {
        return this.proteinCoding;
    }

    public boolean isRibosomalSlippage() {
        return this.ribosomalSlippage;
    }

    public void setRibosomalSlippage(boolean ribosomalSlippage) {
        this.ribosomalSlippage = ribosomalSlippage;
    }

    public boolean isUpstream(int pos) {
        return this.upstream != null && this.upstream.intersects(pos);
    }

    public boolean isUtr(int pos) {
        return this.findUtr(pos) != null;
    }

    public boolean isUtr(Marker marker) {
        return this.findUtrs(marker) != null;
    }

    public boolean isUtr3(int pos) {
        Utr utr = this.findUtr(pos);
        return utr != null && utr instanceof Utr3prime;
    }

    public boolean isUtr5(int pos) {
        Utr utr = this.findUtr(pos);
        return utr != null && utr instanceof Utr5prime;
    }

    public boolean isWarningStopCodon() {
        if (!Config.get().isTreatAllAsProteinCoding() && !this.isProteinCoding()) {
            return false;
        }
        String cds = this.cds();
        if (cds.length() < 3) {
            return true;
        }
        String codon = cds.substring(cds.length() - 3);
        return !this.codonTable().isStop(codon);
    }

    int lastExonPositionBefore(int pos) {
        int last = -1;
        for (Exon ex : this.sorted()) {
            if (pos < ex.getStart()) {
                if (last < 0) {
                    System.err.println("WARNING: Cannot find last exonic position before " + pos + " for transcript '" + this.id + "'");
                    return -1;
                }
                return last;
            }
            if (pos <= ex.getEnd()) {
                return pos;
            }
            last = ex.getEnd();
        }
        if (last < 0) {
            System.err.println("WARNING: Cannot find last exonic position before " + pos + " for transcript '" + this.id + "'");
        }
        return pos;
    }

    @Override
    public Markers markers() {
        Markers markers = new Markers();
        markers.addAll(this.subIntervals());
        markers.addAll((Collection<? extends Marker>)this.utrs);
        markers.addAll((Collection<? extends Marker>)this.cdss);
        markers.add(this.upstream);
        markers.add(this.downstream);
        markers.addAll((Collection<? extends Marker>)this.introns());
        return markers;
    }

    public synchronized String mRna() {
        if (this.mRna != null) {
            return this.mRna;
        }
        List exons = this.sortedStrand();
        StringBuilder sequence = new StringBuilder();
        for (Exon ex : exons) {
            sequence.append(ex.getSequence());
        }
        this.mRna = sequence.toString();
        return this.mRna;
    }

    public String protein() {
        if (this.protein == null) {
            this.protein = (Config.get() == null || !Config.get().isTreatAllAsProteinCoding()) && !this.isProteinCoding() ? "" : this.codonTable().aa(this.cds(), true);
        }
        return this.protein;
    }

    @Override
    public Markers query(Marker marker) {
        HashSet<Marker> results = new HashSet<Marker>();
        for (Exon ex : this) {
            if (!ex.intersects(marker)) continue;
            results.add(ex);
            for (Marker ee : ex.query(marker)) {
                results.add(ee);
            }
        }
        for (Utr u : this.utrs) {
            if (!u.intersects(marker)) continue;
            results.add(u);
        }
        for (Cds m : this.cdss) {
            if (!m.intersects(marker)) continue;
            results.add(m);
        }
        for (Intron intr : this.introns()) {
            if (!intr.intersects(marker)) continue;
            results.add(intr);
            for (Marker ee : intr.query(marker)) {
                results.add(ee);
            }
        }
        Markers markers = new Markers();
        markers.addAll((Collection<? extends Marker>)results);
        return markers;
    }

    public Exon queryExon(Marker interval) {
        for (Exon ei : this) {
            if (!ei.intersects(interval)) continue;
            return ei;
        }
        return null;
    }

    public boolean rankExons() {
        boolean changed = false;
        int rank = 1;
        for (Exon exon : this.sortedStrand()) {
            if (rank != exon.getRank()) {
                exon.setRank(rank);
                changed = true;
            }
            ++rank;
        }
        return changed;
    }

    @Override
    public void reset() {
        super.reset();
        this.utrs = new ArrayList<Utr>();
        this.cdss = new ArrayList<Cds>();
        this.introns = null;
        this.upstream = null;
        this.downstream = null;
        this.resetCache();
    }

    public void resetCache() {
        this.cdsStart = -1;
        this.cdsEnd = -1;
        this.firstCodingExon = null;
        this.cds = null;
        this.cds2pos = null;
        this.aa2pos = null;
        this.mRna = null;
        this.protein = null;
    }

    public void resetExons() {
        super.reset();
        this.resetCache();
    }

    public ErrorWarningType sanityCheck(Variant variant) {
        if (this.isErrorStopCodonsInCds()) {
            return ErrorWarningType.WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS;
        }
        if (this.isErrorProteinLength()) {
            return ErrorWarningType.WARNING_TRANSCRIPT_INCOMPLETE;
        }
        if (this.isErrorStartCodon()) {
            return ErrorWarningType.WARNING_TRANSCRIPT_NO_START_CODON;
        }
        if (this.isWarningStopCodon()) {
            return ErrorWarningType.WARNING_TRANSCRIPT_NO_STOP_CODON;
        }
        return null;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.bioType = BioType.parse(markerSerializer.getNextField());
        this.proteinCoding = markerSerializer.getNextFieldBoolean();
        this.dnaCheck = markerSerializer.getNextFieldBoolean();
        this.aaCheck = markerSerializer.getNextFieldBoolean();
        this.corrected = markerSerializer.getNextFieldBoolean();
        this.ribosomalSlippage = markerSerializer.getNextFieldBoolean();
        this.transcriptSupportLevel = TranscriptSupportLevel.parse(markerSerializer.getNextField());
        this.version = markerSerializer.getNextField();
        this.upstream = (Upstream)markerSerializer.getNextFieldMarker();
        this.downstream = (Downstream)markerSerializer.getNextFieldMarker();
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.utrs.add((Utr)m);
        }
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.cdss.add((Cds)m);
        }
        this.tags = markerSerializer.getNextField();
        this.proteinId = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + String.valueOf((Object)this.bioType) + "\t" + this.proteinCoding + "\t" + this.dnaCheck + "\t" + this.aaCheck + "\t" + this.corrected + "\t" + this.ribosomalSlippage + "\t" + (this.transcriptSupportLevel == null ? "" : this.transcriptSupportLevel.toString()) + "\t" + this.version + "\t" + markerSerializer.save(this.upstream) + "\t" + markerSerializer.save(this.downstream) + "\t" + markerSerializer.save(this.utrs) + "\t" + markerSerializer.save(this.cdss) + "\t" + this.tags + "\t" + this.proteinId;
    }

    public void setBioType(BioType bioType) {
        this.bioType = bioType;
    }

    public void setCanonical(boolean canonical) {
        this.canonical = canonical;
    }

    public void setProteinCoding(boolean proteinCoding) {
        this.proteinCoding = proteinCoding;
    }

    public void setProteinId(String proteinId) {
        this.proteinId = proteinId;
    }

    public void setTags(String tags) {
        this.tags = tags;
    }

    public void setTranscriptSupportLevel(TranscriptSupportLevel transcriptSupportLevel) {
        this.transcriptSupportLevel = transcriptSupportLevel;
    }

    public void sortCds() {
        Collections.sort(this.cdss);
        this.resetCache();
    }

    public List<SpliceSite> spliceSites() {
        ArrayList<SpliceSite> sslist = new ArrayList<SpliceSite>();
        for (Exon ex : this) {
            sslist.addAll(ex.getSpliceSites());
        }
        for (Intron intr : this.introns()) {
            sslist.addAll(intr.getSpliceSites());
        }
        return sslist;
    }

    @Override
    public String toString() {
        return this.toString(false);
    }

    public String toString(boolean full) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + ":" + this.start + "-" + this.end);
        sb.append(", strand: " + (this.isStrandPlus() ? "+" : "-"));
        if (this.id != null && this.id.length() > 0) {
            sb.append(", id:" + this.id);
        }
        if (this.bioType != null && this.bioType != null) {
            sb.append(", bioType:" + String.valueOf((Object)this.bioType));
        }
        if (this.isProteinCoding()) {
            sb.append(", Protein");
        }
        if (this.isAaCheck()) {
            sb.append(", AA check");
        }
        if (this.isDnaCheck()) {
            sb.append(", DNA check");
        }
        if (this.hasTags()) {
            sb.append(", tags: '" + this.tags + "'");
        }
        if (this.hasProteinId()) {
            sb.append(", protein id: " + this.getProteinId());
        }
        if (this.numChilds() > 0) {
            sb.append("\n");
            for (Utr utr : this.get5primeUtrsSorted()) {
                sb.append("\t\t5'UTR   :\t" + String.valueOf(utr) + "\n");
            }
            sb.append("\t\tExons:\n");
            for (Exon exon : this.sorted()) {
                sb.append("\t\t" + String.valueOf(exon) + "\n");
            }
            for (Utr utr : this.get3primeUtrsSorted()) {
                sb.append("\t\t3'UTR   :\t" + String.valueOf(utr) + "\n");
            }
            if (this.isProteinCoding()) {
                sb.append("\t\tCDS     :\t" + this.cds() + "\n");
                sb.append("\t\tProtein :\t" + this.protein() + "\n");
            }
        }
        if (full) {
            Object warn = "";
            if (this.isErrorStopCodonsInCds()) {
                warn = (String)warn + String.valueOf((Object)ErrorWarningType.WARNING_TRANSCRIPT_MULTIPLE_STOP_CODONS) + " ";
            }
            if (this.isErrorProteinLength()) {
                warn = (String)warn + String.valueOf((Object)ErrorWarningType.WARNING_TRANSCRIPT_INCOMPLETE) + " ";
            }
            if (this.isErrorStartCodon()) {
                warn = (String)warn + String.valueOf((Object)ErrorWarningType.WARNING_TRANSCRIPT_NO_START_CODON) + " ";
            }
            if (this.isWarningStopCodon()) {
                warn = (String)warn + String.valueOf((Object)ErrorWarningType.WARNING_TRANSCRIPT_NO_STOP_CODON) + " ";
            }
            if (!((String)warn).isEmpty()) {
                sb.append("\tWarnings  :" + (String)warn);
            }
            sb.append("\t\tCDS check : " + (this.isDnaCheck() ? "OK" : "Failed (or missing)") + "\n");
            sb.append("\t\tAA check  : " + (this.isAaCheck() ? "OK" : "Failed (or missing)") + "\n");
        }
        return sb.toString();
    }

    public String toStringAsciiArt(boolean full) {
        char[] art = new char[this.size()];
        int i2 = this.start;
        int j = 0;
        while (i2 <= this.end) {
            Exon exon;
            Utr utr = this.findUtr(i2);
            art[j] = utr != null ? (utr.isUtr5prime() ? 53 : 51) : ((exon = this.findExon(i2)) != null ? (exon.isStrandPlus() ? 62 : 60) : 45);
            ++i2;
            ++j;
        }
        if (!full) {
            return new String(art);
        }
        StringBuilder seq = new StringBuilder();
        for (int i3 = this.start; i3 <= this.end; ++i3) {
            Exon exon = this.findExon(i3);
            if (exon != null) {
                String s = exon.getSequence().toLowerCase();
                if (exon.isStrandMinus()) {
                    s = GprSeq.reverseWc(s);
                }
                s = GprSeq.padN(s, exon.size());
                seq.append(s);
                i3 += s.length() - 1;
                continue;
            }
            seq.append('.');
        }
        StringBuilder aa = new StringBuilder();
        StringBuilder frameSb = new StringBuilder();
        StringBuilder pos1sb = new StringBuilder();
        StringBuilder pos10sb = new StringBuilder();
        StringBuilder pos100sb = new StringBuilder();
        StringBuilder pos1000sb = new StringBuilder();
        int pos = this.start;
        if (this.isProteinCoding()) {
            char[] codon = new char[3];
            int step = this.isStrandPlus() ? 1 : -1;
            int frame = 0;
            int j2 = 0;
            for (int i4 = this.isStrandPlus() ? 0 : art.length - 1; i4 >= 0 && i4 < art.length; i4 += step) {
                if (art[i4] == '3' || art[i4] == '5') {
                    aa.append(' ');
                    frameSb.append(' ');
                } else {
                    char b = seq.charAt(i4);
                    if (b == 'a' || b == 'c' || b == 'g' || b == 't') {
                        codon[j2++] = b;
                        if (j2 >= 3) {
                            j2 = 0;
                            String cod = new String(codon);
                            if (this.isStrandMinus()) {
                                cod = GprSeq.wc(cod);
                            }
                            boolean translateStart = aa.length() <= 0;
                            aa.append(" " + this.codonTable().aa(cod, translateStart) + " ");
                        }
                        frameSb.append(frame);
                        frame = (frame + 1) % 3;
                    } else {
                        aa.append(' ');
                        frameSb.append(' ');
                    }
                }
                pos1sb.append(pos % 10);
                if (pos % 10 == 0) {
                    pos10sb.append(pos % 100 / 10);
                } else {
                    pos10sb.append(' ');
                }
                if (pos % 100 == 0) {
                    pos100sb.append(pos % 1000 / 100);
                } else {
                    pos100sb.append(' ');
                }
                if (pos % 1000 == 0) {
                    pos1000sb.append(pos % 10000 / 1000);
                } else {
                    pos1000sb.append(' ');
                }
                ++pos;
            }
        }
        String aaStr = this.isStrandPlus() ? aa.toString() : aa.reverse().toString();
        String frameStr = this.isStrandPlus() ? frameSb.toString() : frameSb.reverse().toString();
        StringBuilder lines = new StringBuilder();
        if (this.isStrandPlus()) {
            lines.append(' ');
        }
        int prev = this.start;
        for (Exon ex : this.sorted()) {
            lines.append(Gpr.repeat(' ', ex.getStart() - prev - 1) + "|");
            prev = ex.getStart();
            lines.append(Gpr.repeat(' ', ex.getEnd() - prev - 1) + "|");
            prev = ex.getEnd();
        }
        StringBuilder coords = new StringBuilder();
        coords.append(String.valueOf(lines) + "\n");
        ArrayList exons = new ArrayList();
        exons.addAll(this.subIntervals());
        Collections.sort(exons, new IntervalComparatorByStart(true));
        for (Exon ex : exons) {
            int n = ex.getEnd();
            int len = n - this.start + 1;
            coords.append(String.valueOf(len > 0 ? lines.subSequence(0, len) : "") + "^" + n + "\n");
            n = ex.getStart();
            len = n - this.start + 1;
            coords.append(String.valueOf(len > 0 ? lines.subSequence(0, len) : "") + "^" + n + "\n");
        }
        return (String)(pos1000sb.toString().trim().isEmpty() ? "" : "\n" + String.valueOf(pos1000sb)) + (String)(pos100sb.toString().trim().isEmpty() ? "" : "\n" + String.valueOf(pos100sb)) + (String)(pos10sb.toString().trim().isEmpty() ? "" : "\n" + String.valueOf(pos10sb)) + "\n" + String.valueOf(pos1sb) + "\n" + String.valueOf(seq) + (String)(this.isProteinCoding() ? "\n" + aaStr + "\n" + frameStr : "") + "\n" + new String(art) + "\n" + String.valueOf(coords);
    }

    public boolean utrFromCds(boolean verbose) {
        if (this.cdss.size() <= 0) {
            return false;
        }
        Markers exons = new Markers();
        Markers minus = new Markers();
        for (Exon e : this) {
            exons.add(e);
        }
        for (Utr uint : this.getUtrs()) {
            minus.add(uint);
        }
        for (Cds cint : this.cdss) {
            minus.add(cint);
        }
        Markers missingUtrs = exons.minus(minus);
        if (!missingUtrs.isEmpty()) {
            return this.addMissingUtrs(missingUtrs, verbose);
        }
        return false;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        boolean mayAffectSeveralExons;
        if (!this.intersects(variant)) {
            return false;
        }
        if (variant.includes(this) && variant.isStructural()) {
            CodonChange codonChange = CodonChange.factory(variant, this, variantEffects);
            codonChange.codonChange();
            return true;
        }
        boolean bl = mayAffectSeveralExons = variant.isStructural() || variant.isMixed() || variant.isMnp();
        if (mayAffectSeveralExons) {
            int countExon = 0;
            for (Exon ex : this) {
                if (!ex.intersects(variant)) continue;
                ++countExon;
            }
            if (countExon > 1) {
                CodonChange codonChange = CodonChange.factory(variant, this, variantEffects);
                codonChange.codonChange();
                return true;
            }
        }
        boolean exonAnnotated = false;
        for (Exon ex : this) {
            if (!ex.intersects(variant)) continue;
            exonAnnotated |= ex.variantEffect(variant, variantEffects);
        }
        boolean included = false;
        for (Utr utr : this.utrs) {
            if (!utr.intersects(variant)) continue;
            utr.variantEffect(variant, variantEffects);
            included |= utr.includes(variant);
        }
        if (included) {
            return true;
        }
        for (Intron intron : this.introns()) {
            if (!intron.intersects(variant)) continue;
            intron.variantEffect(variant, variantEffects);
            included |= intron.includes(variant);
        }
        if (included) {
            return true;
        }
        if (!exonAnnotated) {
            variantEffects.add(variant, this, EffectType.TRANSCRIPT, "");
            return true;
        }
        return exonAnnotated;
    }
}

