/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Log;

public class NextProt
extends Marker {
    private static final long serialVersionUID = 8939301304881007289L;
    String transcriptId;
    boolean highlyConservedAaSequence;
    String name;

    public NextProt() {
        this.type = EffectType.NEXT_PROT;
    }

    public NextProt(Transcript transcript, int start, int end, String id) {
        super(transcript.getChromosome(), start, end, false, id);
        this.type = EffectType.NEXT_PROT;
        this.transcriptId = transcript.getId();
    }

    public NextProt(Transcript transcript, int start, int end, String id, String name) {
        super(transcript.getChromosome(), start, end, false, id);
        this.type = EffectType.NEXT_PROT;
        this.name = name;
        this.transcriptId = transcript.getId();
    }

    @Override
    public NextProt cloneShallow() {
        NextProt clone = (NextProt)super.cloneShallow();
        clone.transcriptId = this.transcriptId;
        clone.highlyConservedAaSequence = this.highlyConservedAaSequence;
        return clone;
    }

    public String getName() {
        return this.name;
    }

    public String getTranscriptId() {
        return this.transcriptId;
    }

    @Override
    public boolean isDeferredAnalysis() {
        return true;
    }

    public boolean isHighlyConservedAaSequence() {
        return this.highlyConservedAaSequence;
    }

    public void setHighlyConservedAaSequence(boolean highlyConservedAaSequence) {
        this.highlyConservedAaSequence = highlyConservedAaSequence;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.transcriptId = markerSerializer.getNextField();
        this.highlyConservedAaSequence = markerSerializer.getNextFieldBoolean();
        this.name = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.transcriptId + "\t" + this.highlyConservedAaSequence + "\t" + this.name;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        VariantEffect.EffectImpact effectImpact = VariantEffect.EffectImpact.LOW;
        VariantEffect.EffectImpact prevEffImpact = variantEffects.highestImpact(this.getTranscriptId());
        if (prevEffImpact == null) {
            Log.warning(ErrorWarningType.WARNING_TRANSCRIPT_NOT_FOUND, "NextProt '" + this.name + "' could not find previous effect impact for transcript '" + this.getTranscriptId() + "', ");
        } else {
            switch (prevEffImpact) {
                case HIGH: {
                    effectImpact = VariantEffect.EffectImpact.HIGH;
                    break;
                }
                case MODERATE: {
                    effectImpact = this.isHighlyConservedAaSequence() ? VariantEffect.EffectImpact.HIGH : VariantEffect.EffectImpact.LOW;
                    break;
                }
                case LOW: {
                    effectImpact = this.isHighlyConservedAaSequence() ? VariantEffect.EffectImpact.LOW : VariantEffect.EffectImpact.MODIFIER;
                    break;
                }
                case MODIFIER: {
                    effectImpact = VariantEffect.EffectImpact.MODIFIER;
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected previous impact when assesing NextProt annotation: '" + String.valueOf((Object)prevEffImpact) + "'");
                }
            }
        }
        variantEffects.add(variant, this, this.type, effectImpact, this.name);
        return true;
    }
}

