/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerSeq;
import org.snpeff.interval.Variant;
import org.snpeff.motif.Pwm;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.VariantEffect;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.GprSeq;

public class Motif
extends Marker {
    private static final long serialVersionUID = 8464487883781181867L;
    public static final double SCORE_THRESHOLD = 0.01;
    public static final boolean debug = false;
    String pwmId;
    String pwmName;
    Pwm pwm;

    public Motif() {
        this.type = EffectType.MOTIF;
    }

    public Motif(Marker parent, int start, int end, boolean strandMinus, String id, String pwmName, String pwmId) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.MOTIF;
        this.pwmName = pwmName;
        this.pwmId = pwmId;
    }

    @Override
    public Motif cloneShallow() {
        Motif clone = (Motif)super.cloneShallow();
        clone.pwmId = this.pwmId;
        clone.pwmName = this.pwmName;
        return clone;
    }

    VariantEffect.EffectImpact effectImpact(Variant variant) {
        VariantEffect.EffectImpact effectImpact = VariantEffect.EffectImpact.MODIFIER;
        if (this.pwm != null) {
            MarkerSeq mseq = new MarkerSeq((Marker)this.parent, this.start, this.end, false, this.id);
            String seqBest = this.pwm.getBestSequenceStr();
            mseq.setSequence(this.isStrandPlus() ? seqBest : GprSeq.reverseWc(seqBest));
            if (variant.isSnp() || variant.isMnp()) {
                double scoreNew;
                double scoreBest;
                double diff;
                MarkerSeq mseqNew = mseq.apply(variant);
                String variantd = mseqNew.getSequence();
                if (this.isStrandMinus()) {
                    variantd = GprSeq.reverseWc(variantd);
                }
                if (Math.abs(diff = (scoreBest = this.pwm.score(seqBest)) - (scoreNew = this.pwm.score(variantd))) > 0.01) {
                    effectImpact = VariantEffect.EffectImpact.LOW;
                }
            } else if (variant.isInDel()) {
                effectImpact = VariantEffect.EffectImpact.LOW;
            }
        }
        return effectImpact;
    }

    public Pwm getPwm() {
        return this.pwm;
    }

    public String getPwmId() {
        return this.pwmId;
    }

    public String getPwmName() {
        return this.pwmName;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.pwmId = markerSerializer.getNextField();
        this.pwmName = markerSerializer.getNextField();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.pwmId + "\t" + this.pwmName;
    }

    public void setPwm(Pwm pwm) {
        this.pwm = pwm;
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        if (variant.isDel() && variant.includes(this)) {
            variantEffects.add(variant, this, EffectType.MOTIF_DELETED, VariantEffect.EffectImpact.LOW, "");
        } else {
            variantEffects.add(variant, this, this.type, this.effectImpact(variant), "");
        }
        return true;
    }
}

