/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.fileIterator.Gff3FileIterator;
import org.snpeff.fileIterator.VcfFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.IntervalComparatorByEnd;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Marker;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class Markers
implements Serializable,
Collection<Marker> {
    private static final long serialVersionUID = 259791388087691277L;
    protected ArrayList<Marker> markers;
    protected String name = "";

    public Markers() {
        this.markers = new ArrayList();
    }

    public Markers(Collection otherMarkers) {
        this.markers = new ArrayList();
        this.addAll(otherMarkers);
    }

    public Markers(Markers otherMarkers) {
        this.markers = new ArrayList();
        this.addAll((Collection<? extends Marker>)otherMarkers.getMarkers());
    }

    public Markers(String name) {
        this.name = name;
        this.markers = new ArrayList();
    }

    public static Markers readMarkers(String fileName) {
        String flLower = fileName.toLowerCase();
        if (flLower.endsWith(".gz")) {
            flLower = Gpr.removeExt(flLower);
        }
        if (flLower.endsWith(".txt")) {
            return new BedFileIterator(fileName, null).loadMarkers();
        }
        if (flLower.endsWith(".bed")) {
            return new BedFileIterator(fileName).loadMarkers();
        }
        if (flLower.endsWith(".vcf")) {
            return new VcfFileIterator(fileName).loadMarkers();
        }
        if (flLower.endsWith(".gff")) {
            return new Gff3FileIterator(fileName).loadMarkers();
        }
        throw new RuntimeException("Unrecognized genomig interval file type '" + fileName + "'");
    }

    @Override
    public boolean add(Marker marker) {
        return this.markers.add(marker);
    }

    public Markers add(Markers markersToAdd) {
        this.markers.addAll(markersToAdd.markers);
        return this;
    }

    @Override
    public boolean addAll(Collection<? extends Marker> mm) {
        boolean changed = false;
        for (Marker marker : mm) {
            changed |= this.markers.add(marker);
        }
        return changed;
    }

    @Override
    public void clear() {
        this.markers.clear();
    }

    @Override
    public boolean contains(Object o) {
        return this.markers.contains(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return this.markers.containsAll(c);
    }

    public boolean equals(Markers intervals) {
        if (intervals == null) {
            return false;
        }
        if (this.size() != intervals.size()) {
            return false;
        }
        this.sort(false, false);
        intervals.sort(false, false);
        Iterator<Marker> it1 = this.iterator();
        Iterator<Marker> it2 = intervals.iterator();
        while (it1.hasNext() && it2.hasNext()) {
            Interval i2;
            Interval i1 = it1.next();
            if (i1.equals(i2 = (Interval)it2.next())) continue;
            return false;
        }
        return true;
    }

    public Marker get(int i2) {
        return this.markers.get(i2);
    }

    public List<Marker> getMarkers() {
        return this.markers;
    }

    public int getMedian() {
        int i2 = 0;
        int[] points = new int[2 * this.size()];
        for (Interval interval : this) {
            points[i2++] = interval.getStart();
            points[i2++] = interval.getEnd();
        }
        Arrays.sort(points);
        int middle = points.length / 2;
        return points[middle];
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Markers intersect() {
        Markers intersectOfOverlaps = new Markers();
        IntervalForest forest = new IntervalForest(this);
        HashSet<Marker> done = new HashSet<Marker>();
        for (Marker mi : this) {
            if (done.contains(mi)) continue;
            Markers query = forest.query(mi);
            Marker intersect = new Marker(mi.getParent(), mi.getStart(), mi.getEnd(), mi.isStrandMinus(), "");
            done.add(mi);
            for (Marker m : query) {
                if (intersect != null && (intersect.getStart() < m.getStart() || intersect.getEnd() > m.getEnd())) {
                    intersect = intersect.intersect(m);
                }
                done.add(m);
            }
            if (intersect == null) continue;
            intersectOfOverlaps.add(intersect);
        }
        return intersectOfOverlaps;
    }

    public Markers intersect(Marker marker) {
        Markers result = new Markers();
        for (Marker m : this) {
            Marker intersect = marker.intersect(m);
            if (intersect == null) continue;
            result.add(intersect);
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.markers.isEmpty();
    }

    @Override
    public Iterator<Marker> iterator() {
        return this.markers.iterator();
    }

    public void load(String fileName) {
        this.load(fileName, null);
    }

    public void load(String fileName, Genome genome) {
        MarkerSerializer markerSerializer = new MarkerSerializer(genome);
        Markers markers = markerSerializer.load(fileName);
        this.add(markers);
    }

    public Markers merge() {
        Markers intsSorted = new Markers();
        intsSorted.add(this);
        intsSorted.sort();
        Markers intsMerged = new Markers();
        Object tag = "";
        String chromoName = "";
        Chromosome chromo = null;
        int start = -1;
        int end = -1;
        for (Marker i2 : intsSorted) {
            Object im;
            Chromosome ichromo = i2.getChromosome();
            String ichromoName = ichromo.getId();
            if (!chromoName.equals(ichromoName)) {
                if (start >= 0 && end >= 0) {
                    im = new Marker(chromo, start, end, false, (String)tag);
                    intsMerged.add((Marker)im);
                }
                chromoName = ichromoName;
                chromo = ichromo;
                end = -1;
                start = -1;
                tag = "";
            }
            if (i2.start > end) {
                if (start >= 0 && end >= 0) {
                    if (end < start) {
                        Log.debug("This should never happen!\tstart: " + start + "\tend:" + end);
                        for (Marker m : this) {
                            System.err.println("\t" + String.valueOf(m));
                        }
                    } else {
                        im = new Marker(chromo, start, end, false, (String)tag);
                        intsMerged.add((Marker)im);
                    }
                }
                end = -1;
                start = -1;
                tag = "";
            }
            if (start < 0) {
                start = i2.start;
            }
            end = Math.max(end, i2.end);
            if (((String)tag).length() <= 0) {
                tag = i2.id;
                continue;
            }
            tag = (String)tag + " " + i2.id;
        }
        if (start >= 0 && end >= 0) {
            Marker im = new Marker(chromo, start, end, false, (String)tag);
            intsMerged.add(im);
        }
        return intsMerged;
    }

    public Markers minus(Marker interval) {
        Markers ints = new Markers();
        for (Marker i2 : this) {
            if (i2.intersects(interval)) {
                if (interval.getStart() <= i2.getStart() && i2.getEnd() <= interval.getEnd()) continue;
                if (interval.getStart() <= i2.getStart() && interval.getEnd() < i2.getEnd()) {
                    ints.add(new Marker(i2.getParent(), interval.getEnd() + 1, i2.getEnd(), i2.isStrandMinus(), i2.getId()));
                    continue;
                }
                if (i2.getStart() < interval.getStart() && i2.getEnd() <= interval.getEnd()) {
                    ints.add(new Marker(i2.getParent(), i2.getStart(), interval.getStart() - 1, i2.isStrandMinus(), i2.getId()));
                    continue;
                }
                if (i2.getStart() < interval.getStart() && interval.getEnd() < i2.getEnd()) {
                    ints.add(new Marker(i2.getParent(), i2.getStart(), interval.getStart() - 1, i2.isStrandMinus(), i2.getId()));
                    ints.add(new Marker(i2.getParent(), interval.getEnd() + 1, i2.getEnd(), i2.isStrandMinus(), i2.getId()));
                    continue;
                }
                throw new RuntimeException("Interval intersection not analysed. This should nbever happen!");
            }
            ints.add(i2);
        }
        return ints;
    }

    public Markers minus(Markers intervals) {
        Markers result = new Markers();
        result.add(this);
        for (Marker j : intervals) {
            result = result.minus(j);
        }
        return result;
    }

    public Interval rand() {
        int idx = (int)(Math.random() * (double)this.markers.size());
        return this.markers.get(idx);
    }

    @Override
    public boolean remove(Object o) {
        return this.markers.remove(o);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.markers.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.markers.retainAll(c);
    }

    public void save(String fileName) {
        if (this.size() <= 0) {
            return;
        }
        Genome genome = this.markers.get(0).getGenome();
        HashSet<Chromosome> chromos = new HashSet<Chromosome>();
        for (Iterator<Marker> m : this) {
            chromos.add(((Interval)((Object)m)).getChromosome());
        }
        Markers markersToSave = new Markers();
        markersToSave.add(genome);
        for (Chromosome chr : chromos) {
            markersToSave.add(chr);
        }
        for (Marker m : this.markers) {
            markersToSave.add(m);
        }
        MarkerSerializer markerSerializer = new MarkerSerializer(genome);
        markerSerializer.save(fileName, markersToSave);
    }

    public void save(String fileName, String chr) {
        if (this.size() <= 0) {
            return;
        }
        Markers markersToSave = new Markers();
        Genome genome = this.markers.get(0).getGenome();
        markersToSave.add(genome.getChromosome(chr));
        for (Marker m : this.markers) {
            markersToSave.add(m);
        }
        MarkerSerializer markerSerializer = new MarkerSerializer(genome);
        markerSerializer.doNotSave(genome);
        markerSerializer.save(fileName, markersToSave);
    }

    @Override
    public int size() {
        return this.markers.size();
    }

    public Markers sort() {
        return this.sort(false, false);
    }

    public Markers sort(boolean byEnd, boolean reverse) {
        if (byEnd) {
            Collections.sort(this.markers, new IntervalComparatorByEnd(reverse));
        } else {
            Collections.sort(this.markers, new IntervalComparatorByStart(reverse));
        }
        return this;
    }

    public Marker[] toArray() {
        Marker[] markers = new Marker[this.size()];
        int i2 = 0;
        for (Marker m : this) {
            markers[i2++] = m;
        }
        return markers;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.markers.toArray(a);
    }

    public String toString() {
        int num = 1;
        StringBuilder sb = new StringBuilder();
        for (Marker i2 : this) {
            sb.append("\t" + num++ + ":\t" + i2.getChromosomeName() + "\t" + i2.getStart() + "\t" + i2.getEnd() + "\t" + i2.getClass().getSimpleName() + "\t" + i2.getId() + "\n");
        }
        return sb.toString();
    }

    public String toStringAsciiArt(int maxLen) {
        StringBuilder sb = new StringBuilder();
        Object sep = "";
        for (int i2 = 0; i2 < maxLen; ++i2) {
            sep = (String)sep + "=";
        }
        String ch = "";
        for (Marker i3 : this) {
            if (!i3.getChromosomeName().equals(ch)) {
                sb.append("|" + (String)sep + "|\n");
                ch = i3.getChromosomeName();
            }
            sb.append("|" + i3.toStringAsciiArt(maxLen) + "|\t" + i3.getChromosomeName() + ": [" + i3.start + " - " + i3.end + "] ");
            if (i3.id != null && i3.id.length() > 0) {
                sb.append("'" + i3.id + "'");
            }
            sb.append("\n");
        }
        sb.append("|" + (String)sep + "|\n");
        return sb.toString();
    }

    public String toStringTxt() {
        StringBuilder sb = new StringBuilder();
        for (Marker i2 : this) {
            sb.append(i2.getChromosomeName() + "\t" + i2.getStart() + "\t" + i2.getEnd() + "\t" + i2.getId() + "\n");
        }
        return sb.toString();
    }

    public Markers union() {
        Markers unionOfOverlaps = new Markers();
        IntervalForest forest = new IntervalForest(this);
        forest.build();
        HashSet<Marker> done = new HashSet<Marker>();
        for (Marker mi : this) {
            if (done.contains(mi)) continue;
            Markers query = forest.query(mi);
            Marker union = mi.clone();
            done.add(mi);
            for (Marker m : query) {
                if (union != null && union.getStart() > m.getStart() || union.getEnd() < m.getEnd()) {
                    union = union.union(m);
                }
                done.add(m);
            }
            if (union == null) continue;
            unionOfOverlaps.add(union);
        }
        return unionOfOverlaps;
    }

    public Markers unique() {
        HashSet<Marker> set = new HashSet<Marker>();
        ArrayList<Marker> markersUnique = new ArrayList<Marker>();
        for (Marker m : this.markers) {
            if (!set.add(m)) continue;
            markersUnique.add(m);
        }
        this.markers = markersUnique;
        return this;
    }
}

