/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.snpeff.fileIterator.LineFileIterator;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerWithFrame;
import org.snpeff.interval.Markers;

public class MarkerUtil {
    public static Map<Marker, Marker> collapseZeroGap(Markers markersOri) {
        HashMap<Marker, Marker> collapse = new HashMap<Marker, Marker>();
        Markers sorted = new Markers();
        sorted.add(markersOri);
        sorted.sort(false, false);
        Interval markerPrev = null;
        Marker markerToAdd = null;
        int countCollapsed = 0;
        for (Marker m : sorted) {
            if (markerToAdd == null) {
                markerToAdd = m.clone();
            }
            if (markerPrev != null) {
                int start = markerPrev.getEnd() + 1;
                int end = m.getStart() - 1;
                int gapSize = end - start + 1;
                if (gapSize <= 0) {
                    ++countCollapsed;
                    if (markerToAdd.getEnd() < m.getEnd()) {
                        markerToAdd.setEnd(m.getEnd());
                    }
                    if (markerToAdd.isStrandMinus() && markerToAdd instanceof MarkerWithFrame && m instanceof MarkerWithFrame) {
                        MarkerWithFrame markerToAddWf = (MarkerWithFrame)((Object)markerToAdd);
                        MarkerWithFrame mwf = (MarkerWithFrame)((Object)m);
                        markerToAddWf.setFrame(mwf.getFrame());
                    }
                } else {
                    markerToAdd = m.clone();
                }
            }
            collapse.put(m, markerToAdd);
            markerPrev = m;
        }
        HashSet collapsed = new HashSet();
        collapsed.addAll(collapse.values());
        if (markersOri.size() - countCollapsed != collapsed.size()) {
            throw new RuntimeException("Sanitycheck failed. This should never happen!\n\tmarkers.size: " + markersOri.size() + "\n\tcountCollapsed: " + countCollapsed + "\n\treplaced.size : " + collapsed.size());
        }
        return collapse;
    }

    public static Markers readTxt(String fileName, Genome genome, int positionBase) {
        if (genome == null) {
            genome = new Genome();
        }
        Markers markers = new Markers();
        LineFileIterator lfi = new LineFileIterator(fileName);
        int lineNum = 1;
        for (String line : lfi) {
            Marker interval = new Marker();
            interval.readTxt(line, lineNum, genome, positionBase);
            markers.add(interval);
            ++lineNum;
        }
        return markers;
    }

    /*
     * WARNING - void declaration
     */
    public static Map<Marker, Marker> redundant(Collection<? extends Marker> markersOri) {
        void var4_7;
        HashMap<Marker, Marker> redundant = new HashMap<Marker, Marker>();
        ArrayList<Marker> markers = new ArrayList<Marker>();
        for (Marker marker : markersOri) {
            if (marker.getStart() > marker.getEnd()) continue;
            markers.add(marker);
        }
        int size = markers.size();
        boolean bl = false;
        while (var4_7 < size) {
            Marker mi = (Marker)markers.get((int)var4_7);
            Marker markerLarge = null;
            for (int j = 0; j < size && markerLarge == null; ++j) {
                Marker mj = (Marker)markers.get(j);
                if (var4_7 == j || !mj.includes(mi) || mi.includes(mj) && var4_7 > j) continue;
                markerLarge = mj;
            }
            if (markerLarge != null) {
                redundant.put(mi, markerLarge);
            }
            ++var4_7;
        }
        return redundant;
    }
}

