/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.Arrays;
import org.snpeff.binseq.DnaNSequence;
import org.snpeff.binseq.DnaSequence;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Variant;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.util.GprSeq;

public class MarkerSeq
extends Marker {
    private static final long serialVersionUID = -8794533547221460207L;
    DnaSequence sequence;

    public MarkerSeq() {
        this.type = EffectType.SEQUENCE;
        this.strandMinus = false;
        this.sequence = DnaSequence.empty();
    }

    public MarkerSeq(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
        this.type = EffectType.SEQUENCE;
        this.strandMinus = strandMinus;
        this.sequence = DnaSequence.empty();
    }

    public MarkerSeq(Marker parent, int start, int end, String seq) {
        this(parent, start, end, false, "");
        if (seq != null && !seq.isEmpty()) {
            this.setSequence(seq);
        }
    }

    @Override
    public MarkerSeq apply(Variant variant) {
        MarkerSeq newMarkerSeq;
        block11: {
            block10: {
                if (!this.shouldApply(variant)) {
                    return this;
                }
                newMarkerSeq = (MarkerSeq)super.apply(variant);
                if (newMarkerSeq == null) {
                    return null;
                }
                if (!variant.intersects(this) || this.sequence == null || this.sequence.isEmpty()) break block10;
                switch (variant.getVariantType()) {
                    case SNP: {
                        this.applySnp(variant, newMarkerSeq);
                        break block11;
                    }
                    case INS: {
                        this.applyIns(variant, newMarkerSeq);
                        break block11;
                    }
                    case DEL: {
                        this.applyDel(variant, newMarkerSeq);
                        break block11;
                    }
                    case DUP: {
                        this.applyDup(variant, newMarkerSeq);
                        break block11;
                    }
                    case MNP: {
                        this.applyMnp(variant, newMarkerSeq);
                        break block11;
                    }
                    case MIXED: {
                        break block11;
                    }
                    default: {
                        throw new RuntimeException("Unimplemented method for variant change type " + String.valueOf((Object)variant.getVariantType()) + "\n\tVariant: " + String.valueOf(variant));
                    }
                }
            }
            newMarkerSeq.setSequence(this.getSequence());
        }
        return newMarkerSeq;
    }

    protected void applyDel(Variant variant, MarkerSeq markerSeq) {
        String seq = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
        int idxStart = variant.getStart() - this.start;
        int idxEnd = idxStart + variant.size();
        StringBuilder newSeq = new StringBuilder();
        if (idxStart >= 0) {
            newSeq.append(seq.substring(0, idxStart));
        }
        if (idxEnd >= 0 && idxEnd < seq.length()) {
            newSeq.append(seq.substring(idxEnd));
        }
        seq = newSeq.toString();
        markerSeq.setSequence(this.isStrandPlus() ? seq : GprSeq.reverseWc(seq));
    }

    protected void applyDup(Variant variant, MarkerSeq markerSeq) {
        Object seq = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
        String dupSeq = this.getSequence(this.intersect(variant));
        int idx = variant.getStart() - this.start - 1;
        seq = idx >= 0 ? ((String)seq).substring(0, idx + 1) + dupSeq + ((String)seq).substring(idx + 1) : dupSeq + (String)seq;
        markerSeq.setSequence((String)(this.isStrandPlus() ? seq : GprSeq.reverseWc((String)seq)));
    }

    protected void applyIns(Variant variant, MarkerSeq markerSeq) {
        Object seq = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
        String netChange = variant.netChange(this);
        int idx = variant.getStart() - this.start - 1;
        seq = idx >= 0 ? ((String)seq).substring(0, idx + 1) + netChange + ((String)seq).substring(idx + 1) : netChange + (String)seq;
        markerSeq.setSequence((String)(this.isStrandPlus() ? seq : GprSeq.reverseWc((String)seq)));
    }

    protected void applyMnp(Variant variant, MarkerSeq markerSeq) {
        int idxStart = variant.getStart() - this.start;
        int idxAlt = 0;
        if (idxStart < 0) {
            idxAlt = -idxStart;
            idxStart = 0;
        }
        int changeSize = variant.intersectSize(this);
        int idxEnd = idxStart + changeSize;
        String seq = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
        StringBuilder seqsb = new StringBuilder();
        seqsb.append(seq.substring(0, idxStart).toLowerCase());
        String seqAlt = variant.getAlt().substring(idxAlt, idxAlt + changeSize).toUpperCase();
        seqsb.append(seqAlt);
        seqsb.append(seq.substring(idxEnd).toLowerCase());
        seq = seqsb.toString();
        markerSeq.setSequence(this.isStrandPlus() ? seq : GprSeq.reverseWc(seq));
    }

    protected void applySnp(Variant variant, MarkerSeq markerSeq) {
        Object seq = this.isStrandPlus() ? this.sequence.getSequence() : this.sequence.reverseWc().getSequence();
        int idx = variant.getStart() - this.start;
        seq = ((String)seq).substring(0, idx) + variant.getAlt() + ((String)seq).substring(idx + 1);
        markerSeq.setSequence((String)(this.isStrandPlus() ? seq : GprSeq.reverseWc((String)seq)));
    }

    public String basesAt(int index, int len) {
        if (this.isStrandMinus()) {
            int idx = this.sequence.length() - index - len;
            return GprSeq.reverseWc(this.sequence.getBases(idx, len));
        }
        return this.sequence.getBases(index, len);
    }

    public String basesAtPos(int pos, int len) {
        int index = pos - this.start;
        if (index < 0) {
            return "";
        }
        return this.basesAt(index, len);
    }

    @Override
    public MarkerSeq cloneShallow() {
        MarkerSeq clone = (MarkerSeq)super.cloneShallow();
        clone.sequence = this.sequence.clone();
        return clone;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    public String getSequence(Marker marker) {
        if (!this.includes(marker)) {
            return null;
        }
        return this.basesAtPos(marker.getStart(), marker.size());
    }

    public boolean hasSequence() {
        if (this.size() <= 0) {
            return true;
        }
        return this.sequence != null && !this.sequence.isEmpty();
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.setSequence(markerSerializer.getNextField());
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.sequence.getSequence();
    }

    public void setSequence(String sequence) {
        if (sequence == null || ((String)sequence).length() <= 0) {
            this.sequence = DnaSequence.empty();
        }
        if (((String)sequence).length() != this.size()) {
            if (((String)sequence).length() > this.size()) {
                sequence = ((String)sequence).substring(0, this.size());
            } else {
                char[] ns = new char[this.size() - ((String)sequence).length()];
                Arrays.fill(ns, 'N');
                sequence = (String)sequence + new String(ns);
            }
        }
        this.sequence = GprSeq.isAmbiguous((String)sequence) ? new DnaNSequence((String)sequence) : new DnaSequence((String)sequence);
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + ":" + this.start + "-" + this.end + (String)(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + (String)(this.sequence != null ? ", sequence: " + String.valueOf(this.sequence) : "");
    }

    @Override
    public Marker union(Marker m) {
        if (!this.getChromosomeName().equals(m.getChromosomeName())) {
            return null;
        }
        MarkerSeq ms = (MarkerSeq)m;
        int ustart = Math.min(this.start, m.getStart());
        int uend = Math.max(this.end, m.getEnd());
        Object seq = null;
        if (this.includes(m)) {
            seq = this.getSequence();
        } else if (m.includes(this)) {
            seq = ms.getSequence();
        } else if (this.intersects(m)) {
            if (this.start < m.start) {
                overlap = this.end - m.start + 1;
                seq = this.getSequence() + ms.getSequence().substring(overlap);
            } else {
                overlap = m.end - this.start + 1;
                seq = ms.getSequence() + this.getSequence().substring(overlap);
            }
        }
        MarkerSeq msNew = (MarkerSeq)this.clone();
        msNew.start = ustart;
        msNew.end = uend;
        if (seq != null) {
            msNew.setSequence((String)seq);
        }
        return msNew;
    }
}

