/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;

public class IntervalSetIterator
implements Iterator<Set<Marker>>,
Iterable<Set<Marker>> {
    boolean firstIteration = true;
    boolean newChromosome = true;
    HashSet<Marker> openIntervals = new HashSet();
    HashSet<Marker> openIntervalsOut = new HashSet();
    Markers intervalsByStart = new Markers();
    Markers intervalsByEnd;
    Iterator<Marker> itStart;
    Iterator<Marker> itEnd;
    Marker intStart;
    Marker intEnd;
    int start;
    int end;
    int i;
    String chromo;

    public IntervalSetIterator(Markers intervals) {
        this.intervalsByStart.add(intervals);
        this.intervalsByStart.sort(false, false);
        this.intervalsByEnd = new Markers();
        this.intervalsByEnd.add(intervals);
        this.intervalsByEnd.sort(true, false);
        this.itStart = this.intervalsByStart.iterator();
        this.itEnd = this.intervalsByEnd.iterator();
        this.end = -1;
        this.start = -1;
        this.i = -1;
    }

    boolean equalsChromo(String chr) {
        if (chr == null && this.chromo == null) {
            return true;
        }
        if (chr == null || this.chromo == null) {
            return false;
        }
        return chr.equals(this.chromo);
    }

    @Override
    public boolean hasNext() {
        return this.itStart.hasNext() || this.itEnd.hasNext() || this.openIntervals.size() > 0;
    }

    void iterate() {
        if (this.firstIteration) {
            this.iterateInit();
        } else if (this.newChromosome) {
            if (this.equalsChromo(this.intEnd.getChromosomeName())) {
                this.iterateNext();
            } else {
                this.iterateInitNewChromo();
            }
        } else if (this.itStart.hasNext() || this.itEnd.hasNext()) {
            this.iterateNext();
        } else if (this.openIntervals.size() > 0) {
            this.iterateFinish();
        }
    }

    void iterateFinish() {
        Interval interv = this.openIntervals.iterator().next();
        this.openIntervals.remove(interv);
    }

    void iterateInit() {
        this.intStart = this.itStart.next();
        this.openIntervals.add(this.intStart);
        this.start = this.intStart.getStart();
        this.chromo = this.intStart.getChromosomeName();
        this.intEnd = this.itEnd.next();
        this.end = this.intEnd.getEnd();
        this.openIntervals.add(this.intEnd);
        this.i = this.intStart.getStart();
        this.firstIteration = false;
        this.newChromosome = false;
    }

    void iterateInitNewChromo() {
        this.chromo = this.intStart.getChromosomeName();
        this.end = -1;
        this.start = -1;
        this.i = -1;
        this.intEnd = null;
        this.openIntervals.add(this.intStart);
        this.start = this.intStart.getStart();
        this.end = this.intEnd.getEnd();
        this.openIntervals.add(this.intEnd);
        this.i = Math.min(this.start, this.end);
        this.newChromosome = false;
    }

    void iterateNext() {
        if (this.intStart != null && this.intStart.getStart() <= this.i && !this.newChromosome) {
            if (this.itStart.hasNext()) {
                this.intStart = this.itStart.next();
                if (this.equalsChromo(this.intStart.getChromosomeName())) {
                    this.openIntervals.add(this.intStart);
                    this.start = this.intStart.getStart();
                    this.i = Math.min(this.start, this.end);
                    return;
                }
                this.newChromosome = true;
            } else {
                this.intStart = null;
                this.start = Integer.MAX_VALUE;
            }
        }
        if (this.intEnd != null && this.intEnd.getEnd() <= this.i || this.newChromosome || this.intStart == null) {
            if (this.itEnd.hasNext()) {
                this.openIntervals.remove(this.intEnd);
                this.intEnd = this.itEnd.next();
                if (this.equalsChromo(this.intEnd.getChromosomeName())) {
                    this.end = this.intEnd.getEnd();
                    this.i = Math.min(this.start, this.end);
                }
                return;
            }
            this.openIntervals.remove(this.intEnd);
            this.intEnd = null;
            return;
        }
    }

    @Override
    public Iterator<Set<Marker>> iterator() {
        return this;
    }

    @Override
    public Set<Marker> next() {
        if (!this.hasNext()) {
            return null;
        }
        this.iterate();
        return this.openIntervals;
    }

    @Override
    public void remove() {
        throw new RuntimeException("Unimplmented method!");
    }

    public String toString() {
        return "i:" + this.i + "\tintStart: " + String.valueOf(this.intStart) + "\tintEnd: " + String.valueOf(this.intEnd) + "\topenIntervals: " + String.valueOf(this.openIntervals);
    }
}

