/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.snpeff.interval.Genome;
import org.snpeff.interval.GffMarker;
import org.snpeff.interval.Marker;

public class Gtf2Marker
extends GffMarker {
    private static final long serialVersionUID = 5416962964309837838L;
    static final String TAG_KEY = "tag";
    static final String ATTRIBUTE_PATTERN_REGEX = "\\s*(\\S+)\\s+\"(.*?)\"\\s*;";
    static final Pattern ATTRIBUTE_PATTERN = Pattern.compile("\\s*(\\S+)\\s+\"(.*?)\"\\s*;");

    public Gtf2Marker() {
    }

    public Gtf2Marker(Genome genome, String line) {
        super(genome, line);
    }

    public Gtf2Marker(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id);
    }

    @Override
    public boolean isMultipleValues(String key) {
        return key.equals(TAG_KEY);
    }

    @Override
    protected void parseAttributes(String attrStr) {
        this.keyValues = new HashMap();
        this.keys = new HashSet();
        if (attrStr.length() > 0) {
            Matcher matcher = ATTRIBUTE_PATTERN.matcher(attrStr);
            while (matcher.find()) {
                if (matcher.groupCount() < 2) continue;
                String key = matcher.group(1).toLowerCase();
                String value = matcher.group(2);
                this.add(key, value);
            }
        }
    }
}

