/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.snpeff.interval.BioType;
import org.snpeff.interval.Custom;
import org.snpeff.interval.FrameType;
import org.snpeff.interval.Genome;
import org.snpeff.interval.GffType;
import org.snpeff.interval.Marker;
import org.snpeff.util.Gpr;
import org.snpeff.util.KeyValue;

public class GffMarker
extends Custom {
    private static final long serialVersionUID = -164502778854644537L;
    public static final String MULTIPLE_VALUES_SEPARATOR = ";";
    public static final String FIELD_BIOTYPE = "biotype";
    public static final String FIELD_DB_XREF = "db_xref";
    public static final String FIELD_EXON_ID = "exon_id";
    public static final String FIELD_GENE = "gene";
    public static final String FIELD_GENE_BIOTYPE = "gene_biotype";
    public static final String FIELD_GENE_ID = "gene_id";
    public static final String FIELD_GENE_NAME = "gene_name";
    public static final String FIELD_GENE_TYPE = "gene_type";
    public static final String FIELD_ID = "ID";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_NAMEU = "Name";
    public static final String FIELD_PARENT = "Parent";
    public static final String FIELD_PROTEIN_ID = "protein_id";
    public static final String FIELD_TAG = "tag";
    public static final String FIELD_TRANSCRIPT_ID = "transcript_id";
    public static final String FIELD_TRANSCRIPT_TSL = "transcript_support_level";
    public static final String FIELD_TRANSCRIPT_VERSION = "transcript_version";
    String source;
    int frame;
    GffType gffType;
    String gffTypeStr;
    Map<String, String> keyValues;
    Set<String> keys;

    public static boolean canParseLine(String line) {
        if (line == null || line.isEmpty() || line.startsWith("#")) {
            return false;
        }
        String[] fields = line.split("\t");
        return fields.length >= 9;
    }

    public GffMarker() {
    }

    public GffMarker(Genome genome, String line) {
        this.parse(genome, line);
    }

    public GffMarker(Marker parent, int start, int end, boolean strandMinus, String id) {
        super(parent, start, end, strandMinus, id, "");
    }

    public void add(String key, String value) {
        if (this.keyValues == null) {
            this.keyValues = new HashMap<String, String>();
        }
        if (this.keys == null) {
            this.keys = new HashSet<String>();
        }
        this.keys.add(key);
        if (this.isMultipleValues(key)) {
            if (this.keyValues.containsKey(key)) {
                String oldValue = this.keyValues.get(key);
                String newValue = oldValue != null ? oldValue + MULTIPLE_VALUES_SEPARATOR + value : value;
                this.keyValues.put(key, newValue);
            } else {
                this.keyValues.put(key, value);
            }
        } else {
            this.keyValues.put(key.toLowerCase(), value);
        }
    }

    public String getAttr(String key) {
        return this.keyValues.get(key.toLowerCase());
    }

    public BioType getBiotype() {
        if (this.gffType == GffType.GENE) {
            return this.getGeneBiotype();
        }
        if (this.gffType == GffType.TRANSCRIPT) {
            return this.getTranscriptBiotype();
        }
        return this.getBiotypeGeneric();
    }

    protected String getBioType() {
        return this.getAttr(FIELD_BIOTYPE);
    }

    protected BioType getBiotypeGeneric() {
        BioType bioType = null;
        if (this.hasAttr(FIELD_BIOTYPE)) {
            return BioType.parse(this.getAttr(FIELD_BIOTYPE));
        }
        bioType = BioType.parse(this.source);
        if (bioType != null) {
            return bioType;
        }
        return BioType.parse(this.gffTypeStr);
    }

    public int getFrame() {
        return this.frame;
    }

    public BioType getGeneBiotype() {
        String[] keys;
        for (String key : keys = new String[]{FIELD_GENE_BIOTYPE, FIELD_GENE_TYPE, FIELD_BIOTYPE}) {
            if (!this.hasAttr(key)) continue;
            return BioType.parse(this.getAttr(key));
        }
        return this.getBiotypeGeneric();
    }

    public String getGeneId() {
        if (this.hasAttr(FIELD_GENE_ID)) {
            return this.getAttr(FIELD_GENE_ID);
        }
        if (this.gffType == GffType.GENE) {
            return this.id;
        }
        if (this.gffType == GffType.TRANSCRIPT) {
            return this.getGffParentId(true);
        }
        return String.valueOf((Object)GffType.GENE) + "_" + this.id;
    }

    public String getGeneName() {
        String pid;
        if (this.hasAttr(FIELD_GENE_NAME)) {
            return this.getAttr(FIELD_GENE_NAME);
        }
        if (this.gffType == GffType.GENE && this.hasAttr(FIELD_NAME)) {
            return this.getAttr(FIELD_NAME);
        }
        if (this.gffType == GffType.TRANSCRIPT && (pid = this.getGffParentId(true)) != null) {
            return pid;
        }
        return this.id;
    }

    public String getGffParentId(boolean doNotRecurse) {
        if (this.hasAttr(FIELD_PARENT)) {
            return this.getAttr(FIELD_PARENT);
        }
        switch (this.gffType) {
            case TRANSCRIPT: 
            case INTRON_CONSERVED: {
                if (this.hasAttr(FIELD_GENE)) {
                    return this.getAttr(FIELD_GENE);
                }
                return doNotRecurse ? null : this.getGeneId();
            }
            case EXON: 
            case CDS: 
            case START_CODON: 
            case STOP_CODON: 
            case UTR3: 
            case UTR5: {
                return doNotRecurse ? null : this.getTranscriptId();
            }
        }
        return null;
    }

    public String[] getGffParentIds() {
        String ids = this.getAttr(FIELD_PARENT);
        if (ids != null) {
            return ids.split(",");
        }
        String pid = this.getGffParentId(false);
        if (pid == null) {
            return null;
        }
        String[] pids = new String[]{pid};
        return pids;
    }

    public GffType getGffType() {
        return this.gffType;
    }

    public String getProteinId() {
        return this.getAttr(FIELD_PROTEIN_ID);
    }

    public BioType getTranscriptBiotype() {
        String[] keys;
        for (String key : keys = new String[]{"transcript_biotype", "transcript_type", FIELD_BIOTYPE}) {
            if (!this.hasAttr(key)) continue;
            return BioType.parse(this.getAttr(key));
        }
        return this.getBiotypeGeneric();
    }

    public String getTags() {
        return this.getAttr(FIELD_TAG);
    }

    public String getTranscriptTsl() {
        return this.getAttr(FIELD_TRANSCRIPT_TSL);
    }

    public String getTranscriptId() {
        if (this.hasAttr(FIELD_TRANSCRIPT_ID)) {
            return this.getAttr(FIELD_TRANSCRIPT_ID);
        }
        if (this.gffType == GffType.TRANSCRIPT) {
            return this.id;
        }
        if (this.gffType == GffType.EXON) {
            return this.getGffParentId(true);
        }
        return String.valueOf((Object)GffType.TRANSCRIPT) + "_" + this.id;
    }

    public String getTranscriptVersion() {
        return this.getAttr(FIELD_TRANSCRIPT_VERSION);
    }

    @Override
    public boolean hasAnnotations() {
        return true;
    }

    public boolean hasAttr(String key) {
        return this.keyValues.containsKey(key = key.toLowerCase()) && this.keyValues.get(key) != null;
    }

    public boolean isMultipleValues(String key) {
        return false;
    }

    public boolean isProteingCoding() {
        BioType bioType = this.getBiotype();
        return bioType != null && bioType.isProteinCoding();
    }

    @Override
    public Iterator<KeyValue<String, String>> iterator() {
        ArrayList<String> keysSorted = new ArrayList<String>();
        keysSorted.addAll(this.keys);
        Collections.sort(keysSorted);
        LinkedList<KeyValue<String, String>> iter = new LinkedList<KeyValue<String, String>>();
        for (String key : keysSorted) {
            iter.add(new KeyValue<String, String>(key, this.getAttr(key)));
        }
        return iter.iterator();
    }

    protected void parse(Genome genome, String line) {
        String[] fields = line.split("\t");
        String chromo = fields[0];
        this.parent = genome.getOrCreateChromosome(chromo);
        this.source = fields[1];
        if (this.source.equals(".")) {
            this.source = "";
        }
        this.gffTypeStr = fields[2];
        if (this.gffTypeStr.isEmpty() || this.gffTypeStr.equals(".")) {
            this.gffType = null;
        }
        this.gffType = GffType.parse(this.gffTypeStr);
        this.start = Gpr.parseIntSafe(fields[3]) - 1;
        this.end = Gpr.parseIntSafe(fields[4]) - 1;
        this.strandMinus = fields[6].equals("-");
        this.frame = fields[7].equals(".") ? -1 : Gpr.parseIntSafe(fields[7]);
        this.frame = FrameType.GFF.convertFrame(this.frame);
        if (fields.length >= 8) {
            this.parseAttributes(fields[8]);
        } else {
            this.parseAttributes(null);
        }
        this.id = this.parseId();
    }

    protected void parseAttributes(String attrStr) {
        this.keyValues = new HashMap<String, String>();
        this.keys = new HashSet<String>();
        this.add("source", this.source);
        this.add("type", this.gffTypeStr);
        if (attrStr != null && attrStr.length() > 0) {
            String[] attrs = attrStr.split(MULTIPLE_VALUES_SEPARATOR);
            for (int i2 = 0; i2 < attrs.length; ++i2) {
                String[] kv = attrs[i2].split("=");
                if (kv.length <= 1) continue;
                String key = kv[0].trim();
                String value = kv[1].trim();
                if (this.hasAttr(key)) continue;
                this.add(key, value);
            }
        }
    }

    protected String parseId() {
        Object id = "";
        id = this.hasAttr(FIELD_ID) ? this.getAttr(FIELD_ID) : (this.gffType == GffType.GENE && this.hasAttr(FIELD_GENE_ID) ? this.getAttr(FIELD_GENE_ID) : (this.gffType == GffType.TRANSCRIPT && this.hasAttr(FIELD_TRANSCRIPT_ID) ? this.getAttr(FIELD_TRANSCRIPT_ID) : (this.gffType == GffType.EXON && this.hasAttr(FIELD_EXON_ID) ? this.getAttr(FIELD_EXON_ID) : (this.hasAttr(FIELD_DB_XREF) ? this.getAttr(FIELD_DB_XREF) : (this.hasAttr(FIELD_NAMEU) ? this.getAttr(FIELD_NAMEU) : String.valueOf((Object)this.gffType) + "_" + this.getChromosomeName() + "_" + (this.start + 1) + "_" + (this.end + 1))))));
        return ((String)id).trim();
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getChromosomeName() + "\t" + this.source + "\t" + String.valueOf((Object)this.gffType) + "\t" + this.start + "\t" + this.end + "\t" + (this.strandMinus ? "-" : "+") + "\n");
        ArrayList<String> keys = new ArrayList<String>();
        keys.addAll(this.keyValues.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            sb.append("\t" + key + " : " + this.getAttr(key) + "\n");
        }
        return sb.toString();
    }
}

