/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.snpeff.binseq.GenomicSequences;
import org.snpeff.fileIterator.FastaFileIterator;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.CytoBands;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genes;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.util.Gpr;

public class Genome
extends Marker
implements Iterable<Chromosome> {
    private static final long serialVersionUID = -330362012383572257L;
    private static int genomeIdCounter = 0;
    int genomeId;
    long length = -1L;
    String species;
    String version;
    String fastaDir;
    List<String> chromosomeNamesSorted = null;
    String[] chromoFastaFiles;
    HashMap<String, Chromosome> chromosomes;
    Genes genes;
    Boolean codingInfo = null;
    Boolean transcriptSupportLevelInfo = null;
    GenomicSequences genomicSequences;
    CytoBands cytoBands;

    public static Genome createFromFaidx(String genomeName, String faidxFile) {
        String[] lines;
        Genome genome = new Genome(genomeName);
        for (String line : lines = Gpr.readFile(faidxFile).split("\n")) {
            String[] vals = line.split("\t");
            String chrName = vals[0];
            int len = Gpr.parseIntSafe(vals[1]);
            Chromosome chromosome = new Chromosome(genome, 0, len, chrName);
            genome.add(chromosome);
        }
        return genome;
    }

    public Genome() {
        this.version = "";
        this.id = "";
        this.type = EffectType.GENOME;
        this.chromosomes = new HashMap();
        this.genes = new Genes(this);
        this.genomicSequences = new GenomicSequences(this);
        this.genomicSequences.build();
        this.setGenomeId();
    }

    public Genome(String version) {
        super(null, 0, Integer.MAX_VALUE, false, version);
        this.version = version;
        this.type = EffectType.GENOME;
        this.chromosomes = new HashMap();
        this.genes = new Genes(this);
        this.genomicSequences = new GenomicSequences(this);
        this.genomicSequences.build();
        this.setGenomeId();
    }

    public Genome(String version, Config config) {
        super(null, 0, Integer.MAX_VALUE, false, version);
        this.version = version;
        this.type = EffectType.GENOME;
        this.genes = new Genes(this);
        this.genomicSequences = new GenomicSequences(this);
        this.genomicSequences.build();
        this.species = config.getProperty(version + ".genome");
        if (this.species == null) {
            throw new RuntimeException("Property: '" + version + ".genome' not found in config file '" + config.getConfigFileCanonicaPath() + "'");
        }
        this.species = this.species.trim();
        String[] chromosomeNames = config.propertyToStringArray(version + ".chromosomes");
        this.fastaDir = config.getProperty(version + ".fasta_dir") != null ? config.getProperty(version + ".fasta_dir").trim() : "";
        this.chromoFastaFiles = config.getProperty(version + ".chromo_fasta_files") != null ? config.propertyToStringArray(version + ".chromo_fasta_files") : new String[0];
        this.chromosomes = new HashMap();
        for (String chName : chromosomeNames) {
            this.add(new Chromosome(this, 0, 0, chName));
        }
        this.setGenomeId();
    }

    public synchronized void add(Chromosome chromo) {
        this.chromosomes.put(chromo.getId(), chromo);
        chromo.setParent(this);
    }

    public List<String> chromosomeNamesSorted() {
        if (this.chromosomeNamesSorted != null) {
            return this.chromosomeNamesSorted;
        }
        ArrayList<Chromosome> chromosArr = new ArrayList<Chromosome>(this.chromosomes.size());
        chromosArr.addAll(this.chromosomes.values());
        Collections.sort(chromosArr);
        this.chromosomeNamesSorted = new ArrayList<String>();
        for (int i2 = 0; i2 < chromosArr.size(); ++i2) {
            this.chromosomeNamesSorted.add(((Chromosome)chromosArr.get(i2)).getId());
        }
        return this.chromosomeNamesSorted;
    }

    synchronized Chromosome createChromosome(String chromoName) {
        Chromosome chr = this.getChromosome(chromoName);
        if (chr != null) {
            return chr;
        }
        String ch = Chromosome.simpleName(chromoName);
        chr = new Chromosome(this, 0, 0, ch);
        this.add(chr);
        return chr;
    }

    public String[] getChromoFastaFiles() {
        return this.chromoFastaFiles;
    }

    public Chromosome getChromosome(String chromoName) {
        String ch = Chromosome.simpleName(chromoName);
        return this.chromosomes.get(ch);
    }

    public int getChromosomeCount() {
        return this.chromosomes.size();
    }

    public Collection<Chromosome> getChromosomes() {
        return this.chromosomes.values();
    }

    public List<Chromosome> getChromosomesSortedSize() {
        ArrayList<Chromosome> chrs = new ArrayList<Chromosome>();
        chrs.addAll(this.chromosomes.values());
        Collections.sort(chrs, new Comparator<Chromosome>(this){

            @Override
            public int compare(Chromosome chr1, Chromosome chr2) {
                int cmp = chr2.size() - chr1.size();
                if (cmp != 0) {
                    return cmp;
                }
                return chr1.getId().compareTo(chr2.getId());
            }
        });
        return chrs;
    }

    public synchronized CytoBands getCytoBands() {
        if (this.cytoBands == null) {
            this.cytoBands = new CytoBands(this);
        }
        return this.cytoBands;
    }

    public Genes getGenes() {
        return this.genes;
    }

    public List<Gene> getGenesSorted() {
        ArrayList<Gene> genesSorted = new ArrayList<Gene>();
        genesSorted.addAll(this.genes.values());
        Collections.sort(genesSorted, new Comparator<Gene>(this){

            @Override
            public int compare(Gene gene1, Gene gene2) {
                return gene1.getId().compareTo(gene2.getId());
            }
        });
        return genesSorted;
    }

    public List<Gene> getGenesSortedPos() {
        ArrayList<Gene> genesSorted = new ArrayList<Gene>();
        genesSorted.addAll(this.genes.values());
        Collections.sort(genesSorted);
        return genesSorted;
    }

    public String getGenomeId() {
        return this.id + "[" + this.genomeId + "]";
    }

    public GenomicSequences getGenomicSequences() {
        return this.genomicSequences;
    }

    public Chromosome getOrCreateChromosome(String chromoName) {
        Chromosome chr = this.getChromosome(chromoName);
        if (chr == null) {
            chr = this.createChromosome(chromoName);
        }
        return chr;
    }

    public String getSpecies() {
        return this.species;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasChromosome(String chromo) {
        return this.chromosomes.containsKey(chromo);
    }

    public boolean hasCodingInfo() {
        if (this.codingInfo == null) {
            int countCoding = 0;
            for (Gene gene : this.genes) {
                if (!gene.isProteinCoding()) continue;
                ++countCoding;
            }
            this.codingInfo = countCoding != 0;
        }
        return this.codingInfo;
    }

    public boolean hasTranscriptSupportLevelInfo() {
        if (this.transcriptSupportLevelInfo == null) {
            int countTsl = 0;
            for (Gene gene : this.genes) {
                for (Transcript tr : gene) {
                    if (!tr.hasTranscriptSupportLevelInfo()) continue;
                    ++countTsl;
                }
            }
            this.transcriptSupportLevelInfo = countTsl != 0;
        }
        return this.codingInfo;
    }

    public boolean isMostExonsHaveSequence() {
        int exonSeq = 0;
        int exonNoSeq = 0;
        for (Gene g : this.getGenes()) {
            for (Transcript tr : g) {
                for (Exon e : tr) {
                    if (e.getSequence().isEmpty()) {
                        ++exonNoSeq;
                        continue;
                    }
                    ++exonSeq;
                }
            }
        }
        return exonNoSeq < exonSeq;
    }

    @Override
    public Iterator<Chromosome> iterator() {
        return this.chromosomes.values().iterator();
    }

    public long length() {
        if (this.length <= 0L) {
            this.length = 0L;
            for (Chromosome chr : this.chromosomes.values()) {
                this.length += (long)(chr.getEnd() - chr.getStart() + 1);
            }
        }
        return this.length;
    }

    public boolean readGenomeSequence(String fastaFile) {
        FastaFileIterator ffi = new FastaFileIterator(fastaFile);
        for (String seq : ffi) {
            String chrName = ffi.getName();
            Chromosome chromosome = this.getChromosome(chrName);
            if (chromosome != null) {
                chromosome.setSequence(seq);
                continue;
            }
            chromosome = new Chromosome(this, 0, seq.length(), chrName);
            chromosome.setSequence(seq);
            this.add(chromosome);
        }
        return true;
    }

    public void remove(Chromosome chromo) {
        this.chromosomes.remove(chromo.getId());
    }

    public void save(String fileName) {
        Markers markers = new Markers();
        markers.add(this);
        for (Chromosome chr : this) {
            markers.add(chr);
        }
        for (Gene g : this.getGenes()) {
            markers.add(g);
        }
        markers.save(fileName);
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.version = markerSerializer.getNextField();
        this.species = markerSerializer.getNextField();
        for (Marker m : markerSerializer.getNextFieldMarkers()) {
            this.add((Chromosome)m);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.version + "\t" + this.species + "\t" + markerSerializer.save(this.chromosomes.values());
    }

    private void setGenomeId() {
        this.genomeId = genomeIdCounter++;
    }

    @Override
    public String toString() {
        return this.toString(null);
    }

    public String toString(StringBuilder errors) {
        StringBuilder sb = new StringBuilder();
        int exonSeq = 0;
        int exonNoSeq = 0;
        int countGenes = 0;
        int countGenesProteinCoding = 0;
        int countTranscripts = 0;
        int countTranscriptsProteinCoding = 0;
        int countTsl = 0;
        int countExons = 0;
        int countCds = 0;
        int countCheckAa = 0;
        int countCheckDna = 0;
        int countUtrs = 0;
        int errorProteinLength = 0;
        int errorProteinStopCodons = 0;
        int warningStopCodon = 0;
        int errorStartCodon = 0;
        int errorTr = 0;
        Genes genes = this.getGenes();
        for (Gene g : genes) {
            ++countGenes;
            if (g.isProteinCoding()) {
                ++countGenesProteinCoding;
            }
            for (Transcript tr : g) {
                if (tr.isProteinCoding()) {
                    ++countTranscriptsProteinCoding;
                }
                if (tr.isAaCheck()) {
                    ++countCheckAa;
                }
                if (tr.isDnaCheck()) {
                    ++countCheckDna;
                }
                if (tr.hasTranscriptSupportLevelInfo()) {
                    ++countTsl;
                }
                int numCds = tr.getCds().size();
                int numExons = tr.subIntervals().size();
                ++countTranscripts;
                countExons += numExons;
                countCds += numCds;
                for (Exon e : tr) {
                    if (e.getSequence().isEmpty()) {
                        ++exonNoSeq;
                        continue;
                    }
                    ++exonSeq;
                }
                if (!tr.isProteinCoding()) continue;
                boolean hasError = false;
                boolean hasWarning = false;
                if (!tr.getUtrs().isEmpty()) {
                    ++countUtrs;
                }
                if (tr.isErrorProteinLength()) {
                    hasError = true;
                    ++errorProteinLength;
                    if (errors != null) {
                        errors.append("ERROR: Protein coding transcript '" + tr.getId() + "' has length " + tr.cds().length() + " (not mutiple of 3).\n");
                    }
                } else if (tr.isWarningStopCodon()) {
                    ++warningStopCodon;
                    hasWarning = true;
                    if (errors != null) {
                        errors.append("WARNING: Protein coding transcript '" + tr.getId() + "' last codon is not a STOP codon\n");
                    }
                }
                if (tr.isErrorStopCodonsInCds()) {
                    hasError = true;
                    ++errorProteinStopCodons;
                    if (errors != null) {
                        errors.append("ERROR: Protein coding transcript '" + tr.getId() + "' has STOP codons in non-last position\n");
                    }
                }
                if (tr.isErrorStartCodon()) {
                    hasError = true;
                    ++errorStartCodon;
                    if (errors != null) {
                        errors.append("ERROR: Protein coding transcript '" + tr.getId() + "' first codon is not a START codon\n");
                    }
                }
                if (hasError) {
                    ++errorTr;
                }
                if (errors == null || !hasError && !hasWarning) continue;
                errors.append(String.valueOf(tr) + "\n");
            }
        }
        double avgTrPerGene = (double)countTranscripts / (double)countGenes;
        double avgExonPerTr = (double)countExons / (double)countTranscripts;
        sb.append("#-----------------------------------------------\n");
        sb.append("# Genome name                : '" + this.species + "'\n");
        sb.append("# Genome version             : '" + this.version + "'\n");
        sb.append("# Genome ID                  : '" + this.getGenomeId() + "'\n");
        sb.append("# Has protein coding info    : " + this.hasCodingInfo() + "\n");
        sb.append("# Has Tr. Support Level info : " + this.hasTranscriptSupportLevelInfo() + "\n");
        sb.append("# Genes                      : " + countGenes + "\n");
        sb.append("# Protein coding genes       : " + countGenesProteinCoding + "\n");
        sb.append("#-----------------------------------------------\n");
        sb.append("# Transcripts                : " + countTranscripts + "\n");
        sb.append(String.format("# Avg. transcripts per gene  : %.2f", avgTrPerGene) + "\n");
        if (this.hasTranscriptSupportLevelInfo()) {
            sb.append("# TSL transcripts            : " + countTsl + "\n");
        }
        sb.append("#-----------------------------------------------\n");
        sb.append("# Checked transcripts        : \n");
        if (countTranscriptsProteinCoding > 0) {
            sb.append(String.format("#               AA sequences : %6d ( %.2f%% )\n", countCheckAa, 100.0 * (double)countCheckAa / (double)countTranscriptsProteinCoding));
        }
        if (countTranscripts > 0) {
            sb.append(String.format("#              DNA sequences : %6d ( %.2f%% )\n", countCheckDna, 100.0 * (double)countCheckDna / (double)countTranscripts));
        }
        sb.append("#-----------------------------------------------\n");
        sb.append("# Protein coding transcripts : " + countTranscriptsProteinCoding + "\n");
        if (countTranscriptsProteinCoding > 0) {
            sb.append(String.format("#              Length errors : %6d ( %.2f%% )\n", errorProteinLength, 100.0 * (double)errorProteinLength / (double)countTranscriptsProteinCoding));
            sb.append(String.format("#  STOP codons in CDS errors : %6d ( %.2f%% )\n", errorProteinStopCodons, 100.0 * (double)errorProteinStopCodons / (double)countTranscriptsProteinCoding));
            sb.append(String.format("#         START codon errors : %6d ( %.2f%% )\n", errorStartCodon, 100.0 * (double)errorStartCodon / (double)countTranscriptsProteinCoding));
            sb.append(String.format("#        STOP codon warnings : %6d ( %.2f%% )\n", warningStopCodon, 100.0 * (double)warningStopCodon / (double)countTranscriptsProteinCoding));
            sb.append(String.format("#              UTR sequences : %6d ( %.2f%% )\n", countUtrs, 100.0 * (double)countUtrs / (double)countTranscripts));
            sb.append(String.format("#               Total Errors : %6d ( %.2f%% )\n", errorTr, 100.0 * (double)errorTr / (double)countTranscriptsProteinCoding));
            if (countUtrs <= 0) {
                sb.append("# WARNING                    : No protein coding transcript has UTR\n");
            }
        }
        sb.append("#-----------------------------------------------\n");
        sb.append("# Cds                        : " + countCds + "\n");
        sb.append("# Exons                      : " + countExons + "\n");
        sb.append("# Exons with sequence        : " + exonSeq + "\n");
        sb.append("# Exons without sequence     : " + exonNoSeq + "\n");
        sb.append(String.format("# Avg. exons per transcript  : %.2f", avgExonPerTr) + "\n");
        ArrayList<Chromosome> mtChrs = new ArrayList<Chromosome>();
        for (Chromosome chr : this) {
            if (!chr.isMt()) continue;
            mtChrs.add(chr);
        }
        if (this.getChromosomes().size() > 1 && mtChrs.size() <= 0) {
            sb.append("# WARNING                    : No mitochondrion chromosome found\n");
        } else {
            for (Chromosome chr : mtChrs) {
                String mtCodonTable = chr.codonTable().getName();
                if (mtCodonTable.toUpperCase().indexOf("MITO") >= 0) continue;
                sb.append("# WARNING!                   : Mitochondrion chromosome '" + chr.getId() + "' does not have a mitochondrion codon table (codon table = '" + mtCodonTable + "'). You should update the config file.\n");
            }
        }
        sb.append("#-----------------------------------------------\n");
        sb.append("# Number of chromosomes      : " + this.getChromosomes().size() + "\n");
        sb.append("# Chromosomes                : Format 'chromo_name size codon_table'\n");
        for (Chromosome chr : this.getChromosomesSortedSize()) {
            sb.append("#\t\t'" + chr.getId() + "'\t" + chr.size() + "\t" + chr.getCodonTable().getName() + "\n");
        }
        if (countTranscriptsProteinCoding <= 0) {
            sb.append("\n# WARNING! : No protein coding transcripts found.\n");
        }
        sb.append("#-----------------------------------------------\n");
        return sb.toString();
    }
}

