/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.snpeff.interval.Chromosome;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Intergenic;
import org.snpeff.interval.Interval;
import org.snpeff.interval.IntervalComparatorByStart;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Log;

public class Genes
implements Iterable<Gene>,
Serializable {
    private static final long serialVersionUID = 9022385501946879197L;
    public boolean debug = false;
    Genome genome;
    HashMap<String, Gene> genesById = new HashMap();

    public Genes(Genome genome) {
        this.genome = genome;
    }

    public void add(Gene gene) {
        this.genesById.put(gene.getId(), gene);
    }

    public void createCircularGenes() {
        LinkedList<Gene> newGenes = new LinkedList<Gene>();
        for (Gene g : this.genome.getGenes()) {
            if (!g.isCircular()) continue;
            newGenes.add(g.circularClone());
        }
        if (!newGenes.isEmpty()) {
            for (Gene g : newGenes) {
                this.genome.getGenes().add(g);
            }
            if (Config.get().isVerbose()) {
                Log.info("Total: " + newGenes.size() + " added as circular mirrored genes (appended '_circ' to IDs).");
            }
        }
    }

    public List<Intergenic> createIntergenic() {
        Intergenic intergenic;
        ArrayList<Intergenic> intergenics = new ArrayList<Intergenic>(this.genesById.size());
        ArrayList<Gene> genesSorted = new ArrayList<Gene>(this.genesById.size());
        genesSorted.addAll(this.genesById.values());
        Collections.sort(genesSorted);
        Interval genePrev = null;
        Chromosome chrPrev = null;
        for (Gene gene : genesSorted) {
            Intergenic intergenic2;
            int end;
            int start;
            if (chrPrev != gene.getChromosome()) {
                Intergenic intergenic3;
                if (chrPrev != null && genePrev != null && (intergenic3 = Intergenic.createIntergenic((Gene)genePrev, null)) != null) {
                    intergenics.add(intergenic3);
                }
                genePrev = null;
            }
            if ((start = genePrev != null ? genePrev.getEnd() + 1 : 0) < (end = gene.getStart() - 1) && (intergenic2 = Intergenic.createIntergenic((Gene)genePrev, gene)) != null) {
                intergenics.add(intergenic2);
            }
            if (genePrev == null || gene.getEnd() > genePrev.getEnd()) {
                genePrev = gene;
            }
            chrPrev = gene.getChromosome();
        }
        if (genePrev != null && (intergenic = Intergenic.createIntergenic(genePrev, null)) != null) {
            intergenics.add(intergenic);
        }
        return intergenics;
    }

    public void createSpliceSites(int spliceSiteSize, int spliceRegionExonSize, int spliceRegionIntronMin, int spliceRegionIntronMax) {
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                tr.createSpliceSites(spliceSiteSize, spliceRegionExonSize, spliceRegionIntronMin, spliceRegionIntronMax);
            }
        }
    }

    public List<Marker> createUpDownStream(int upDownLength) {
        ArrayList<Marker> list = new ArrayList<Marker>();
        if (upDownLength <= 0) {
            return list;
        }
        for (Gene gene : this) {
            for (Transcript tr : gene) {
                tr.createUpDownStream(upDownLength);
                list.add(tr.getUpstream());
                list.add(tr.getDownstream());
            }
        }
        return list;
    }

    public Transcript findTranscript(String trId) {
        for (Gene g : this) {
            for (Transcript tr : g) {
                if (!tr.getId().equals(trId)) continue;
                return tr;
            }
        }
        return null;
    }

    public Gene get(String geneId) {
        return this.genesById.get(geneId);
    }

    public Gene getGeneByName(String geneName) {
        for (Gene g : this) {
            if (!g.getGeneName().equals(geneName)) continue;
            return g;
        }
        return null;
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genesById.values().iterator();
    }

    public int size() {
        return this.genesById.size();
    }

    public Collection<Gene> sorted() {
        ArrayList<Gene> genes = new ArrayList<Gene>();
        genes.addAll(this.genesById.values());
        Collections.sort(genes, new IntervalComparatorByStart());
        return genes;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (Gene gint : this) {
            sb.append(String.valueOf(gint) + "\n");
        }
        return sb.toString();
    }

    public Collection<Gene> values() {
        return this.genesById.values();
    }
}

