/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import java.util.ArrayList;
import org.snpeff.interval.Marker;
import org.snpeff.interval.MarkerSeq;
import org.snpeff.interval.MarkerWithFrame;
import org.snpeff.interval.Markers;
import org.snpeff.interval.SpliceSite;
import org.snpeff.interval.SpliceSiteRegion;
import org.snpeff.interval.Transcript;
import org.snpeff.interval.Variant;
import org.snpeff.interval.VariantNonRef;
import org.snpeff.interval.codonChange.CodonChange;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.Config;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.snpEffect.VariantEffects;
import org.snpeff.util.Log;

public class Exon
extends MarkerSeq
implements MarkerWithFrame {
    public static int ToStringVersion = 2;
    private static final long serialVersionUID = 5324352193278472543L;
    byte frame = (byte)-1;
    int rank;
    int aaIdxStart = -1;
    int aaIdxEnd = -1;
    ArrayList<SpliceSite> spliceSites;
    ExonSpliceType spliceType = ExonSpliceType.NONE;

    public Exon() {
        this.rank = 0;
        this.type = EffectType.EXON;
        this.spliceSites = new ArrayList();
    }

    public Exon(Transcript parent, int start, int end, boolean strandMinus, String id, int rank) {
        super(parent, start, end, strandMinus, id);
        this.strandMinus = strandMinus;
        this.rank = rank;
        this.type = EffectType.EXON;
        this.spliceSites = new ArrayList();
    }

    public void add(SpliceSite ss) {
        this.spliceSites.add(ss);
    }

    @Override
    public Exon apply(Variant variant) {
        if (!this.shouldApply(variant)) {
            return this;
        }
        Exon newEx = (Exon)super.apply(variant);
        if (newEx == null) {
            return null;
        }
        newEx.reset();
        return newEx;
    }

    @Override
    public Exon cloneShallow() {
        Exon clone = (Exon)super.cloneShallow();
        clone.frame = this.frame;
        clone.rank = this.rank;
        clone.spliceType = this.spliceType;
        return clone;
    }

    public SpliceSiteRegion createSpliceSiteRegionEnd(int size) {
        if (size > this.size()) {
            size = this.size();
        }
        if (size <= 0) {
            return null;
        }
        SpliceSiteRegion spliceSiteRegionEnd = null;
        spliceSiteRegionEnd = this.isStrandPlus() ? new SpliceSiteRegion(this, this.end - (size - 1), this.end, this.strandMinus, this.id) : new SpliceSiteRegion(this, this.start, this.start + (size - 1), this.strandMinus, this.id);
        if (spliceSiteRegionEnd != null) {
            this.add(spliceSiteRegionEnd);
        }
        return spliceSiteRegionEnd;
    }

    public SpliceSiteRegion createSpliceSiteRegionStart(int size) {
        if (size > this.size()) {
            size = this.size();
        }
        if (size <= 0) {
            return null;
        }
        SpliceSiteRegion spliceSiteRegionStart = null;
        spliceSiteRegionStart = this.isStrandPlus() ? new SpliceSiteRegion(this, this.start, this.start + (size - 1), this.strandMinus, this.id) : new SpliceSiteRegion(this, this.end - (size - 1), this.end, this.strandMinus, this.id);
        if (spliceSiteRegionStart != null) {
            this.add(spliceSiteRegionStart);
        }
        return spliceSiteRegionStart;
    }

    public boolean frameCorrection(int frameCorrection) {
        if (frameCorrection <= 0) {
            return true;
        }
        if (this.size() <= frameCorrection) {
            Log.warning(ErrorWarningType.WARNING_EXON_TOO_SHORT, "Exon too short (size: " + this.size() + "), cannot correct frame!\n" + String.valueOf(this));
            return false;
        }
        if (Config.get().isDebug()) {
            Log.debug("Frame correction: " + this.toStr());
        }
        if (this.isStrandPlus()) {
            this.start += frameCorrection;
        } else {
            this.end -= frameCorrection;
        }
        this.frame = (byte)((this.frame - frameCorrection) % 3);
        while (this.frame < 0) {
            this.frame = (byte)(this.frame + 3);
        }
        String sequence = this.getSequence();
        if (sequence.length() >= frameCorrection) {
            sequence = sequence.substring(frameCorrection);
        }
        this.setSequence(sequence);
        return true;
    }

    public int getAaIdxEnd() {
        return this.aaIdxEnd;
    }

    public int getAaIdxStart() {
        return this.aaIdxStart;
    }

    @Override
    public int getFrame() {
        return this.frame;
    }

    public int getRank() {
        return this.rank;
    }

    public ArrayList<SpliceSite> getSpliceSites() {
        return this.spliceSites;
    }

    public ExonSpliceType getSpliceType() {
        return this.spliceType;
    }

    @Override
    protected boolean isAdjustIfParentDoesNotInclude(Marker parent) {
        return true;
    }

    @Override
    public Markers query(Marker marker) {
        Markers markers = new Markers();
        for (SpliceSite ss : this.spliceSites) {
            if (!ss.intersects(marker)) continue;
            markers.add(ss);
        }
        return markers;
    }

    public void reset() {
        this.spliceSites = new ArrayList();
    }

    public ErrorWarningType sanityCheck(Variant variant) {
        String refStr;
        if (!this.intersects(variant)) {
            return null;
        }
        if (variant.getVariantType() != Variant.VariantType.SNP && variant.getVariantType() != Variant.VariantType.MNP) {
            return null;
        }
        int mstart = Math.max(variant.getStart(), this.start);
        int idxStart = mstart - this.start;
        if (this.sequence.length() <= 0) {
            return ErrorWarningType.WARNING_SEQUENCE_NOT_AVAILABLE;
        }
        if (idxStart >= this.sequence.length()) {
            return ErrorWarningType.ERROR_OUT_OF_EXON;
        }
        int mend = Math.min(variant.getEnd(), this.end);
        int len = mend - mstart + 1;
        String realReference = this.basesAt(idxStart, len).toUpperCase();
        int varRefStart = mstart - variant.getStart();
        if (varRefStart < 0) {
            return ErrorWarningType.ERROR_OUT_OF_EXON;
        }
        int varRefEnd = mend - variant.getStart();
        if (varRefEnd >= (refStr = variant.isNonRef() ? ((VariantNonRef)variant).getVariantRef().getAlt() : variant.getReference()).length()) {
            return ErrorWarningType.ERROR_OUT_OF_EXON;
        }
        String variantReference = refStr.substring(varRefStart, varRefEnd + 1);
        if (!realReference.equals(variantReference)) {
            return ErrorWarningType.WARNING_REF_DOES_NOT_MATCH_GENOME;
        }
        return null;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.frame = (byte)markerSerializer.getNextFieldInt();
        this.rank = markerSerializer.getNextFieldInt();
        this.setSequence(markerSerializer.getNextField());
        String exType = markerSerializer.getNextField();
        if (exType != null && !exType.isEmpty()) {
            this.spliceType = ExonSpliceType.valueOf(exType);
        }
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.frame + "\t" + this.rank + "\t" + String.valueOf(this.sequence) + "\t" + (this.spliceType != null ? this.spliceType.toString() : "");
    }

    public void setAaIdx(int aaIdxStart, int aaIdxEnd) {
        this.aaIdxStart = aaIdxStart;
        this.aaIdxEnd = aaIdxEnd;
    }

    @Override
    public void setFrame(int frame) {
        if (frame > 2 || frame < -1) {
            throw new RuntimeException("Invalid frame value: " + frame);
        }
        this.frame = (byte)frame;
    }

    public void setRank(int rank) {
        this.rank = rank;
    }

    @Override
    public String toString() {
        switch (ToStringVersion) {
            case 1: {
                return this.getChromosomeName() + ":" + this.start + "-" + this.end + (String)(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + " rank:" + this.rank + (String)(this.sequence != null ? ", sequence: " + String.valueOf(this.sequence) : "");
            }
            case 2: {
                return this.getChromosomeName() + ":" + this.start + "-" + this.end + (String)(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + ", rank: " + this.rank + ", frame: " + (String)(this.frame >= 0 ? "" + this.frame : ".") + (String)(this.sequence != null ? ", sequence: " + String.valueOf(this.sequence) : "");
            }
        }
        throw new RuntimeException("Unknown format version: " + ToStringVersion);
    }

    @Override
    public boolean variantEffect(Variant variant, VariantEffects variantEffects) {
        if (!this.intersects(variant)) {
            return false;
        }
        Transcript tr = (Transcript)this.parent;
        boolean coding = tr.isProteinCoding() || Config.get().isTreatAllAsProteinCoding();
        boolean exonAnnotated = false;
        if (!coding || variant.isInterval() || !variant.isVariant()) {
            variantEffects.add(variant, this, EffectType.EXON, "");
            exonAnnotated = true;
        } else if (tr.isCds(variant)) {
            CodonChange codonChange = CodonChange.factory(variant, tr, variantEffects);
            codonChange.codonChange();
            exonAnnotated = true;
        }
        for (SpliceSite ss : this.spliceSites) {
            if (!ss.intersects(variant)) continue;
            ss.variantEffect(variant, variantEffects);
        }
        return exonAnnotated;
    }

    public static enum ExonSpliceType {
        NONE,
        RETAINED,
        SKIPPED,
        ALTTENATIVE_3SS,
        ALTTENATIVE_5SS,
        MUTUALLY_EXCLUSIVE,
        ALTTENATIVE_PROMOMOTER,
        ALTTENATIVE_POLY_A;

    }
}

