/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.fileIterator.BedFileIterator;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Variant;
import org.snpeff.interval.tree.IntervalForest;
import org.snpeff.interval.tree.Itree;
import org.snpeff.snpEffect.Config;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class CytoBands {
    public static final String DEFAULT_CYTOBAND_BED_FILE = "cytoBand.txt.gz";
    boolean verbose;
    boolean debug;
    Genome genome;
    IntervalForest forest;

    public CytoBands(Genome genome) {
        Config config = Config.get();
        this.genome = genome;
        this.verbose = config.isVerbose();
        this.debug = config.isDebug();
        this.forest = new IntervalForest();
        String cytoBandFile = config.getDirDataGenomeVersion() + "/cytoBand.txt.gz";
        if (Gpr.exists(cytoBandFile)) {
            this.load(cytoBandFile);
        } else if (this.debug) {
            Log.debug("Cannot open file '" + cytoBandFile + "', not loadng cytobands");
        }
    }

    public void add(Marker m) {
        this.forest.add(m);
    }

    public void build() {
        this.forest.build();
    }

    public boolean isEmpty() {
        return this.forest.size() <= 0;
    }

    void load(String bedFile) {
        if (this.verbose) {
            Log.info("Loading cytobands form file '" + bedFile + "'");
        }
        BedFileIterator bed = new BedFileIterator(bedFile);
        int count = 0;
        for (Variant var : bed) {
            this.add(var);
            ++count;
        }
        if (this.verbose) {
            if (count <= 0) {
                Log.info("WARNING: Unable to load cytobands from file '" + bedFile + "'");
            } else {
                Log.info("Loaded " + count + " cytoband intervals");
            }
        }
        this.build();
    }

    public Markers query(Marker marker) {
        return this.forest.query(marker);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Cytobands for " + this.genome.getId() + " : " + (this.isEmpty() ? "[Empty]" : "") + "\n");
        for (Itree tree : this.forest) {
            for (Marker m : tree) {
                sb.append("\t" + m.getChromosomeName() + "\t" + m.getStart() + "\t" + m.getEnd() + "\t" + m.getId() + "\n");
            }
        }
        return sb.toString();
    }
}

