/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.interval.Marker;
import org.snpeff.interval.Markers;
import org.snpeff.interval.Transcript;

public class CircularCorrection {
    boolean debug;
    boolean corrected;
    boolean correctLargeGap = false;
    Transcript tr;
    int chrLen;

    public CircularCorrection(Transcript tr) {
        this.tr = tr;
        this.chrLen = tr.getChromosome().size();
    }

    public CircularCorrection(Transcript tr, int chrLen) {
        this.tr = tr;
        this.chrLen = chrLen;
    }

    public boolean correct() {
        Markers cdss = new Markers(this.tr.getCds());
        if (this.correct(cdss)) {
            this.corrected = true;
            this.tr.sortCds();
        }
        Markers exons = new Markers(this.tr.subIntervals());
        this.corrected |= this.correct(exons);
        if (this.corrected) {
            this.tr.deleteRedundant();
        }
        return this.corrected;
    }

    boolean correct(Markers markers) {
        boolean corr = false;
        if (this.isCorrectionStartAfterEnd(markers)) {
            corr |= this.correctStartAfterEnd(markers);
        }
        if (this.isCorrectionAfterChrEnd(markers)) {
            corr |= this.correctAfterChrEnd(markers);
        }
        if (this.isCorrectionLargeGap(markers)) {
            corr |= this.correctLargeGap(markers);
        }
        return corr;
    }

    boolean correctAfterChrEnd(Markers markers) {
        boolean corr = false;
        for (Marker m : markers) {
            if (m.getStart() <= 0) continue;
            m.shiftCoordinates(-this.chrLen);
            corr = true;
        }
        return corr;
    }

    boolean correctLargeGap(Markers markers) {
        Marker rightGap = this.findLargeGap(markers);
        int gapPos = rightGap.getStart();
        boolean corr = false;
        for (Marker m : markers) {
            if (m.getStart() < gapPos) continue;
            m.shiftCoordinates(-this.chrLen);
            corr = true;
        }
        return corr;
    }

    boolean correctStartAfterEnd(Markers markers) {
        boolean corr = false;
        for (Marker m : markers) {
            if (!this.isCorrectionStartAfterEnd(m)) continue;
            m.setStart(m.getStart() - this.chrLen);
            corr = true;
        }
        return corr;
    }

    Marker findLargeGap(Markers markers) {
        int maxGap = 0;
        int endPrev = -1;
        boolean first = true;
        Marker rightGap = null;
        for (Marker m : markers.sort()) {
            int gap;
            if (!first && maxGap < (gap = m.getStart() - endPrev)) {
                maxGap = gap;
                rightGap = m;
            }
            endPrev = m.getEnd();
            first = false;
        }
        return rightGap;
    }

    public boolean isCorrected() {
        return this.corrected;
    }

    boolean isCorrectionAfterChrEnd(Marker m) {
        return m.getStart() >= this.chrLen || m.getEnd() >= this.chrLen;
    }

    boolean isCorrectionAfterChrEnd(Markers ms) {
        for (Marker m : ms) {
            if (!this.isCorrectionAfterChrEnd(m)) continue;
            return true;
        }
        return false;
    }

    boolean isCorrectionLargeGap(Markers markers) {
        if (!this.correctLargeGap) {
            return false;
        }
        if (markers.size() <= 1) {
            return false;
        }
        int maxGap = 0;
        int endPrev = -1;
        boolean first = true;
        for (Marker m : markers.sort()) {
            if (!first) {
                int gap = m.getStart() - endPrev;
                maxGap = Math.max(maxGap, gap);
            }
            endPrev = m.getEnd();
            first = false;
        }
        return maxGap > this.chrLen / 2;
    }

    boolean isCorrectionStartAfterEnd(Marker m) {
        return m.getStart() > m.getEnd();
    }

    boolean isCorrectionStartAfterEnd(Markers ms) {
        for (Marker m : ms) {
            if (!this.isCorrectionStartAfterEnd(m)) continue;
            return true;
        }
        return false;
    }

    public boolean isDebug() {
        return this.debug;
    }

    boolean needsCorrection(Markers markers) {
        return this.isCorrectionAfterChrEnd(markers) || this.isCorrectionStartAfterEnd(markers) || this.isCorrectionLargeGap(markers);
    }

    public void setCorrectLargeGap(boolean correctLargeGap) {
        this.correctLargeGap = correctLargeGap;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        Markers cdss = new Markers(this.tr.getCds());
        Markers exons = new Markers(this.tr.subIntervals());
        sb.append("Circular correction\n");
        sb.append("\n\tCorrected :" + this.corrected);
        sb.append("\n\tChr len   :" + this.chrLen);
        sb.append("\n\tCDS corrections :");
        sb.append("\n\t\tAfter Chr End   :" + this.isCorrectionAfterChrEnd(cdss));
        sb.append("\n\t\tLarge Gap       :" + this.isCorrectionLargeGap(cdss));
        sb.append("\n\t\tStart After End :" + this.isCorrectionStartAfterEnd(cdss));
        sb.append("\n\tExons corrections :");
        sb.append("\n\t\tAfter Chr End   :" + this.isCorrectionAfterChrEnd(exons));
        sb.append("\n\t\tLarge Gap       :" + this.isCorrectionLargeGap(exons));
        sb.append("\n\t\tStart After End :" + this.isCorrectionStartAfterEnd(exons));
        sb.append("\n\tTranscript :\n" + String.valueOf(this.tr));
        sb.append("\n\tCDSs:\n" + String.valueOf(cdss));
        return sb.toString();
    }
}

