/*
 * Decompiled with CFR 0.152.
 */
package org.snpeff.interval;

import org.snpeff.binseq.DnaSequence;
import org.snpeff.codons.CodonTable;
import org.snpeff.codons.CodonTables;
import org.snpeff.interval.ChromosomeSimpleName;
import org.snpeff.interval.Exon;
import org.snpeff.interval.Gene;
import org.snpeff.interval.Genome;
import org.snpeff.interval.Interval;
import org.snpeff.interval.Marker;
import org.snpeff.interval.Transcript;
import org.snpeff.serializer.MarkerSerializer;
import org.snpeff.snpEffect.EffectType;
import org.snpeff.snpEffect.ErrorWarningType;
import org.snpeff.util.Gpr;
import org.snpeff.util.Log;

public class Chromosome
extends Marker {
    private static final long serialVersionUID = 1636197649250882952L;
    double chromosomeNum;
    DnaSequence sequence = null;
    boolean circular;

    public static int compare(String chr1, String chr2) {
        int chr1Num = Chromosome.number(chr1);
        int chr2Num = Chromosome.number(chr2);
        if (chr1Num > 0 && chr2Num > 0) {
            return chr1Num - chr2Num;
        }
        if (chr1Num > 0 && chr2Num <= 0) {
            return -1;
        }
        if (chr1Num <= 0 && chr2Num > 0) {
            return 1;
        }
        return Chromosome.simpleName(chr1).compareTo(Chromosome.simpleName(chr2));
    }

    public static int number(String chrName) {
        return Gpr.parseIntSafe(ChromosomeSimpleName.get(chrName));
    }

    public static String simpleName(String chrName) {
        return ChromosomeSimpleName.get(chrName);
    }

    public Chromosome() {
    }

    public Chromosome(Genome parent, int start, int end, String id) {
        super(null, start, end, false, id);
        this.parent = parent;
        this.type = EffectType.CHROMOSOME;
        this.circular = false;
        this.setChromosomeName(id);
    }

    @Override
    public Chromosome cloneShallow() {
        Chromosome clone = (Chromosome)super.cloneShallow();
        clone.chromosomeNum = this.chromosomeNum;
        clone.circular = this.circular;
        return clone;
    }

    public int compareChromoName(Interval interval) {
        Chromosome i2 = (Chromosome)interval;
        if (this.chromosomeNum == 0.0 && i2.chromosomeNum == 0.0) {
            return this.id.compareTo(i2.id);
        }
        if (this.chromosomeNum != 0.0 && i2.chromosomeNum == 0.0) {
            return -1;
        }
        if (this.chromosomeNum == 0.0 && i2.chromosomeNum != 0.0) {
            return 1;
        }
        if (this.chromosomeNum - i2.chromosomeNum < 0.0) {
            return -1;
        }
        if (this.chromosomeNum - i2.chromosomeNum > 0.0) {
            return 1;
        }
        return 0;
    }

    public boolean detectCircular() {
        String chr = this.getChromosomeName();
        int chrLen = this.size();
        for (Gene gene : this.getGenome().getGenes()) {
            if (!gene.getChromosomeName().equalsIgnoreCase(chr)) continue;
            for (Transcript tr : gene) {
                for (Exon exon : tr) {
                    int ssStart = exon.getStart();
                    int ssEnd = exon.getEnd() + 1;
                    if (ssStart >= 0 && ssEnd <= chrLen) continue;
                    if (ssStart < 0 && ssEnd > 0) {
                        this.circular = true;
                        Log.warning(ErrorWarningType.WARNING_CHROMOSOME_CIRCULAR, "Chromosome '" + chr + "' (len=" + this.size() + ") has exon with negative start coordinate: Marking as 'circular'. Exon:" + String.valueOf(exon));
                        return this.circular;
                    }
                    if (ssStart < 0 && ssEnd < 0) {
                        this.circular = true;
                        Log.warning(ErrorWarningType.WARNING_CHROMOSOME_CIRCULAR, "Chromosome '" + chr + "' (len=" + this.size() + ") has exon with negative coordinates: Marking as 'circular'. Exon:" + String.valueOf(exon));
                        return this.circular;
                    }
                    if (ssEnd <= chrLen) continue;
                    this.circular = true;
                    Log.warning(ErrorWarningType.WARNING_CHROMOSOME_CIRCULAR, "Chromosome '" + chr + "' (len=" + this.size() + ") has exon with end coordinate after chromosome end: Marking as 'circular'. Exon:" + String.valueOf(exon));
                    return this.circular;
                }
            }
        }
        return this.circular;
    }

    public CodonTable getCodonTable() {
        return CodonTables.getInstance().getTable(this.getGenome(), this.getId());
    }

    public DnaSequence getDnaSequence() {
        return this.sequence;
    }

    public String getSequence() {
        return this.sequence.toString();
    }

    @Override
    public boolean isCircular() {
        return this.circular;
    }

    public boolean isMt() {
        String iduc = this.id.toUpperCase();
        return iduc.equals("M") || iduc.startsWith("MT") || iduc.indexOf("MITO") >= 0;
    }

    @Override
    protected boolean isShowWarningIfParentDoesNotInclude() {
        return false;
    }

    @Override
    public void serializeParse(MarkerSerializer markerSerializer) {
        super.serializeParse(markerSerializer);
        this.setChromosomeName(this.id);
        this.circular = markerSerializer.getNextFieldBoolean();
    }

    @Override
    public String serializeSave(MarkerSerializer markerSerializer) {
        return super.serializeSave(markerSerializer) + "\t" + this.circular;
    }

    private void setChromosomeName(String chromo) {
        this.id = Chromosome.simpleName(chromo);
        this.chromosomeNum = Gpr.parseIntSafe(this.id);
    }

    public void setCircular(boolean circular) {
        this.circular = circular;
    }

    public void setLength(int len) {
        this.end = len - 1;
    }

    public void setSequence(String sequenceStr) {
        this.sequence = new DnaSequence(sequenceStr, true);
        this.setLength(sequenceStr.length());
    }

    @Override
    public String toString() {
        return this.getChromosomeName() + "\t" + this.start + "-" + this.end + " " + String.valueOf((Object)this.type) + (String)(this.id != null && this.id.length() > 0 ? " '" + this.id + "'" : "") + (this.circular ? " [Cicular]" : "");
    }
}

